<?php

namespace App\Http\Controllers;

use App\Basic;
use App\Imports\ImportNumbers;
use App\Imports\ImportNumbersWithMessage;
use App\Models\Contact;
use App\Models\SmsConfig;
use App\Models\SmsTemplete;
use App\Models\User;
use App\Models\YeasterConfig;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\View;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Support\Facades\Session;
use Sabberworm\CSS\Property\Import;

class SmsController extends Controller
{
    //sms config
    public function indexSmsConfig()
    {
        $data['sms_configs'] = SmsConfig::latest()->get();
        return view('back-end.sms.indexSmsConfig', $data);
    }
    //sms config store
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:100',
            'api_url' => 'required|string|max:50',
            'api_key' => 'required|string|max:50',
            'sender_id' => 'required|string|max:50',
            'type' => 'required|string|max:50',
        ]);

        $config = new SmsConfig();

        $config->name = $request->name;
        $config->api_url = $request->api_url;
        $config->api_key = $request->api_key;
        $config->sender_id = $request->sender_id;
        $config->type = $request->type;
        $config->status = 0;
        $config->created_by = Auth::id();
        $config->save();

        if ($config == true) {
            $notification = [
                'success' => 'Config Save Successfully',
            ];
        } else {
            $notification = [
                'error' => 'Opps! Something is wrong...!',
            ];
        }

        return redirect()->back()->with($notification);
    }
    //sms config store
    public function update(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:100',
            'api_url' => 'required|string|max:50',
            'api_key' => 'required|string|max:50',
            'sender_id' => 'required|string|max:50',
            'type' => 'required|string|max:50',
        ]);

        $config = SmsConfig::findOrFail($request->id);

        $config->name = $request->name;
        $config->api_url = $request->api_url;
        $config->api_key = $request->api_key;
        $config->sender_id = $request->sender_id;
        $config->type = $request->type;
        $config->updated_by = Auth::id();
        $config->save();

        if ($config == true) {
            $notification = [
                'success' => 'Config Update Successfully',
            ];
        } else {
            $notification = [
                'error' => 'Opps! Something is wrong...!',
            ];
        }

        return redirect()->back()->with($notification);
    }

    public function delete($config_id)
    {
        SmsConfig::findOrFail($config_id)->delete();
        return redirect()->back();
    }

    public function sendSmsList(Request $request)
    {
        $basic = Basic::find(1);
        $data['request'] = $request;
        $data['users'] = User::orderBy('name', 'ASC')->get();
        $date = Carbon::parse($request->date_time)->format('Y-m-d');
        // dd($request->user_id);
        $data['contacts'] = Contact::orderBy('date_time', 'desc')
            ->with('user')
            ->when(isset($request->sms_id), function ($query) use ($request) {
                $query->where('sms_id', $request->sms_id);
            })
            ->when(isset($request->sender_id), function ($query) use ($request) {
                $query->where('sender_id', $request->sender_id);
            })
            ->when(isset($request->recipient_phone_number), function ($query) use ($request) {
                $query->where('recipient_phone_number', 'like', '%' . $request->recipient_phone_number . '%');
            })
            ->when(isset($request->user_id), function ($query) use ($request) {
                $query->where('created_by', $request->user_id);
            })
            ->when(isset($request->date_time), function ($query) use ($date) {
                $query->whereDate('date_time', 'like', '%' . $date . '%');
            })
            // ->when(isset($request->active_status) && $request->active_status !=2, function ($query) use ($request) {
            //     $query->where('active_status', $request->active_status);
            // })
            ->when(
                function ($query) use ($request) {
                    return Arr::get($request, 'active_status', 1) != 2;
                },
                function ($query) use ($request) {
                    $query->where('active_status', Arr::get($request, 'active_status', 1));
                },
            )
            ->paginate($basic->pagination_limit);
        return view('back-end.sms.indexSms', $data);
    }

    public function sendSms()
    {
        return view('back-end.sms.sendSms');
    }

    public function smsSendCount(Request $request)
    {
        $data['request'] = $request;
        $start_date = isset($request->start_date) ? Carbon::parse($request->start_date)->format('Y-m-d') : null;
        $end_date = isset($request->end_date) ? Carbon::parse($request->end_date)->format('Y-m-d') : null;

        $data['total_sms'] = Contact::where('created_by', '!=', 0)
            ->when($start_date && $end_date, function ($query) use ($start_date, $end_date) {
                $query->whereDate('date_time', '>=', $start_date)->whereDate('date_time', '<=', $end_date);
            })
            ->where('active_status', '!=', 0)
            ->count();
       
        $data['users'] = User::orderBy('name', 'asc')->get();
    
        return view('back-end.sms.smsSendCountFile', $data);
    }

    public function showListOfSendSms(Request $request)
    {
        try {
            $basic = Basic::find(1);
            $data['request'] = $request;
            $data['user'] = User::findOrFail($request->user_id);

            $start_date = isset($request->start_date) ? Carbon::parse($request->start_date)->format('Y-m-d') : null;
            $end_date = isset($request->end_date) ? Carbon::parse($request->end_date)->format('Y-m-d') : null;

            $data['contacts'] = Contact::where('created_by', $request->user_id)
                ->when(isset($request->sender_id), function ($query) use ($request) {
                    $query->where('sender_id', $request->sender_id);
                })
                ->when(isset($request->sms_id), function ($query) use ($request) {
                    $query->where('sms_id', $request->sms_id);
                })
                ->when(isset($request->recipient_phone_number), function ($query) use ($request) {
                    $query->where('recipient_phone_number', 'like', '%' . $request->recipient_phone_number . '%');
                })
                ->when($start_date && $end_date, function ($query) use ($start_date, $end_date) {
                    $query->whereDate('date_time', '>=', $start_date)->whereDate('date_time', '<=', $end_date);
                })
                ->paginate($basic->pagination_limit);

            $html = View::make('back-end.sms.listOfShowSmsRender', $data)->render();

            return response()->json(['data' => $html]);
        } catch (\Exception $e) {
            return response()->json(['error' => $e->getMessage()], 500);
        }
    }

    public function listOfSendSms($user_id, Request $request)
    {
        $basic = Basic::find(1);
        $data['request'] = $request;
        $data['user'] = User::findOrFail($user_id);

        $start_date = isset($request->start_date) ? Carbon::parse($request->start_date)->format('Y-m-d') : null;
        $end_date = isset($request->end_date) ? Carbon::parse($request->end_date)->format('Y-m-d') : null;

        $data['contacts'] = Contact::where('created_by', $user_id)
            ->when(isset($request->sender_id), function ($query) use ($request) {
                $query->where('sender_id', $request->sender_id);
            })
            ->when(isset($request->recipient_phone_number), function ($query) use ($request) {
                $query->where('recipient_phone_number', 'like', '%' . $request->recipient_phone_number . '%');
            })
            ->when($start_date && $end_date, function ($query) use ($start_date, $end_date) {
                $query->whereDate('date_time', '>=', $start_date)->whereDate('date_time', '<=', $end_date);
            })
            ->paginate($basic->pagination_limit);

        return view('back-end.sms.listOfSendSms', $data);
    }

    // public function sendManualSms(Request $request)
    // {
    //     if ($request->template_status == 2) {
    //         $template = $request->message;
    //     } else {
    //         $is_active_template = SmsTemplete::where('active_status', 1)->first();
    //         if ($is_active_template) {
    //             $template = $is_active_template->message;
    //         } else {
    //             $template = null;
    //         }
    //     }

    //     $config = SmsConfig::where('default_send_status', 1)->first();
    //     if (!empty($template)) {
    //         $stringFormat = $request->numbers;
    //         preg_match_all('/\d+/', $stringFormat, $matches);
    //         $numbers = $matches[0];

    //         for ($i = 0; $i < count($numbers); $i++) {
    //             sms($numbers[$i], $template, $config);

    //             $contact = Contact::where('recipient_phone_number', $numbers[$i])
    //                 ->where('active_status', 0)
    //                 ->first();
    //             if (!$contact) {
    //                 $contact = new Contact();
    //             }

    //             $contact->date_time = Carbon::now();
    //             $contact->sender_id = $config->sender_id;
    //             $contact->recipient_phone_number = $numbers[$i];
    //             $contact->sms_content = $template;
    //             $contact->active_status = 1;
    //             $contact->created_by = Auth::id();
    //             $contact->save();
    //         }

    //         $notification = [
    //             'success' => 'Sms Send Successfully',
    //         ];

    //         return redirect()->back()->with($notification);
    //     } else {
    //         $notification = [
    //             'error' => 'Opps! Something is wrong...!',
    //         ];
    //     }

    //     return redirect()->back()->with($notification);
    // }

    public function sendManualSms(Request $request)
    {
        if ($request->template_status == 2) {
            $template = $request->message;
        } else {
            $is_active_template = SmsTemplete::where('active_status', 1)->first();
            if ($is_active_template) {
                $template = $is_active_template->message;
            } else {
                $template = null;
            }
        }

        $config = SmsConfig::where('default_send_status', 1)->first();
        if (!empty($template)) {
            $stringFormat = $request->numbers;
            preg_match_all('/\d+/', $stringFormat, $matches);
            $numbers = $matches[0];

            for ($i = 0; $i < count($numbers); $i++) {
                $sms = smsSend($numbers[$i], $template, $config);
                $smsData = json_decode($sms->getContent(), true);
                

                if ($smsData['status'] === 'success') {
                    $contact = Contact::where('recipient_phone_number', $numbers[$i])
                        ->where('active_status', 0)
                        ->first();
                    if (!$contact) {
                        $contact = new Contact();
                    }

                    $contact->date_time = Carbon::now();
                    $contact->sender_id = $config->sender_id;
                    $contact->recipient_phone_number = $numbers[$i];
                    $contact->sms_content = $template;
                    $contact->active_status = 1;
                    $contact->created_by = Auth::id();
                    $contact->save();

                    
                    $notification = [
                        'success' => 'Sms Send Successfully',
                    ];
                } else {
                    if ($smsData['status'] === 'error') {
                        $notification = [
                            'error' => $smsData['message'],
                        ];
                    } else {
                        $notification = [
                            'error' => "SMS did not send",
                        ];
                    }
                    
                }
            
            }
            

            return redirect()->back()->with($notification);
        } else {
            $notification = [
                'error' => 'Opps! Something is wrong...!',
            ];
        }

        return redirect()->back()->with($notification);
    }
    public function getContact()
    {
        ini_set('memory_limit', '256M');
        $config = YeasterConfig::latest()->first();
        $smsConfig = SmsConfig::latest()->first();

        $yeasterToken = yeaster_token();

        $curl = curl_init();

        curl_setopt_array($curl, [
            CURLOPT_URL => 'https://doctormobile.linkuspbx.com/openapi/v1.0/cdr/list?access_token=' . $yeasterToken . '&sort_by=id&order_by=desc&status=ANSWERED&call_type=Outbound',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ]);

        $response = curl_exec($curl);

        curl_close($curl);
        // Decode the JSON response
        $data = json_decode($response, true);

        // Check if decoding was successful
        if (json_last_error() !== JSON_ERROR_NONE) {
            $notification = ['error' => 'Oops! Something is wrong...!'];

            return redirect()->back()->with($notification);
        }

        $filterParams = [
            'disposition' => $config->call_status,
            'call_type' => $config->communication_type,
            'call_duration' => $config->call_duration,
        ];

        $filteredData = array_filter($data['data'], function ($call) use ($filterParams) {
            return $call['disposition'] === $filterParams['disposition'] && $call['call_type'] === $filterParams['call_type'] && $call['duration'] >= $filterParams['call_duration'];
        });

        usort($filteredData, function ($a, $b) {
            return $b['id'] - $a['id'];
        });

        $existingNumbers = Contact::whereIn('recipient_phone_number', collect($filteredData)->pluck('call_to_number')->toArray())
            ->pluck('recipient_phone_number')
            ->toArray();

        // $contactsToInsert = collect($filteredData)->reject(function ($yeasterContact) use ($existingNumbers) {
        //     return in_array($yeasterContact['call_to_number'], $existingNumbers);
        // });

        // $contactsToInsert = collect($filteredData)->reject(function ($yeasterContact) use ($existingNumbers) {
        //     $cleanedNumber = str_replace('+', '', $yeasterContact['call_to_number']);
        //     return in_array($cleanedNumber, $existingNumbers);
        // });
        $cleanedExistingNumbers = array_map(function ($number) {
            return preg_replace('/[^0-9]/', '', $number);
        }, $existingNumbers);

        $contactsToInsert = collect($filteredData)->reject(function ($yeasterContact) use ($cleanedExistingNumbers) {
            $cleanedNumber = preg_replace('/[^0-9]/', '', $yeasterContact['call_to_number']);

            // Remove "+" and "9" at the beginning of the number
            $cleanedNumber = preg_replace('/^[+9]|^9/', '', $cleanedNumber);

            return in_array($cleanedNumber, $cleanedExistingNumbers);
        });

        $contactsToInsert->each(function ($yeasterContact) use ($smsConfig) {
            $have_contact = Contact::where('recipient_phone_number', str_replace('+', '', $yeasterContact['call_to_number']))->first();
            if (!$have_contact) {
                $contact = new Contact([
                    'date_time' => Carbon::createFromFormat('d/m/Y H:i:s', $yeasterContact['time']),
                    'sender_id' => '',
                    'sms_id' => $yeasterContact['id'],
                    'recipient_phone_number' => str_replace('+', '', $yeasterContact['call_to_number']),
                    'active_status' => 0,
                ]);

                $contact->save();
            }
        });
    }

    public function autoSendSms()
    {
        ini_set('memory_limit', '256M');
        try {
            $template = SmsTemplete::where('active_status', 1)->first();
            $config = SmsConfig::where('status', 1)->first();

            if (!$template) {
                Log::error('No active SMS template found.');
                return;
            }

            $basic = Basic::find(1);
            $contacts = Contact::where('active_status', 0)
                ->take($basic->total_sms_send_at_a_time)
                ->get();

            if ($contacts->isEmpty()) {
                Log::info('No pending SMS to send.');
                return;
            }

            DB::beginTransaction();

            foreach ($contacts as $contact) {
                sms($contact->recipient_phone_number, $template->message);

                $contact->update([
                    'sender_id' => $config->sender_id,
                    'sms_content' => $template->message,
                    'active_status' => 1,
                ]);
            }

            DB::commit();

            Log::info('SMS sent successfully.');
        } catch (\Exception $e) {
            DB::rollBack();

            Log::error('Error while sending SMS: ' . $e->getMessage());
        }
    }

    public function basicSetup(Request $request)
    {
        $data['basic'] = Basic::latest()->first();
        return view('back-end.setting.basic', $data);
    }

    public function basicSetupStore(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'total_sms_send_at_a_time' => 'required|numeric',
            'pagination_limit' => 'required|numeric',
        ]);

        $basic = Basic::latest()->first();
        $basic->name = $request->name;
        $basic->total_sms_send_at_a_time = $request->total_sms_send_at_a_time;
        $basic->pagination_limit = $request->pagination_limit;
        $basic->save();

        if ($basic == true) {
            $notification = [
                'success' => 'Setting Save Successfully',
            ];
        } else {
            $notification = [
                'error' => 'Opps! Something is wrong...!',
            ];
        }

        return redirect()->back()->with($notification);
    }

    public function updateSmsStatusAjax(Request $request)
    {
        $status = $request->status;
        SmsConfig::where('status', 1)->update(['status' => 2]);
        SmsConfig::findOrFail($request->id)->update(['status' => $status]);

        return response()->json(['success' => 1]);
    }

    public function updateSmsDefaultStatusAjax(Request $request)
    {
        $status = $request->status;
        SmsConfig::where('default_send_status', 1)->update(['default_send_status' => 2]);
        SmsConfig::findOrFail($request->id)->update(['default_send_status' => $status]);

        return response()->json(['success' => 1]);
    }
    
    public function previewExcelSmsFirstRowAjax(Request $request)
    {
        $rules = [
            'first_box' => 'required|string',
            'excel_upload' => 'required|file|mimes:xlsx,xls',
        ];

        // Validate the request
        $validator = Validator::make($request->all(), $rules);

        // If validation fails, return error response
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }

        $file = $request->file('excel_upload');

        $excelData = Excel::toArray([], $file);
        $smsTemplate = $request->first_box;
        $excelFilePath = $file->storeAs('temp', $file->getClientOriginalName());

        Session::put('excel', $excelFilePath);
        Session::put('smsTemplate', $smsTemplate);

        $firstRow = $excelData[0][1] ?? [];

        if (!empty($firstRow)) {
            foreach ($firstRow as $index => $value) {
                $placeholder = '{' . $index . '}';
                $smsTemplate = str_replace($placeholder, $value, $smsTemplate);
            }

            $html = View::make('back-end.sms.include.preview_first_row_excel_render', compact('smsTemplate'))->render();
            return response()->json(['data' => $html]);
        } else {
            return response()->json(['error' => 'Unable to extract values from textarea.'], 400);
        }
    }

    public function get_sms_api_ajax(Request $request)
    {
        Session::put('name_id', $request->name_id);
        $smsConfig = SmsConfig::findOrFail($request->name_id);

        return response()->json([
            'data' => $smsConfig,
        ]);
    }

    public function smsPrepare(Request $request)
    {
        $rules = [
            'name_id' => 'required|numeric',
            'api_url' => 'required|string',
            'api_key' => 'required|string',
            'sender_id' => 'required|string',
            'type' => 'required|string',
        ];

        $messages = [
            'name_id.required' => 'The name_id field is required.',
            'name_id.numeric' => 'The name_id field must be a number.',
            'api_url.required' => 'The api_url field is required.',
            'api_url.string' => 'The api_url field must be a string.',
            'api_key.required' => 'The api_key field is required.',
            'api_key.string' => 'The api_key field must be a string.',
            'sender_id.required' => 'The sender_id field is required.',
            'sender_id.string' => 'The sender_id field must be a string.',
            'type.required' => 'The type field is required.',
            'type.string' => 'The type field must be a string.',
        ];

        // Assuming $data contains the data you want to validate

        $validator = Validator::make($request->all(), $rules, $messages);

        if ($validator->fails()) {
            $errors = $validator->errors();
            return response()->json(['errors' => $errors], 422);
        } else {
            $excel = Session::get('excel');
            $rows = Excel::toArray([], $excel);
            $rowCount = count($rows[0]) - 1;

            return response()->json([
                'total_excel_rows' => $rowCount,
            ]);
        }
    }

    public function continue_to_send_sms()
    {
        ini_set('memory_limit', '256M'); 
        $excel = Session::get('excel');

        $excelData = Excel::toArray([], $excel);
        array_shift($excelData[0]);

        $smsTemplate = Session::get('smsTemplate');

        // Iterate over each row in the Excel data
        foreach ($excelData[0] as $row) {
            $phone = null;
            if ($row[0]) {
                $phone = $row[0];
            }
            $processedTemplate = $smsTemplate;
            foreach ($row as $index => $value) {
                $placeholder = '{' . $index . '}';
                $processedTemplate = str_replace($placeholder, $value, $processedTemplate);
            }
            $have_contact = Contact::where('recipient_phone_number', str_replace('+', '', $phone))->whereDate('date_time', Carbon::today())->first();

            $name_id = Session::get('name_id');

            if (!$have_contact) {
                $contact = new Contact([
                    'date_time' => Carbon::now(),
                    'sender_id' => '',
                    'sms_id' => '',
                    'sms_content' => $processedTemplate,
                    'recipient_phone_number' => str_replace('+', '', $phone),
                    'active_status' => 0,
                    'sms_api_id' => $name_id,
                    'created_by' => Auth::Id(),
                ]);

                $contact->save();
            }
        }

        return response()->json([
            'success' => 'SMS Send Successfully',
        ]);
    }
}
