<?php

namespace App\Http\Controllers;

use App\Models\SmsTemplete;
use Illuminate\Http\Request;

class SmsTempleteController extends Controller
{
    public function index()
    {
        $data['templates'] = SmsTemplete::latest()->paginate(10);
        return view('back-end.templete.index', $data);
    }

    public function store(Request $request)
    {
        
        $request->validate([
            'message'=> "required|string|max:1000"
        ]);
        $template = new SmsTemplete();
        $template->message = $request->message;
        $template->save();

        
        if ($template == true) {
            $notification = ([
                'success' => 'Template Save Successfully',
            ]);
        } else{
            $notification = ([
                'error' => 'Opps! Something is wrong...!',
            ]);
        }

        return redirect()->back()->with($notification);
    }

    public function updateTemplateStatusAjax(Request $request)
    {
        $status = 1;
        if ($request->active_status === 1) {
            $status = 0;
        }
        $response = SmsTemplete::query()->update(['active_status' => 0]);
        $response = SmsTemplete::findOrFail($request->id)->update(['active_status' => $status]);
        return response()->json([
            'success' => $response
        ]);
    }

    public function updateTemplate(Request $request)
    {
        
        $request->validate([
            'id' => "required|numeric",
            'message'=> "required|string|max:1000"
        ]);

        $template = SmsTemplete::findOrFail($request->id);
        $template->message = $request->message;
        $template->save();

        
        if ($template == true) {
            $notification = ([
                'success' => 'Template Update Successfully',
            ]);
        } else{
            $notification = ([
                'error' => 'Opps! Something is wrong...!',
            ]);
        }

        // return response()->json($notification);

        return redirect()->back()->with($notification);

    }
    
    public function deleteTemplate($template_id)
    {
        SmsTemplete::findOrFail($template_id)->delete();
        return redirect()->back();
    }

}
