<?php

use App\Basic;
use App\Models\MyAlice;
use App\Models\SmsConfig;
use App\Models\YeasterConfig;
use Illuminate\Support\Facades\DB;
use Intervention\Image\Facades\Image;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Http;

if (!function_exists('uploadPlease')) {
    function uploadPlease($image)
    {
        $imageName = hexdec(uniqid()) . '.' . $image->getClientOriginalExtension();
        Image::make($image)->save('public/uploads/' . $imageName);
        return $img_url = 'public/uploads/' . $imageName;
    }
}

if (!function_exists('basic')) {
    function basic()
    {
        return Basic::latest()->first();
    }
}


if (!function_exists('timeFormat')) {
    function timeFormat($seconds)
    {
        // Calculate hours, minutes, and remaining seconds
        $hours = floor($seconds / 3600);
        $minutes = floor(($seconds % 3600) / 60);
        $remainingSeconds = $seconds % 60;

        // Format the output
        $formattedTime = sprintf('%02d:%02d:%02d', $hours, $minutes, $remainingSeconds);
        return $formattedTime; // Output: 00:02:01
    }
}
if (!function_exists('custom_asset')) {
    function custom_asset($image)
    {
        if (File::exists(asset($image))) {
            return asset($image);
        } else {
            $publicSegment = 'public';
            $cleanedPath = str_replace($publicSegment . '/', '', $image);

            return asset($cleanedPath);
        }
    }
}

if (!function_exists('check_permission')) {
    function check_permission($id, $user_id)
    {
        $has = DB::table('model_has_permissions')
        ->where('model_id', $user_id)->where('permission_id', $id)->first();
        if ($has) {
            return "checked";
        }

        return '';

    }
}

if (!function_exists('custom_path')) {
    function custom_path($path)
    {
        if (is_writable($path)) {
            return $path;
        } else {
            $publicSegment = 'public';
            $cleanedPath = str_replace($publicSegment . '/', '', $path);

            return $cleanedPath;
        }
    }
}

if (!function_exists('sms')) {
    function sms($number, $message, $config = null)
    {
        if ($config == null) {
            $config = SmsConfig::where('status', 1)->first();
        }
        
        $config = SmsConfig::where('status', 1)->first();
        $apiUrl = $config->api_url;
        $api_key = $config->api_key;
        $type = $config->type;
        $senderid = $config->sender_id;

        $response = Http::get("$apiUrl", [
            'api_key' => $api_key,
            'type' => $type,
            'number' => $number,
            'senderid' => $senderid,
            'message' => $message,
        ]);

        // Check if the request was successful
        if ($response->successful()) {
            // Process the API response
            // echo $response->body();
        } else {
            // Handle HTTP error
            // echo 'HTTP error: ' . $response->status();
        }
    }
}


if (!function_exists('smsSend')) {
    function smsSend($number, $message, $config = null)
    {
        if ($config == null) {
            $config = SmsConfig::where('status', 1)->first();
        }
        
        $apiUrl = $config->api_url;
        $api_key = $config->api_key;
        $type = $config->type;
        $senderid = $config->sender_id;

        $response = Http::get("$apiUrl", [
            'api_key' => $api_key,
            'type' => $type,
            'number' => $number,
            'senderid' => $senderid,
            'message' => $message,
        ]);

        // Check if the request was successful
        if ($response->successful()) {
            $responseBody = $response->body(); // Get the response body as a string
            $responseArray = json_decode($responseBody, true); 
            
            if (isset($responseArray['error_message']) && !empty($responseArray['error_message'])) {
                // If there's an error message, handle it as an error condition
                return response()->json([
                    'status' => 'error',
                    'message' => $responseArray['error_message'],
                ], 400); // You can choose an appropriate status code
            } else {
                // Handle success condition
                return response()->json([
                    'status' => 'success',
                    'message' => $responseArray['success_message'],
                ], 200);
            }
        } else {
            // Handle HTTP error
            // echo 'HTTP error: ' . $response->status();
        }
    }
}


if (!function_exists('yeaster_token')) {
    function yeaster_token()
    {

        $config = YeasterConfig::latest()->first();
        error_reporting(null);

        $get_call = 'https://doctormobile.linkuspbx.com/openapi/v1.0/call/query';
        $response = Http::get("$get_call", [
            'access_token' => $config->access_token,
        ]);

        if ($response->successful()) {
            $data = $response->json();
            if ($data['errmsg'] !=  "SUCCESS") {

                $tokenUrl = 'https://doctormobile.linkuspbx.com/openapi/v1.0/get_token';
                $userAgent = 'Mozilla/5.0 (Windows NT 10.0; WOW64)';
                $loginData = [
                    'username' => $config->username,
                    'password' => $config->password,
                ];
        
                $token = Http::withOptions([
                    'verify' => false, // Disable SSL verification for testing, consider removing this in production
                ])
                    ->withHeaders([
                        'Content-type' => 'application/json',
                    ])
                    ->post($tokenUrl, $loginData);
        
                // Check if the request was successful
                if ($token->successful()) {
        
                    $tokenData = $token->json();
                    $config->update([
                        'access_token' => $tokenData['access_token']
                    ]);
                    return $config->access_token;
                } else {
                    // Handle HTTP error
                    // echo 'HTTP error: ' . $response->status();
                }
            } else {
                return $config->access_token;
            }
        } else {
            dd($response->status(), $response->body());
        }
        
       
    }

    
if (!function_exists('my_alice_sms')) {
    function my_alice_sms($number)
    {
        $config = MyAlice::latest()->first();
        $apiUrl = $config->api_url;
        $api_key = $config->api_key;
        $template_id = $config->template_id;
        $channel_id = $config->channel_id;


        $response = Http::withHeaders([
            'Content-Type' => 'application/json',
            'X-Myalice-Api-Key' => $api_key,
        ])->post($apiUrl, [
            'template_id' => $template_id,
            'channel_id' => $channel_id,
            'customer_phone' => $number,
        ]);
        
        if ($response->failed()) {
            // echo "HTTP Error #" . $response->status();
        } else {
            return json_decode($response->body(), true);
        }
        
    }
}

    
if (!function_exists('api_template')) {
    function api_template()
    {
      
        $config = MyAlice::latest()->first();
        $curl = curl_init();

        curl_setopt_array($curl, [
            CURLOPT_URL => "https://api.myalice.ai/stable/open/whatsapp/get-template-list?platform_id={$config->channel_id}",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => ["X-Myalice-Api-Key: $config->api_key"],
        ]);

        $response = curl_exec($curl);
        $err = curl_error($curl);

        curl_close($curl);

        if ($err) {
            //   echo "cURL Error #:" . $err;
            return $data['templates'] = [];
        } else {
            
            return $data['templates'] = json_decode($response, true);
        }
        
    }
}
}
