@extends('back-end.layouts.master')

@section('title')
    Send What's App Message
@endsection

@section('content')
    <section class="content">
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <ol class="breadcrumb ">
                            <li class="breadcrumb-item"><a href="{{ url('dashboard') }}">Dashboard</a></li>
                            <li class="breadcrumb-item active">@yield('title')</li>
                        </ol>
                    </div><!-- /.col -->
                </div><!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
        <!-- /.content-header -->

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header bg-gray text-bold">
                                Message Send Form
                            </div>
                            <form action="{{ route('send-manual-whats-app-sms') }}" method="POST" enctype="multipart/form-data">
                                @csrf
                                <div class="modal-body">
                                    <div class="card-body">
                                        <div class="form-group row">
                                            <label class="col-md-3" for="numbers">Enter Numbers</label>
                                            <div class="col-md-9">
                                                <textarea type="text" name="numbers" id="numbers" required class="form-control " rows="6" placeholder="+8801945283626
01828372838
1743826163
                                                    ">{{ old('numbers') }}</textarea>
                                                @error('numbers')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                                
                                                <div class="modal-footer d-block text-center">
                                                    <button type="submit" class="btn btn-primary rounded-pill">Send Message</button>
                                                </div>
                                            <div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </section>
@endsection
