<div class="form-group">
    <div class="row">
        <label class="col-md-3"></label>
        <div class="col-md-9">
            <div class="form-group">
                <textarea type="text" name="first_box" id="first_box" required class="form-control " rows="6"
                    placeholder="SMS Sample:
Username: {}
Website: {}
Whatsapp: {}
Password: {}">
SMS Sample:
Username: {}
Website: {}
Whatsapp: {}
Password: {}</textarea>
                @error('first_box')
                    <span class="text-danger">{{ $message }}</span>
                @enderror

            </div>
        </div>
    </div>
</div>
<div class="form-group">
    <div class="row">
        <label class="col-md-3"></label>
        <div class="col-md-9">
            <div class="d-block text-center">
                <button type="submit" id="preview_button" class="btn btn-primary rounded-pill">
                    Preview 1st Row SMS
                </button>
            </div>
        </div>
    </div>
</div>
<div class="form-group" id="preview_first_row_excel">

</div>



<!-- Modal register -->
<div class="modal fade" id="getApiModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Choose Sms API</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form id="countSendableSms">

                <div class="modal-body">
                    <div class="card-body">
                        <div class="form-group row">

                            @php
                                $sms_gateways = App\Models\SmsConfig::orderBy('name', 'asc')->get();
                            @endphp
                            <label for="name_id" class="col-md-3">Api Name</label>
                            <select name="name_id" class="form-control  select2 col-md-9" required
                                data-pleaceholder="Select Option" id="name_id" style="width: 75%">
                                <option selected>Select Sms API</option>
                                @foreach ($sms_gateways as $sms_gateway)
                                    <option value="{{ $sms_gateway->id }}">{{ $sms_gateway->name }}</option>
                                @endforeach
                            </select>
                            @error('name')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="form-group row">
                            <label class="col-md-3" for="api_url">Api Url</label>
                            <input type="text" name="api_url" id="api_url" required class="form-control col-md-9"
                                placeholder="Enter Api Url" value="{{ old('api_url') }}" readonly>
                            @error('api_url')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="form-group row">
                            <label class="col-md-3" for="api_key">Api Key</label>
                            <input type="text" name="api_key" id="api_key" required class="form-control col-md-9"
                                placeholder="Enter Api Key" value="{{ old('api_key') }}" readonly>
                            @error('api_key')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="form-group row">
                            <label class="col-md-3" for="sender_id">Sender ID</label>
                            <input type="text" name="sender_id" id="sender_id" required class="form-control col-md-9"
                                placeholder="Enter Sender ID" value="{{ old('sender_id') }}" readonly>
                            @error('sender_id')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="form-group row">
                            <label class="col-md-3" for="type">Type</label>
                            <input type="text" name="type" id="type" required class="form-control col-md-9"
                                placeholder="Enter Api Key" value="text" readonly>
                            @error('type')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>

                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary rounded-pill" data-dismiss="modal">Close</button>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary rounded-pill">
                            Next
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal -->
<div class="modal fade" id="confirmation" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
    aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title" id="exampleModalLabel">Confirm for sending sms.</h3>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <h5>Total <span id="total_excel_rows"></span> SMS Will Send At A Time!</h5>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-danger" id="cancel_sending_sms">Cancel</button>
                <button type="button" class="btn btn-primary" id="continue_to_send_sms">Continue</button>
            </div>
        </div>
    </div>
</div>
@push('js')
    <script>
        $(document).ready(function() {
            $("#name_id").change(function(e) {
                e.preventDefault();
                var name_id = $(this).val();

                $.ajax({
                    type: "GET",
                    url: "{{ secure_url('get_sms_api_ajax') }}",
                    data: {
                        name_id: name_id
                    },
                    success: function(response) {
                        $("#api_url").val(response.data.api_url);
                        $("#api_key").val(response.data.api_key);
                        $("#sender_id").val(response.data.sender_id);
                        $("#type").val(response.data.type);
                    }
                });

            });

            $("form#countSendableSms").submit(function(e) {
                e.preventDefault();

                var formData = new FormData($("#countSendableSms")[0]);

                $.ajax({
                    type: "POST",
                    url: "{{ secure_url('sms-prepare') }}",
                    contentType: false,
                    processData: false,
                    data: formData,
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function(response) {
                        $("#total_excel_rows").text(response.total_excel_rows);
                        $('#confirmation').modal('show');
                    },
                    error: function(error) {

                        $('.validate').text('');

                        $.each(error.responseJSON.errors, function(field_name, error) {
                            const errorElement = $('.validate[data-field="' +
                                field_name + '"]');
                            if (errorElement.length > 0) {
                                errorElement.text(error);
                                toastr.error(error);
                            }
                        });
                    }
                });
            });


            $("#cancel_sending_sms").click(function(e) {
                e.preventDefault();
                window.location.reload();
            });

            $("#continue_to_send_sms").click(function(e) {
                e.preventDefault();

                $.ajax({
                    type: "GET",
                    url: "{{ secure_url('continue_to_send_sms') }}",
                    success: function(response) {
                        if (response.success) {
                            toastr.success(response.success);
                        }
                    },
                    error: function(error) {

                        $('.validate').text('');

                        $.each(error.responseJSON.errors, function(field_name, error) {
                            const errorElement = $('.validate[data-field="' +
                                field_name + '"]');
                            if (errorElement.length > 0) {
                                errorElement.text(error);
                                toastr.error(error);
                            }
                        });
                    },
                    complete: function(done) {
                        if (done.status == 200) {
                            location.reload(true);
                        }
                    }
                });
            });
        });
    </script>
@endpush
