@extends('back-end.layouts.master')

@section('title')
    Users List
@endsection

@section('content')
    <section class="content">
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <ol class="breadcrumb ">
                            <li class="breadcrumb-item"><a href="{{ url('dashboard') }}">Dashboard</a></li>
                            <li class="breadcrumb-item active">@yield('title')</li>
                        </ol>
                    </div><!-- /.col -->
                </div><!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
        <!-- /.content-header -->

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12 my-2">
                        <form action="{{ url('sms-send-count') }}">
                            <div class="row">
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label for="start_date">Start Date</label>
                                        <input type="date" class="form-control" name="start_date" id="start_date"
                                            placeholder="Enter Start Date..."
                                            value="{{ isset($request->start_date) ? $request->start_date : \Carbon\Carbon::now()->format('Y-m-d') }}">
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label for="end_date">End Date</label>
                                        <input type="date" class="form-control" name="end_date" id="end_date"
                                            placeholder="Enter End Date..."
                                            value="{{ isset($request->end_date) ? $request->end_date : \Carbon\Carbon::now()->format('Y-m-d') }}">
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group" style="margin-top: 32px;">
                                        <button class="btn btn-success" id="submit"><i class="fas fa-search"></i>
                                            Search</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                     <div class="col-12">
                        @php

                            $start_date = isset($request->start_date)
                                ? \Carbon\Carbon::parse($request->start_date)->format('Y-m-d')
                                : null;
                            $end_date = isset($request->end_date)
                                ? \Carbon\Carbon::parse($request->end_date)->format('Y-m-d')
                                : null;
                        @endphp
                        @if ($request->start_date && $request->end_date)
                            <p>Search From
                                <strong>{{ \Carbon\Carbon::parse($request->start_date)->format('Y-m-d') }}</strong> To
                                <strong>{{ \Carbon\Carbon::parse($request->end_date)->format('Y-m-d') }}</strong>
                            </p>
                        @endif
                        <div class="card">
                            <div class="card-header bg-gray text-bold">
                                Users List
                            </div>
                            <table class="table align-middle mb-0 bg-white table-bordered">
                                <thead class="bg-light">
                                    <tr>
                                        <th>SL</th>
                                        <th>Name</th>
                                        <th>Email</th>
                                        <th>Sms Send</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php
                                        $serial = 1; /* ($users->currentpage() - 1) * $users->perpage() + 1; */
                                    @endphp
                                    @foreach ($users as $user)
                                        <tr>
                                            <td>
                                                {{ $serial++ }}
                                            </td>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <div class="ms-3">
                                                        <p class="fw-bold mb-1">{{ $user->name }}</p>
                                                    </div>
                                                </div>
                                            </td>
                                            <td>
                                                <p class="fw-normal mb-1">{{ $user->email }}</p>
                                            </td>


                                            <td>
                                                {{-- <form action="{{ url('show-list-of-send-sms') }}"
                                                    id="form{{ $user->id }}" method="get">
                                                    <input type="hidden" name="start_date"
                                                        value="{{ $request->start_date }}">
                                                    <input type="hidden" name="end_date" value="{{ $request->end_date }}">
                                                    <input type="hidden" name="user_id" value="{{ $user->id }}"> --}}
                                                @php
                                                    $userContactCount = \App\Models\Contact::where(
                                                        'created_by',
                                                        $user->id,
                                                    )
                                                        ->when($start_date && $end_date, function ($query) use (
                                                            $start_date,
                                                            $end_date,
                                                        ) {
                                                            $query
                                                                ->whereDate('date_time', '>=', $start_date)
                                                                ->whereDate('date_time', '<=', $end_date);
                                                        })
                                                        ->count();
                                                @endphp
                                                <button type="button" data-toggle="modal" data-target="#exampleModal"
                                                    data-end_date="{{ $request->end_date }}"
                                                    data-start_date="{{ $request->start_date }}"
                                                    data-user_id="{{ $user->id }}"
                                                    class="btn btn-{{ $userContactCount > 0 ? 'primary' : 'danger' }} btn-sm rounded-pill btn-rounded text-light show_pop_up">
                                                    <i class="fas fa-eye"></i> {{ $userContactCount }}
                                                </button>
                                                {{-- </form> --}}
                                            </td>
                                        </tr>
                                    @endforeach
                                    <tr>
                                        <td colspan="3" class="text-right">Total Sms Send</td>
                                        <td>{{ $total_sms }}</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Modal -->
            <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-xl">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">×</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <div class="col-12">
                                <form>
                                    <div class="form-row {{-- align-items-left  float-right --}}  mb-3">
                                        <div class="col-md-2">
                                            <label for="sms_id">ID</label>
                                            <input type="search" class="form-control" name="sms_id" id="sms_id_value"
                                                placeholder="Enter Sms ID..." value="">
                                            <input type="hidden" name="user_id" id="user_id_value" value="">
                                        </div>
                                        <input type="hidden" name="start_date" id="start_date_velue" value="">
                                        <input type="hidden" name="end_date" id="end_date_value" value="">
                                        <div class="col-md-3">
                                            <label for="sender_id">Sender ID</label>
                                            <input type="search" class="form-control" name="sender_id"
                                                placeholder="Enter Sender ID..." id="sender_id_value" value="">
                                        </div>
                                        <div class="col-md-4">
                                            <label for="recipient_phone_number">Recipient Phone Number</label>
                                            <input type="search" class="form-control" name="recipient_phone_number"
                                                placeholder="Enter Recipient Number..." id="recipient_phone_number_value"
                                                value="">
                                        </div>

                                        <div class="col-md-12 mt-2">
                                            <button class="btn btn-success" type="button" id="searchMe"><i
                                                    class="fas fa-search"></i>
                                                Search</button>
                                        </div>
                                    </div>
                                </form>
                            </div>

                            <div id="showListOfData"></div>
                        </div>
                        <div class="modal-footer justify-content-between">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        </div>
                    </div>

                </div>
            </div>
            @push('js')
                <script>
                    $(document).ready(function() {
                        $(".show_pop_up").click(function(e) {
                            e.preventDefault();
                            var end_date = $(this).data('end_date');
                            var start_date = $(this).data('start_date');
                            var user_id = $(this).data('user_id');

                            $("#sms_id_value").val("");
                            $("#user_id_value").val(user_id);
                            $("#start_date_velue").val(start_date);
                            $("#end_date_value").val(end_date);
                            $("#recipient_phone_number_value").val("");
                            $("#sender_id_value").val("");
                            showListOfSendSms(end_date, start_date, user_id);

                        });

                        $("#searchMe").click(function(e) {
                            e.preventDefault();
                            var user_id = $("#user_id_value").val();
                            var start_date = $("#start_date_velue").val();
                            var end_date = $("#end_date_value").val();
                            var sender_id = $("#sender_id_value").val();
                            var sms_id = $("#sms_id_value").val();
                            var recipient_phone_number = $("#recipient_phone_number_value").val();

                            showListOfSendSms(end_date, start_date, user_id, sms_id, recipient_phone_number, sender_id)
                        });


                        function showListOfSendSms(end_date, start_date, user_id, sms_id = null, recipient_phone_number = null,
                            sender_id = null) {
                            $.ajax({
                                type: "GET",
                                url: "{{ secure_url('show-list-of-send-sms') }}",
                                dataType: 'json',
                                data: {
                                    end_date: end_date,
                                    start_date: start_date,
                                    user_id: user_id,
                                    sms_id: sms_id,
                                    sender_id: sender_id,
                                    recipient_phone_number: recipient_phone_number
                                },
                                success: function(response) {
                                    console.log(response);
                                    updateUIWithData(response.data);
                                },
                                error: function(error) {
                                    console.log(error);
                                }
                            });
                        }

                        // $(document).on('click', '.pagination a', function(e) {
                        //     e.preventDefault();
                        //     var url = $(this).attr('href');
                        //     $.ajax({
                        //         url: url,
                        //         type: 'get',
                        //         dataType: 'json',
                        //         success: function(response) {
                        //             // Update the content with the new data
                        //             console.log(response);
                        //             updateUIWithData(response.data);
                        //         }
                        //     });
                        // });

                        // for server 
                        $(document).on('click', '.pagination a', function(e) {
                            e.preventDefault();
                            var url = $(this).attr('href');
                            // Replace http with https
                            url = url.replace(/^http:\/\//i, 'https://');
                            $.ajax({
                                url: url,
                                type: 'get',
                                dataType: 'json',
                                success: function(response) {
                                    // Update the content with the new data
                                    console.log(response);
                                    updateUIWithData(response.data);
                                }
                            });
                        });

                        function updateUIWithData(data) {
                            $('#showListOfData').html("");
                            $('#showListOfData').html(data);
                        }
                    });
                </script>
            @endpush
        </section>
    </section>
@endsection
