@extends('back-end.layouts.master')

@section('title')
    Whats App Message Templete
@endsection

@section('content')
    <section class="content">
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <ol class="breadcrumb ">
                            <li class="breadcrumb-item"><a href="{{ url('dashboard') }}">Dashboard</a></li>
                            <li class="breadcrumb-item active">@yield('title')</li>
                        </ol>
                    </div><!-- /.col -->
                </div><!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
        <!-- /.content-header -->

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header bg-gray text-bold">
                                Whats App Message Templete List Table
                            </div>
                            <table class="table align-middle mb-0 bg-white table-bordered">
                                <thead class="bg-light">
                                    <tr>
                                        <th style="20%">Serial</th>
                                        <th style="70%">Message</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php
                                        $serial = 1;
                                    @endphp
                                    @foreach ($templates as $template)
                                        <tr>
                                            <td>{{ $serial++ }}</td>
                                            <td>{{ $template['body'] }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <!-- Modal addNew -->
                <div class="modal fade" id="addNew" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
                    aria-hidden="true">
                    <div class="modal-dialog modal-lg" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="exampleModalLabel">Add New Sms Templete Form</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <form action="{{ route('template-store') }}" method="POST" enctype="multipart/form-data">
                                @csrf
                                <div class="modal-body">
                                    <div class="card-body">
                                        <div class="form-group row">
                                            <label class="col-md-3" for="message">Message</label>
                                            <textarea type="text" name="message" id="message" required class="form-control col-md-9" rows="6"
                                                placeholder="Enter Templete Message">{{ old('message') }}</textarea>
                                            @error('message')
                                                <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary rounded-pill"
                                        data-dismiss="modal">Close</button>
                                    <button type="submit" class="btn btn-primary rounded-pill">Save</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                <!-- Modal EDIT -->
                <div class="modal fade" id="editModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
                    aria-hidden="true">
                    <div class="modal-dialog modal-lg" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="exampleModalLabel">Edit Sms Templete Form</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <form action="{{ url('template-update') }}" method="POST" enctype="multipart/form-data">
                                @csrf
                                <div class="modal-body">
                                    <div class="card-body">
                                        <input type="hidden" name="id" id="id_e">
                                        <div class="form-group row">
                                            <label class="col-md-3" for="message_e">Message</label>
                                            <textarea type="text" name="message" id="message_e" required class="form-control col-md-9" rows="6"
                                                placeholder="Enter Templete Message">{{ old('message') }}</textarea>
                                       
                                            <span class="text-danger validate_e" data-field="message"></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary rounded-pill"
                                        data-dismiss="modal">Close</button>
                                    <button type="submit" class="btn btn-primary rounded-pill">Save</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

        </section>
        @push('js')
            <script>
                $(document).ready(function() {
                    $(".editModal").click(function (e) { 
                        e.preventDefault();
                        $('#id_e').val($(this).data('template').id);
                        $('#message_e').val($(this).data('template').message);
                    });


                    $(".templete_status").change(function(e) {
                        e.preventDefault();
                        var templete_id = $(this).data('id');
                        var active_status = $(this).val();

                        $.ajax({
                            type: "GET",
                            url: "{{ secure_url('update-template-status-ajax') }}",
                            data: {
                                id: templete_id,
                                active_status: active_status
                            },
                            success: function(response) {

                            },
                            complete: function(done) {
                                if (done.status == 200) {
                                    location.reload(true);
                                }
                            }
                        });
                    });


                    $("#editData").submit(function(e) {
                        e.preventDefault();
                        var id = $('#id_e').val();
                        var message = $('#message_e').val();
                        $.ajax({
                            type: "POST",
                            url: "{{ url('template-update') }}",
                            headers: {
                                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                            },
                            data: {
                                id: id,
                                message: message
                            },
                            success: function(response) {
                                if (response.success) {
                                    toastr.success(response.success);
                                } else if (response.error) {
                                    toastr.error(response.error);
                                }
                            },
                            error: function(error) {
                                $('.validate').text('');
                                $.each(error.responseJSON.errors, function(field_name, error) {
                                    const errorElement = $('.validate_e[data-field="' +
                                        field_name + '"]');
                                    if (errorElement.length > 0) {
                                        errorElement.text(error[0]);
                                        toastr.error(error);
                                    }
                                });
                            },

                            complete: function(done) {
                                if (done.status == 200) {
                                    window.location.reload();
                                }
                            }

                        });
                    });
                });
            </script>
        @endpush
    </section>
@endsection
