@extends('back-end.layouts.master')

@section('title')
    Users List
@endsection

@section('content')
    <section class="content">
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <ol class="breadcrumb ">
                            <li class="breadcrumb-item"><a href="{{ url('dashboard') }}">Dashboard</a></li>
                            <li class="breadcrumb-item active">@yield('title')</li>
                        </ol>
                    </div><!-- /.col -->
                </div><!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
        <!-- /.content-header -->

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12 my-2">
                        <form action="{{ url('voice-play-report') }}">
                            <div class="row">
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label for="start_date">Start Date</label>
                                        <input type="date" class="form-control" name="start_date" id="start_date"
                                            placeholder="Enter Start Date..."
                                            value="{{ isset($request->start_date) ? $request->start_date : \Carbon\Carbon::now()->format('Y-m-d') }}">
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label for="end_date">End Date</label>
                                        <input type="date" class="form-control" name="end_date" id="end_date"
                                            placeholder="Enter End Date..."
                                            value="{{ isset($request->end_date) ? $request->end_date : \Carbon\Carbon::now()->format('Y-m-d') }}">
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group" style="margin-top: 32px;">
                                        <button class="btn btn-success" id="submit"><i class="fas fa-search"></i>
                                            Search</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="col-6">
                        @php

                            $start_date = isset($request->start_date)
                                ? \Carbon\Carbon::parse($request->start_date)->format('Y-m-d')
                                : null;
                            $end_date = isset($request->end_date)
                                ? \Carbon\Carbon::parse($request->end_date)->format('Y-m-d')
                                : null;
                        @endphp
                        @if ($request->start_date && $request->end_date)
                            <p>Search From
                                <strong>{{ \Carbon\Carbon::parse($request->start_date)->format('Y-m-d') }}</strong> To
                                <strong>{{ \Carbon\Carbon::parse($request->end_date)->format('Y-m-d') }}</strong>
                            </p>
                        @endif
                        <div class="card">
                            <div class="card-header bg-gray text-bold">
                                Call To 734324324
                            </div>
                            <table class="table align-middle mb-0 bg-white table-bordered">
                                <thead class="bg-light">
                                    <tr>
                                        <th>Date</th>
                                        <th>Number of Play</th>
                                        <th>Number of download</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($plays as $play)
                                    <tr>
                                        <td>{{ \Carbon\Carbon::parse($play->date)->format('d/m/Y') }}</td>
                                        <td>
                                            <button data-toggle="modal" data-target="#playtime" class="playtime" data-id="{{ $play->id }}">
                                                {{ $play->play->count() }}
                                            </button>
                                        </td>
                                        <td>
                                            <button data-toggle="modal" data-target="#download" class="downloadTime" data-id="{{ $play->id }}">
                                                {{ $play->download->count() }}
                                            </button>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        
                        <!-- Modal -->
                        <div class="modal fade" id="playAudioModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                            <div class="modal-dialog modal-dialog-centered" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="exampleModalLongTitle">Play Recoding Numbers</h5>
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                    </div>
                                    <div class="modal-body" id="showNumbers"></div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="modal fade" id="DownlaodAudioModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                            <div class="modal-dialog modal-dialog-centered" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="exampleModalLongTitle">Download Recording Numbers</h5>
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                    </div>
                                    <div class="modal-body" id="showNumbers2"></div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        

                    </div>
                </div>
            </div>
            @push('js')
                <script>
                    $(document).ready(function() {
                 
                        $(".playtime").click(function(e){
                            
                            e.preventDefault();
                            var id = $(this).data('id');
                            $.ajax({
                                url: "{{ secure_url('play-numbers-ajax') }}",
                                type: 'get',
                                data: {
                                    id:id
                                },
                                success: function(response) {
                                    $('#playAudioModal').modal('show');
                                    $("#showNumbers").html(response);
                                }
                            });
                        });
                     
                 
                        $(".downloadTime").click(function(e){
                            
                            e.preventDefault();
                            var id = $(this).data('id');
                            $.ajax({
                                url: "{{ secure_url('download-numbers-ajax') }}",
                                type: 'get',
                                data: {
                                    id:id
                                },
                                success: function(response) {
                                    $('#DownlaodAudioModal').modal('show');
                                    $("#showNumbers2").html(response);
                                }
                            });
                        });
                     
                    });
                </script>
            @endpush
        </section>
    </section>
@endsection
