<?php $__env->startSection('title'); ?>
    Sms Inbox
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <section class="content">
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <ol class="breadcrumb ">
                            <li class="breadcrumb-item"><a href="<?php echo e(url('dashboard')); ?>">Dashboard</a></li>
                            <li class="breadcrumb-item active"><?php echo $__env->yieldContent('title'); ?></li>
                        </ol>
                    </div><!-- /.col -->
                </div><!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
        <!-- /.content-header -->

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row justify-content-between">
                    <div class="col-12">
                        <form action="<?php echo e(url('sms-inbox')); ?>" method="GET">
                            <div class="form-row   mb-3">
                                <div class="col-md-2">
                                    <label for="sms_id">ID</label>
                                    <input type="search" class="form-control" name="sms_id" placeholder="Enter Sms ID..."
                                        value="<?php echo e(isset($request) ? $request->sms_id : ''); ?>">
                                </div>
                                <div class="col-md-2">
                                    <label for="sender_id">Sender ID</label>
                                    <input type="search" class="form-control" name="sender_id"
                                        placeholder="Enter Sender ID..."
                                        value="<?php echo e(isset($request) ? $request->sender_id : ''); ?>">
                                </div>
                                <div class="col-md-2">
                                    <label for="recipient_phone_number">Recipient Phone Number</label>
                                    <input type="search" class="form-control" name="recipient_phone_number"
                                        placeholder="Enter Recipient Number..."
                                        value="<?php echo e(isset($request) ? $request->recipient_phone_number : ''); ?>">
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label for="first_date">Date Time</label>
                                        <input type="date" class="form-control" name="date_time"
                                            placeholder="Enter Date Time..."
                                            value="<?php echo e(isset($request) ? $request->date_time : ''); ?>">
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <label for="active_status">Status</label>
                                    <select name="active_status" class="form-control select2"
                                        data-pleaceholder="Select Option" id="active_status">
                                        <option selected value="2">Select Option</option>
                                        <option value="1"
                                            <?php echo e(isset($request) && $request->active_status == 1 ? 'selected' : ''); ?>>Send
                                        </option>
                                        <option value="0"
                                            <?php echo e(isset($request) && $request->active_status === "0" ? 'selected' : ''); ?>>Not Send
                                        </option>
                                    </select>
                                </div>
                                <div class="col-md-2">
                                    <label for="user_id">User</label>
                                    <select name="user_id" class="form-control select2"
                                        data-pleaceholder="Select Option" id="user_id">
                                        <option selected value="">Select User Name</option>
                                        <option value="0" <?php echo e(isset($request) && $request->user_id === "0" ? 'selected' : ''); ?>>System</option>
                                        <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($user->id); ?>" <?php echo e(isset($request) && $request->user_id == $user->id ? 'selected' : ''); ?>><?php echo e($user->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="col-md-12 mt-2">
                                    <button class="btn btn-success" id="submit"><i class="fas fa-search"></i>
                                        Search</button>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header bg-gray text-bold">
                                Contact Table
                            </div>
                            <table class="table align-middle mb-0 bg-white table-bordered">
                                <thead class="bg-light">
                                    <tr>
                                        <th style="width: 5%">ID</th>
                                        <th style="width: 11%">Date Time</th>
                                        <th style="width: 11%">System Send Time</th>
                                        <th style="width: 8%">Sender ID</th>
                                        <th style="width: 10%">Recipient Phone Number</th>
                                        <th style="width: 50%">Sms Content</th>
                                        <th style="width: 15%">User</th>
                                        <th style="width: 10%">Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                        $serial = ($contacts->currentpage() - 1) * $contacts->perpage() + 1;
                                    ?>

                                    <?php $__empty_1 = true; $__currentLoopData = $contacts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contact): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <?php if($contact->active_status == 1): ?>
                                        <tr>
                                            <td><?php echo e($contact->sms_id == 0 ? 'Manual' : $contact->sms_id); ?></td>
                                            <td><?php echo e(\Carbon\Carbon::parse($contact->date_time)->format('Y-m-d h:i a')); ?></td>
                                                                                        <td><?php echo e($contact->system_send_time != null ? \Carbon\Carbon::parse($contact->system_send_time)->format('Y-m-d h:i a') : ''); ?></td>

                                            <td><?php echo e($contact->sender_id); ?></td>
                                            <td><?php echo e($contact->recipient_phone_number); ?></td>
                                            <td><?php echo e($contact->sms_content); ?></td>
                                            <td><?php echo e($contact->user == null ? "System" : $contact->user->name); ?></td>
                                            <td><span
                                                    class="badge badge-<?php echo e($contact->active_status == 1 ? 'success' : 'danger'); ?>"><?php echo e($contact->active_status == 1 ? 'Send' : 'Not Send'); ?></span>
                                            </td>
                                        </tr>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td colspan="10" class="text-danger text-center">Data Not Found!</td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>

                        <?php echo e($contacts->appends($request->query())->links()); ?>

                    </div>
                </div>
            </div>
        </section>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('back-end.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/jitato/public_html/resources/views/back-end/sms/indexSms.blade.php ENDPATH**/ ?>