<?php $__env->startSection('title'); ?>
    Role
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
<section class="content">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <ol class="breadcrumb ">
                        <li class="breadcrumb-item"><a href="<?php echo e(url('dashboard')); ?>">Dashboard</a></li>
                        <li class="breadcrumb-item active"><?php echo $__env->yieldContent('title'); ?></li>
                    </ol>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-8">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Roles List</h3>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <table class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th style="width: 10%">Serial</th>
                                        <th>Roles Name</th>
                                        <th style="width: 20%">Action</th>
                                    </tr>
                                </thead>
                                <tbody>

                                    <?php
                                        $serial = ($roles->currentpage() - 1) * $roles->perpage() + 1;
                                    ?>
                                    <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($serial++); ?></td>
                                            <td><?php echo e($role->name); ?></td>
                                            <td>
                                                <button
                                                    class="btn btn-primary btn-sm rounded-pill btn-rounded text-light editModal"
                                                    data-toggle="modal" data-target="#editRole"
                                                    data-name="<?php echo e($role->name); ?>" data-id="<?php echo e($role->id); ?>"><i
                                                        class="fas fa-edit"></i>
                                                    Edit</button>
                                                
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Create Role</h3>
                        </div>
                        <div class="card-body">
                            <!-- form start -->
                            <form role="form" action="<?php echo e(route('create_role')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <div class="card-body">
                                    <div class="form-group">
                                        <label for="name">Name</label>
                                        <input type="text" class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            name="name" placeholder="Ex: Admin, Moderator...">
                                    </div>

                                    <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e($message); ?></strong>
                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <!-- /.card-body -->
                                <div class="card-footer">
                                    <button type="submit" class="btn btn-primary btn-block">Submit</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>


                
                <div class="modal fade" id="editRole">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h4 class="modal-title">Edit Role</h4>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <!-- form start -->
                            <form id="EditForm">
                                <div class="modal-body">

                                    <input type="hidden" id="id" name="id" value="">
                                    <div class="card-body">
                                        <div class="form-group">
                                            <label for="name">Name</label>
                                            <input type="text" class="form-control" name="name" id="roleName"
                                                placeholder="Ex: Admin, Moderator..." value="">
                                        </div>

                                        <span class="text-danger validationName" role="alert">
                                        </span>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="submit" class="btn btn-primary">Submit</button>
                                    <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                                </div>
                            </form>
                        </div>
                        <!-- /.modal-content -->
                    </div>
                    <!-- /.modal-dialog -->
                </div>
            </div>
        </div>
    </section>
<?php $__env->startPush('js'); ?>
<script>
    $(document).ready(function() {


        $('.editModal').click(function(e) {
            e.preventDefault();

            //validation name clear
            $('.validationName').text('');
            //fill the role form
            $('#id').val($(this).data('id'));
            $('#roleName').val($(this).data('name'));
        });


        //update ajax request 
        $("#EditForm").on('submit', function(e) {
            e.preventDefault();
            var formData = new FormData($("#EditForm")[0]);
            $.ajax({
                type: "POST",
                url: "<?php echo e(route('updateRole')); ?>",
                dataType: "json",
                contentType: false,
                processData: false,
                data: formData,
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                success: function(response) {
                    toastr.success(response.success)
                    $("#EditForm")[0].reset();
                    location.reload();
                    $('#editRole').modal('hide');

                },
                error: function(error) {
                    $('.validationName').text('');
                    $.each(error.responseJSON.errors, function(field_name, error) {
                        if (field_name == 'name') {
                            $('.validationName').text(error);
                            toastr.error(error)
                        }
                    });
                }
            });
        });
    });
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('back-end.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\sms_gatway_malaysia\resources\views/back-end/user/role_and_permission/indexRole.blade.php ENDPATH**/ ?>