<?php $__env->startSection('title'); ?>
    Register User
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <section class="content">
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <ol class="breadcrumb ">
                            <li class="breadcrumb-item"><a href="<?php echo e(url('dashboard')); ?>">Dashboard</a></li>
                            <li class="breadcrumb-item active"><?php echo $__env->yieldContent('title'); ?></li>
                        </ol>
                    </div><!-- /.col -->
                </div><!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
        <!-- /.content-header -->

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12 my-2">
                        <a href="<?php echo e(url('register-user')); ?>" class="btn btn-success  rounded-pill"><i
                                class="fas fa-plus"></i> Register
                            User
                        </a>
                    </div>
                    <div class="col-6">
                        <div class="card">
                            <div class="card-header bg-secondary">
                                Register User Form
                            </div>
                            <form action="<?php echo e(route('register-user-post')); ?>" method="POST" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <div class="card-body">
                                    <div class="form-group row">
                                        <label class="col-md-3" for="name">Name</label>
                                        <input type="text" name="name" id="name" required
                                            class="form-control col-md-9" placeholder="Enter User Name"
                                            value="<?php echo e(old('name')); ?>">
                                        <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="form-group row">
                                        <label class="col-md-3" for="email">Email</label>
                                        <input type="text" name="email" id="email" required
                                            class="form-control col-md-9" placeholder="Enter User Email"
                                            value="<?php echo e(old('email')); ?>">
                                        <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="form-group row">
                                        <label class="col-md-3" for="password">Password</label>
                                        <div class="col-md-9 px-0">
                                            <input type="password" name="password" id="password" required
                                                class="form-control" placeholder="Enter User Password"
                                                value="<?php echo e(old('password')); ?>">
                                            <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="text-danger"><?php echo e($message); ?></span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            <span id="password_alert" class="text-danger mb-1"></span>
                                        </div>

                                    </div>
                                    <div class="form-group row">
                                        <label class="col-md-3" for="photo">Photo</label>
                                        <input type="file" name="photo" id="photoUpload" required
                                            class="form-control col-md-9" placeholder="Enter User Name"
                                            value="<?php echo e(old('photo')); ?>">
                                        <?php $__errorArgs = ['photo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <div class="col-md-3 offset-3">
                                        <img class="previewHolder" src="" alt="">
                                    </div>
                                    <div class="form-group row">
                                        <label class="col-md-3">User Role</label>
                                        <div class="col-md-9 px-0">
                                            <select name="user_type" required class="form-control select2"
                                                style="width: 100%;">
                                                <option label="Choose Type" selected disabled>Select One</option>
                                                <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($role->name); ?>"><?php echo e($role->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                        <?php $__errorArgs = ['type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="text-danger"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <strong>Permissions:</strong>
                                    <?php $__currentLoopData = $permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="custom-control custom-checkbox">
                                        <input class="custom-control-input" type="checkbox" name="permission[]" id="permission<?php echo e($permission->name); ?>" value="<?php echo e($permission->id); ?>">
                                        <label for="permission<?php echo e($permission->name); ?>" class="custom-control-label"><?php echo e($permission->name); ?></label>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    
                                    <div class="pt-2">
                                        <button type="submit" class="btn btn-block btn-primary">
                                            Register</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    <?php $__env->stopSection(); ?>

    <?php $__env->startSection('script'); ?>
        <script>
            //password chacker
            $(document).ready(function() {
                $('#password').keyup(function() {
                    value = $(this).val();
                    if (value.length < 8) {
                        $('#password_alert').html('Please Enter Minimum 8 Digit!');
                    } else if (value.length >= 8) {
                        $('#password_alert').empty();
                    };
                });
            });
        </script>
        <script>
            $(document).ready(function() {
                //edit modal close restart
                $(".editUser").on("hidden.bs.modal", function() {
                    $(this).find('form').trigger('reset');
                });
                //add modal reset
                $('#registerUser').on("hidden.bs.modal", function() {
                    $('#name').val('');
                    $('#email').val('');
                    $('#photoUpload').val('');
                    $('#user_type').val('');
                    $('.previewHolder').attr('src', '');

                });

                //preview image user
                function readURL(input) {
                    if (input.files && input.files[0]) {
                        var reader = new FileReader();
                        reader.onload = function(e) {
                            $('.previewHolder').attr('src', '');
                            $('.previewHolder').attr('src', e.target.result);
                            $('.previewHolder').css('width', '100px')
                        }
                        reader.readAsDataURL(input.files[0]);
                    } else {
                        alert('select a file to see preview');
                        $('.previewHolder').attr('src', '');
                    }
                }
                $("#photoUpload").change(function() {
                    readURL(this);
                });

                //preview image user
                function readURL(input) {
                    if (input.files && input.files[0]) {
                        var reader = new FileReader();
                        reader.onload = function(e) {
                            $('.previewUpdate').attr('src', '');
                            $('.previewUpdate').attr('src', e.target.result);
                            $('.previewUpdate').css('width', '100px')
                        }
                        reader.readAsDataURL(input.files[0]);
                    } else {
                        alert('select a file to see preview');
                        $('.previewUpdate').attr('src', '');
                    }
                }
                $(".photoUpdate").change(function() {
                    readURL(this);
                });
            });
        </script>
    <?php $__env->stopSection(); ?>

<?php echo $__env->make('back-end.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\sms_gatway_malaysia\resources\views/back-end/user/registerUser.blade.php ENDPATH**/ ?>