<?php $__env->startSection('title'); ?>
    Users List
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <section class="content">
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <ol class="breadcrumb ">
                            <li class="breadcrumb-item"><a href="<?php echo e(url('dashboard')); ?>">Dashboard</a></li>
                            <li class="breadcrumb-item active"><?php echo $__env->yieldContent('title'); ?></li>
                        </ol>
                    </div><!-- /.col -->
                </div><!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
        <!-- /.content-header -->

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12 my-2">
                        <form action="<?php echo e(url('sms-send-count')); ?>">
                            <div class="row">
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label for="start_date">Start Date</label>
                                        <input type="date" class="form-control" name="start_date" id="start_date"
                                            placeholder="Enter Start Date..."
                                            value="<?php echo e(isset($request->start_date) ? $request->start_date : \Carbon\Carbon::now()->format('Y-m-d')); ?>">
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label for="end_date">End Date</label>
                                        <input type="date" class="form-control" name="end_date" id="end_date"
                                            placeholder="Enter End Date..."
                                            value="<?php echo e(isset($request->end_date) ? $request->end_date : \Carbon\Carbon::now()->format('Y-m-d')); ?>">
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group" style="margin-top: 32px;">
                                        <button class="btn btn-success" id="submit"><i class="fas fa-search"></i>
                                            Search</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="col-12">
                        <?php if($request->start_date && $request->end_date): ?>
                            <p>Search From
                                <strong><?php echo e(\Carbon\Carbon::parse($request->start_date)->format('Y-m-d')); ?></strong> To
                                <strong><?php echo e(\Carbon\Carbon::parse($request->end_date)->format('Y-m-d')); ?></strong>
                            </p>
                        <?php endif; ?>
                        <div class="card">
                            <div class="card-header bg-gray text-bold">
                                Users List
                            </div>
                            <table class="table align-middle mb-0 bg-white table-bordered">
                                <thead class="bg-light">
                                    <tr>
                                        <th>SL</th>
                                        <th>Name</th>
                                        <th>Email</th>
                                        <th>Sms Send</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                        $serial = 1; /* ($users->currentpage() - 1) * $users->perpage() + 1; */
                                    ?>
                                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td>
                                                <?php echo e($serial++); ?>

                                            </td>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <div class="ms-3">
                                                        <p class="fw-bold mb-1"><?php echo e($user->name); ?></p>
                                                    </div>
                                                </div>
                                            </td>
                                            <td>
                                                <p class="fw-normal mb-1"><?php echo e($user->email); ?></p>
                                            </td>


                                            <td>
                                                

                                                <button type="button" data-toggle="modal" data-target="#exampleModal"
                                                    data-end_date="<?php echo e($request->end_date); ?>"
                                                    data-start_date="<?php echo e($request->start_date); ?>"
                                                    data-user_id="<?php echo e($user->id); ?>"
                                                    class="btn btn-<?php echo e($user->contacts->count() > 0 ? 'primary' : 'danger'); ?> btn-sm rounded-pill btn-rounded text-light show_pop_up">
                                                    <i class="fas fa-eye"></i> <?php echo e($user->contacts->count()); ?>

                                                </button>
                                                
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td colspan="3" class="text-right">Total Sms Send</td>
                                        <td><?php echo e($total_sms); ?></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Modal -->
            <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-xl">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">×</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <div class="col-12">
                                <form>
                                    <div class="form-row   mb-3">
                                        <div class="col-md-2">
                                            <label for="sms_id">ID</label>
                                            <input type="search" class="form-control" name="sms_id" id="sms_id_value"
                                                placeholder="Enter Sms ID..." value="">
                                            <input type="hidden" name="user_id" id="user_id_value" value="">
                                        </div>
                                        <input type="hidden" name="start_date" id="start_date_velue" value="">
                                        <input type="hidden" name="end_date" id="end_date_value" value="">
                                        <div class="col-md-3">
                                            <label for="sender_id">Sender ID</label>
                                            <input type="search" class="form-control" name="sender_id"
                                                placeholder="Enter Sender ID..." id="sender_id_value" value="">
                                        </div>
                                        <div class="col-md-4">
                                            <label for="recipient_phone_number">Recipient Phone Number</label>
                                            <input type="search" class="form-control" name="recipient_phone_number"
                                                placeholder="Enter Recipient Number..." id="recipient_phone_number_value"
                                                value="">
                                        </div>

                                        <div class="col-md-12 mt-2">
                                            <button class="btn btn-success" type="button" id="searchMe"><i
                                                    class="fas fa-search"></i>
                                                Search</button>
                                        </div>
                                    </div>
                                </form>
                            </div>

                            <div id="showListOfData"></div>
                        </div>
                        <div class="modal-footer justify-content-between">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        </div>
                    </div>

                </div>
            </div>
            <?php $__env->startPush('js'); ?>
                <script>
                    $(document).ready(function() {
                        $(".show_pop_up").click(function(e) {
                            e.preventDefault();
                            var end_date = $(this).data('end_date');
                            var start_date = $(this).data('start_date');
                            var user_id = $(this).data('user_id');

                            $("#sms_id_value").val("");
                            $("#user_id_value").val(user_id);
                            $("#start_date_velue").val(start_date);
                            $("#end_date_value").val(end_date);
                            $("#recipient_phone_number_value").val("");
                            $("#sender_id_value").val("");
                            showListOfSendSms(end_date, start_date, user_id);

                        });

                        $("#searchMe").click(function(e) {
                            e.preventDefault();
                            var user_id = $("#user_id_value").val();
                            var start_date = $("#start_date_velue").val();
                            var end_date = $("#end_date_value").val();
                            var sender_id = $("#sender_id_value").val();
                            var sms_id = $("#sms_id_value").val();
                            var recipient_phone_number = $("#recipient_phone_number_value").val();

                            showListOfSendSms(end_date, start_date, user_id, sms_id, recipient_phone_number, sender_id)
                        });


                        function showListOfSendSms(end_date, start_date, user_id, sms_id = null, recipient_phone_number = null,
                            sender_id = null) {
                            $.ajax({
                                type: "GET",
                                url: "<?php echo e(url('show-list-of-send-sms')); ?>",
                                dataType: 'json',
                                data: {
                                    end_date: end_date,
                                    start_date: start_date,
                                    user_id: user_id,
                                    sms_id: sms_id,
                                    sender_id: sender_id,
                                    recipient_phone_number: recipient_phone_number
                                },
                                success: function(response) {
                                    console.log(response);
                                    updateUIWithData(response.data);
                                },
                                error: function(error) {
                                    console.log(error);
                                }
                            });
                        }

                        $(document).on('click', '.pagination a', function(e) {
                            e.preventDefault();
                            var url = $(this).attr('href');
                            $.ajax({
                                url: url,
                                type: 'get',
                                dataType: 'json',
                                success: function(response) {
                                    // Update the content with the new data
                                    console.log(response);
                                    updateUIWithData(response.data);
                                }
                            });
                        });

                        // for server 
                        // $(document).on('click', '.pagination a', function(e) {
                        //     e.preventDefault();
                        //     var url = $(this).attr('href');
                        //     // Replace http with https
                        //     url = url.replace(/^http:\/\//i, 'https://');
                        //     $.ajax({
                        //         url: url,
                        //         type: 'get',
                        //         dataType: 'json',
                        //         success: function(response) {
                        //             // Update the content with the new data
                        //             console.log(response);
                        //             updateUIWithData(response.data);
                        //         }
                        //     });
                        // });

                        function updateUIWithData(data) {
                            $('#showListOfData').html("");
                            $('#showListOfData').html(data);
                        }
                    });
                </script>
            <?php $__env->stopPush(); ?>
        </section>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('back-end.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\sms_gatway_malaysia\resources\views/back-end/sms/smsSendCount.blade.php ENDPATH**/ ?>