

<?php $__env->startSection('title'); ?>
    Users List
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <section class="content">
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <ol class="breadcrumb ">
                            <li class="breadcrumb-item"><a href="<?php echo e(url('dashboard')); ?>">Dashboard</a></li>
                            <li class="breadcrumb-item active"><?php echo $__env->yieldContent('title'); ?></li>
                        </ol>
                    </div><!-- /.col -->
                </div><!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
        <!-- /.content-header -->

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12 my-2">
                        <form action="<?php echo e(url('voice-play-report')); ?>">
                            <div class="row">
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label for="start_date">Start Date</label>
                                        <input type="date" class="form-control" name="start_date" id="start_date"
                                            placeholder="Enter Start Date..."
                                            value="<?php echo e(isset($request->start_date) ? $request->start_date : \Carbon\Carbon::now()->format('Y-m-d')); ?>">
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label for="end_date">End Date</label>
                                        <input type="date" class="form-control" name="end_date" id="end_date"
                                            placeholder="Enter End Date..."
                                            value="<?php echo e(isset($request->end_date) ? $request->end_date : \Carbon\Carbon::now()->format('Y-m-d')); ?>">
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group" style="margin-top: 32px;">
                                        <button class="btn btn-success" id="submit"><i class="fas fa-search"></i>
                                            Search</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="col-6">
                        <?php

                            $start_date = isset($request->start_date)
                                ? \Carbon\Carbon::parse($request->start_date)->format('Y-m-d')
                                : null;
                            $end_date = isset($request->end_date)
                                ? \Carbon\Carbon::parse($request->end_date)->format('Y-m-d')
                                : null;
                        ?>
                        <?php if($request->start_date && $request->end_date): ?>
                            <p>Search From
                                <strong><?php echo e(\Carbon\Carbon::parse($request->start_date)->format('Y-m-d')); ?></strong> To
                                <strong><?php echo e(\Carbon\Carbon::parse($request->end_date)->format('Y-m-d')); ?></strong>
                            </p>
                        <?php endif; ?>
                        <div class="card">
                            <div class="card-header bg-gray text-bold">
                                Call To 734324324
                            </div>
                            <table class="table align-middle mb-0 bg-white table-bordered">
                                <thead class="bg-light">
                                    <tr>
                                        <th>Date</th>
                                        <th>Number of Play</th>
                                        <th>Number of download</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $plays; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $play): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e(\Carbon\Carbon::parse($play->date)->format('d/m/Y')); ?></td>
                                        <td>
                                            <button data-toggle="modal" data-target="#playtime" class="playtime" data-id="<?php echo e($play->id); ?>">
                                                <?php echo e($play->play->count()); ?>

                                            </button>
                                        </td>
                                        <td>
                                            <button data-toggle="modal" data-target="#download" class="downloadTime" data-id="<?php echo e($play->id); ?>">
                                                <?php echo e($play->download->count()); ?>

                                            </button>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                        
                        <!-- Modal -->
                        <div class="modal fade" id="playAudioModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                            <div class="modal-dialog modal-dialog-centered" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="exampleModalLongTitle">Play Recoding Numbers</h5>
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                    </div>
                                    <div class="modal-body" id="showNumbers"></div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="modal fade" id="DownlaodAudioModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                            <div class="modal-dialog modal-dialog-centered" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="exampleModalLongTitle">Download Recording Numbers</h5>
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                    </div>
                                    <div class="modal-body" id="showNumbers2"></div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        

                    </div>
                </div>
            </div>
            <?php $__env->startPush('js'); ?>
                <script>
                    $(document).ready(function() {
                 
                        $(".playtime").click(function(e){
                            
                            e.preventDefault();
                            var id = $(this).data('id');
                            $.ajax({
                                url: "<?php echo e(secure_url('play-numbers-ajax')); ?>",
                                type: 'get',
                                data: {
                                    id:id
                                },
                                success: function(response) {
                                    $('#playAudioModal').modal('show');
                                    $("#showNumbers").html(response);
                                }
                            });
                        });
                     
                 
                        $(".downloadTime").click(function(e){
                            
                            e.preventDefault();
                            var id = $(this).data('id');
                            $.ajax({
                                url: "<?php echo e(secure_url('download-numbers-ajax')); ?>",
                                type: 'get',
                                data: {
                                    id:id
                                },
                                success: function(response) {
                                    $('#DownlaodAudioModal').modal('show');
                                    $("#showNumbers2").html(response);
                                }
                            });
                        });
                     
                    });
                </script>
            <?php $__env->stopPush(); ?>
        </section>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('back-end.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/jitato/public_html/resources/views/back-end/voice/report.blade.php ENDPATH**/ ?>