<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Basic;
use App\Models\Contact;
use App\Models\SmsConfig;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Http;

class ExcelSmsSend extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:excel-sms-send';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        ini_set('memory_limit', '256M');
        try {
            $basic = Basic::find(1);
            $today = now();
            $contacts = Contact::where('active_status', 0)
                ->whereDate('date_time', $today->toDateString())
                ->where('sms_api_id', '!=', null)
                ->take($basic->total_sms_send_at_a_time)
                ->get();

            if ($contacts->isEmpty()) {
                Log::info('No pending SMS to send.');
                return;
            }

            DB::beginTransaction();

            foreach ($contacts as $contact) {
                $config = SmsConfig::findOrFail($contact->sms_api_id);

                $apiUrl = $config->api_url;
                $api_key = $config->api_key;
                $type = $config->type;
                $senderid = $config->sender_id;

                $response = Http::get("$apiUrl", [
                    'api_key' => $api_key,
                    'type' => $type,
                    'number' => $contact->recipient_phone_number,
                    'senderid' => $senderid,
                    'message' => $contact->sms_content,
                ]);

                // Check if the request was successful
                if ($response->successful()) {
                   
                        $contact->update([
                            'sender_id' => $config->sender_id,
                            'system_send_time' => Carbon::now(),
                            'active_status' => 1,
                        ]);
                    Log::info('ExcelSMS sent '.$response->body());
                } else {
                    // Handle HTTP error
                    Log::info('ExcelSMS HTTP error: '.$response->status());
                    // echo 'HTTP error: ' . $response->status();
                }

            }

            DB::commit();

            Log::info('ExcelSMS sent successfully.');
        } catch (\Exception $e) {
            DB::rollBack();

            Log::error('Error while sending Excel SMS: ' . $e->getMessage());
        }
    }
}
