<?php

namespace App\Console\Commands;

use App\Basic;
use App\Models\Contact;
use App\Models\SmsConfig;
use App\Models\SmsTemplete;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class SendSms extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:send-sms';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Sms send command';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        ini_set('memory_limit', '256M'); 
        try {
            $template = SmsTemplete::where('active_status', 1)->first();
            $config = SmsConfig::where('status', 1)->first();
            
            if ($config->status == 2) {
                Log::error('Auto sms inactive.');
                return;
            }

            if (!$template) {
                Log::error('No active SMS template found.');
                return;
            }
    
    
            $basic = Basic::find(1);
            $today = now(); 
            $contacts = Contact::where('active_status', 0)
                        ->whereDate('date_time', $today->toDateString())
                        ->where('sms_api_id', null)
                        ->take($basic->total_sms_send_at_a_time)
                        ->get();
    
            if ($contacts->isEmpty()) {
                Log::info('No pending SMS to send.');
                return;
            }
    
            DB::beginTransaction();
    
            foreach ($contacts as $contact) {
                sms($contact->recipient_phone_number, $template->message);
    
                $contact->update([
                    'sender_id' => $config->sender_id,
                    'sms_content' => $template->message,
                    'system_send_time' => Carbon::now(),
                    'active_status' => 1,
                ]);
            }
    
            DB::commit();
    
            Log::info('SMS sent successfully.');
        } catch (\Exception $e) {
            DB::rollBack();
    
            Log::error('Error while sending SMS: ' . $e->getMessage());
        }
    }
}
