<?php

namespace App\Console\Commands;

use App\Models\Contact;
use App\Models\SmsConfig;
use App\Models\YeasterConfig;
use Carbon\Carbon;
use Illuminate\Console\Command;

class SmsGetCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:sms-get';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'get sms form api yester';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        ini_set('memory_limit', '256M'); 
        $config = YeasterConfig::latest()->first();
        $smsConfig = SmsConfig::latest()->first();
    
        $yeasterToken = yeaster_token();
    
        $curl = curl_init();
    
        curl_setopt_array($curl, [
            CURLOPT_URL => 'https://doctormobile.linkuspbx.com/openapi/v1.0/cdr/list?access_token=' . $yeasterToken . '&sort_by=id&order_by=desc&status=ANSWERED&call_type=Outbound',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ]);
    
        $response = curl_exec($curl);
    
        curl_close($curl);
        // Decode the JSON response
        $data = json_decode($response, true);
        
        // Check if decoding was successful
        if (json_last_error() !== JSON_ERROR_NONE) {
            $notification = ['error' => 'Oops! Something is wrong...!'];
    
            return redirect()->back()->with($notification);
        }
    
        $filterParams = [
            'disposition' => $config->call_status,
            'call_type' => $config->communication_type,
            'call_duration' => $config->call_duration,
        ];
    
        $filteredData = array_filter($data['data'], function ($call) use ($filterParams) {
            return $call['disposition'] === $filterParams['disposition']
                && $call['call_type'] === $filterParams['call_type']
                && $call['duration'] >= $filterParams['call_duration'];
        });
    
        usort($filteredData, function ($a, $b) {
            return $b['id'] - $a['id'];
        });
    
        
        $existingNumbers = Contact::whereIn('recipient_phone_number', collect($filteredData)->pluck('call_to_number')->toArray())->pluck('recipient_phone_number')->toArray();
    
     
        $cleanedExistingNumbers = array_map(function ($number) {
            return preg_replace('/[^0-9]/', '', $number);
        }, $existingNumbers);
        
        $contactsToInsert = collect($filteredData)->reject(function ($yeasterContact) use ($cleanedExistingNumbers) {
            $cleanedNumber = preg_replace('/[^0-9]/', '', $yeasterContact['call_to_number']);
            
            // Remove "+" and "9" at the beginning of the number
            $cleanedNumber = preg_replace('/^[+9]|^9/', '', $cleanedNumber);
            
            return in_array($cleanedNumber, $cleanedExistingNumbers);
        });

        $contactsToInsert->each(function ($yeasterContact) use ($smsConfig) {
            $have_contact = Contact::where('recipient_phone_number', str_replace('+', '', $yeasterContact['call_to_number']))->first();
            if (!$have_contact) {
                $contact = new Contact([
                    'date_time' => Carbon::createFromFormat('d/m/Y H:i:s', $yeasterContact['time']),
                    'sender_id' => '',
                    'sms_id' => $yeasterContact['id'],
                    'recipient_phone_number' => str_replace('+', '', $yeasterContact['call_to_number']),
                    'active_status' => 0,
                ]);
        
                $contact->save();
            }
        });
    }
}
