<?php

namespace App\Console\Commands;

use App\Basic;
use App\Models\Contact;
use App\Models\MyAlice;
use App\Models\SmsConfig;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class WhatsAppSmsSend extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:whats-app-sms-send';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        ini_set('memory_limit', '256M'); 
        try {
            $templates = api_template();
          
            $config = MyAlice::latest()->first();
            
            if ($config->status == 2) {
                Log::error('Auto Whats App sms inactive.');
                return;
            }

            if (!$templates) {
                Log::error('No Whats App SMS template found.');
                return;
            }
    
    
            $basic = Basic::find(1);
            $today = now(); 
            $contacts = Contact::where('whats_app_sms_send_status', 0)
                        ->whereDate('date_time', $today->toDateString())
                        ->take($basic->total_sms_send_at_a_time)
                        ->get();
    
            if ($contacts->isEmpty()) {
                Log::info('No pending Whats App SMS to send.');
                return;
            }
    
            DB::beginTransaction();
    
            foreach ($contacts as $contact) {
                $message = '';
                $response = my_alice_sms($contact->recipient_phone_number);
                if ($response !== null) {

                    $templateName = $response['extra']['template_name'];
                    $filteredArray = array_filter($templates, function ($item) use ($templateName) {
                        return isset($item['name']) && $item['name'] === $templateName;
                    });
                
                    $message = $filteredArray[0]['body'];
                } else {
                    // Handle JSON decoding error
                    echo "Error decoding JSON response.";
                }
                $contact->update([
                    'platform_id' => $config->channel_id,
                    'whats_app_sms_content' => $message,
                    'date_time_whats_app_sms_send' => Carbon::now(),
                    'whats_app_sms_send_status' => 1,
                ]);
            }
    
            DB::commit();
    
            Log::info('Whats App SMS sent successfully.');
        } catch (\Exception $e) {
            DB::rollBack();
    
            Log::error('Error while sending SMS: ' . $e->getMessage());
        }
    }
}
