<?php

namespace App\Http\Controllers;

use App\Models\Contact;
use App\Models\SmsConfig;
use Carbon\Carbon;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
    public function index()
    {

        $today = now(); // Carbon::now() also works
        $data['total_send_sms'] = Contact::where('active_status', 1)->count();
        $data['total_whatsapp_send_sms'] = Contact::where('whats_app_sms_send_status', 1)->count();
        $data['total_unsend_sms'] = Contact::where('active_status', 0)
                            ->whereDate('date_time', $today->toDateString())
                            ->count();
        $data['total_whatsapp_unsend_sms'] = Contact::where('whats_app_sms_send_status', 0)
                            ->whereDate('date_time', $today->toDateString())
                            ->count();

        $yesterday = Carbon::yesterday();
        $data['yesterday_sms_send'] = Contact::where('active_status', 1)
            ->whereDate('date_time', $yesterday)
            ->count();
        $data['yesterday_whatsapp_sms_send'] = Contact::where('whats_app_sms_send_status', 1)
            ->whereDate('date_time', $yesterday)
            ->count();

        $lastWeekStart = Carbon::now()
            ->subWeek()
            ->startOfWeek();
        $lastWeekEnd = Carbon::now()
            ->subWeek()
            ->endOfWeek();

        $data['last_weak_sms_send'] = Contact::where('active_status', 1)
            ->whereBetween('date_time', [$lastWeekStart, $lastWeekEnd])
            ->count();
        $data['last_weak_whatsapp_sms_send'] = Contact::where('whats_app_sms_send_status', 1)
            ->whereBetween('date_time', [$lastWeekStart, $lastWeekEnd])
            ->count();

        $data['today_sms_send'] = Contact::where('active_status', 1)
            ->whereDate('date_time', $today->toDateString())
            ->count();

        $data['today_whatsapp_sms_send'] = Contact::where('whats_app_sms_send_status', 1)
            ->whereDate('date_time', $today->toDateString())
            ->count();

        return view('back-end.deshboard', $data);
    }
}
