<?php

namespace App\Http\Controllers;

use App\Basic;
use App\Models\Contact;
use App\Models\MyAlice;
use App\Models\SmsConfig;
use App\Models\YeasterConfig;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Http;

class MyAliceController extends Controller
{
    public function indexConfig()
    {
        $data['myalice'] = MyAlice::latest()->first();
        return view('back-end.myalice.myalice_config', $data);
    }

    public function whatsAppSmsConfigStore(Request $request)
    {
        $request->validate([
            'api_url' => 'required|string|max:255',
            'api_key' => 'required|string|max:50',
            'channel_id' => 'required|string|max:50',
            'template_id' => 'required|string|max:50',
        ]);

        $config = MyAlice::latest()->first();
        if (!$config) {
            $config = new MyAlice();
        }

        $config->api_url = $request->api_url;
        $config->api_key = $request->api_key;
        $config->channel_id = $request->channel_id;
        $config->template_id = $request->template_id;
        $config->created_by = Auth::id();
        $config->save();

        if ($config == true) {
            $notification = [
                'success' => 'Config Save Successfully',
            ];
        } else {
            $notification = [
                'error' => 'Opps! Something is wrong...!',
            ];
        }

        return redirect()
            ->back()
            ->with($notification);
    }

    public function updateWhatsAppSmsConfigStoreAjax(Request $request)
    {
        $status = $request->status;

        MyAlice::latest()
            ->first()
            ->update(['status' => $status]);

        return response()->json(['success' => 1]);
    }

    public function whatsAppTemplate()
    {
        $data['templates'] = api_template();
        return view('back-end.templete.whats_app_template', $data);
    }

    public function whatsAppSmsInbox(Request $request)
    {
        $basic = Basic::find(1);
        $data['request'] = $request;
        $date = Carbon::parse($request->date_time_whats_app_sms_send)->format('Y-m-d');

        $data['contacts'] = Contact::orderBy('date_time_whats_app_sms_send', 'desc')
            ->when(isset($request->sms_id), function ($query) use ($request) {
                $query->where('sms_id', $request->sms_id);
            })
            ->when(isset($request->platform_id), function ($query) use ($request) {
                $query->where('platform_id', $request->platform_id);
            })
            ->when(isset($request->recipient_phone_number), function ($query) use ($request) {
                $query->where('recipient_phone_number', 'like', '%' . $request->recipient_phone_number . '%');
            })
            ->when(isset($request->date_time_whats_app_sms_send), function ($query) use ($date) {
                $query->whereDate('date_time_whats_app_sms_send', 'like', '%' . $date . '%');
            })
            // ->when(isset($request->whats_app_sms_send_status) && $request->whats_app_sms_send_status != 2, function ($query) use ($request) {
            //     $query->where('whats_app_sms_send_status', $request->whats_app_sms_send_status);
            // })
            ->when(function ($query) use ($request) {
                return Arr::get($request, 'whats_app_sms_send_status', 1) != 2;
            }, function ($query) use ($request) {
                $query->where('whats_app_sms_send_status', Arr::get($request, 'whats_app_sms_send_status', 1));
            })
            ->paginate($basic->pagination_limit);
        return view('back-end.myalice.send_whats_app_sms_index', $data);
    }

    public function sendWhatsAppSms()
    {
        return view('back-end.myalice.send_whats_app_sms');
    }

    public function sendManualWhatsAppSms(Request $request)
    {

        $config = MyAlice::latest()->first();

        $templates = api_template();
        if ($templates) {
            $stringFormat = $request->numbers;
            preg_match_all('/\d+/', $stringFormat, $matches);
            $numbers = $matches[0];

            for ($i = 0; $i < count($numbers); $i++) {

                $message = '';
                $response = my_alice_sms($numbers[$i]);
                
                if ($response !== null) {

                    $templateName = $response['extra']['template_name'];
                    $filteredArray = array_filter($templates, function ($item) use ($templateName) {
                        return isset($item['name']) && $item['name'] === $templateName;
                    });
                
                    $message = $filteredArray[1]['body'];
                } else {
                    // Handle JSON decoding error
                    echo "Error decoding JSON response.";
                }
          
                // $contact = Contact::where('recipient_phone_number', $numbers[$i])
                //     ->where('active_status', 0)
                //     ->first();

                // if (!$contact) {
                //     $contact = new Contact();
                // }

                $contact = new Contact();
                $contact->date_time = Carbon::now();
                $contact->date_time_whats_app_sms_send = Carbon::now();
                $contact->platform_id = $config->channel_id;
                $contact->recipient_phone_number = $numbers[$i];
                $contact->whats_app_sms_content = $message;
                $contact->whats_app_sms_send_status = 1;
                $contact->save();
            }

            $notification = [
                'success' => 'Sms Send Successfully',
            ];

            return redirect()->back()->with($notification);
        } else {

            $notification = [
                'error' => 'Opps! Something is wrong...!',
            ];
        }

        return redirect()->back()->with($notification);
    }


    public function getTodaysNumbers()
    {
        ini_set('memory_limit', '256M'); 
        $config = YeasterConfig::latest()->first();
        $smsConfig = SmsConfig::latest()->first();
    
        $yeasterToken = yeaster_token();
    
        $curl = curl_init();
    
        curl_setopt_array($curl, [
            CURLOPT_URL => 'https://doctormobile.linkuspbx.com/openapi/v1.0/cdr/list?access_token=' . $yeasterToken . '&sort_by=id&order_by=desc&status=ANSWERED&call_type=Outbound',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ]);
    
        $response = curl_exec($curl);
    
        curl_close($curl);
        // Decode the JSON response
        $data = json_decode($response, true);
        if (json_last_error() !== JSON_ERROR_NONE) {
            $notification = ['error' => 'Oops! Something is wrong...!'];
    
            return redirect()->back()->with($notification);
        }
    
        $filterParams = [
            'disposition' => $config->call_status,
            'call_type' => $config->communication_type,
            'call_duration' => $config->call_duration,
            // 'time' => ,
        ];
    
        $filteredData = array_filter($data['data'], function ($call) use ($filterParams) {
            $callDate = Carbon::createFromFormat('d/m/Y H:i:s', $call['time'])->startOfDay();
            $today = Carbon::now()->startOfDay();
        
            return $call['disposition'] === $filterParams['disposition']
                && $call['call_type'] === $filterParams['call_type']
                && $call['duration'] >= $filterParams['call_duration']
                && $callDate->eq($today);
        });
    
        usort($filteredData, function ($a, $b) {
            return $b['id'] - $a['id'];
        });
  
        $contactsToInsert = collect($filteredData)->reject(function ($yeasterContact) use ($filteredData) {
            $cleanedNumber = preg_replace('/[^0-9]/', '', $yeasterContact['call_to_number']);
            
            // Remove "+" and "9" at the beginning of the number
            $cleanedNumber = preg_replace('/^[+9]|^9/', '', $cleanedNumber);
            
            return in_array($cleanedNumber, $filteredData);
        });

        $contactsToInsert->each(function ($yeasterContact) use ($smsConfig) {
            $have_contact = Contact::where('recipient_phone_number', str_replace('+', '', $yeasterContact['call_to_number']))
            ->whereDate('date_time', Carbon::today())
            ->first();

            if (!$have_contact) {
                $contact = new Contact([
                    'date_time' => Carbon::createFromFormat('d/m/Y H:i:s', $yeasterContact['time']),
                    'sender_id' => '',
                    'sms_id' => $yeasterContact['id'],
                    'recipient_phone_number' => str_replace('+', '', $yeasterContact['call_to_number']),
                    'active_status' => 0,
                ]);
        
                $contact->save();
            }
        });
    }
}
