<?php

namespace App\Http\Controllers;

use App\Basic;
use App\Models\DatePlayAndDownloadAudio;
use App\Models\DownloadAudioNumber;
use Illuminate\Http\Request;
use App\Models\MyAlice;
use App\Models\PlayAudioNumber;
use App\Models\PlayHistory;
use App\Models\SmsConfig;
use App\Models\YeasterConfig;
use Carbon\Carbon;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\Redirect;

class VoicePlayReportController extends Controller
{
    public function index($number = '')
    {
        $yesterData = $this->getYesterData($number);
        return view('back-end.voice.index', compact('yesterData', 'number'));
    }

    public function report(Request $request)
    {
        $basic = Basic::find(1);
        $data['request'] = $request;
        $start_date = isset($request->start_date) ? Carbon::parse($request->start_date)->format('Y-m-d') : null;
        $end_date = isset($request->end_date) ? Carbon::parse($request->end_date)->format('Y-m-d') : null;

        $data['plays'] = DatePlayAndDownloadAudio::with('download','play')->orderBy('date', 'desc')
            ->when($start_date && $end_date, function ($query) use ($start_date, $end_date) {
                $query->whereDate('date', '>=', $start_date)->whereDate('date', '<=', $end_date);
            })
            ->paginate($basic->pagination_limit);
        return view('back-end.voice.report', $data);
    }

    public function playNumbersAjax(Request $request)
    {
        $numbers = PlayAudioNumber::where('date_id', $request->id)->get();
        return View::make('back-end.voice.reportRender', array('numbers' => $numbers))->render();
    }

    public function downloadNumbersAjax(Request $request)
    {
        $numbers = DownloadAudioNumber::where('date_id', $request->id)->get();
        return View::make('back-end.voice.reportRender', array('numbers' => $numbers))->render();
    }

    public function getYesterData($number)
    {
        ini_set('memory_limit', '256M');
        $config = YeasterConfig::latest()->first();
     

        $yeasterToken = yeaster_token();

        $curl = curl_init();

        curl_setopt_array($curl, [
            CURLOPT_URL => 'https://doctormobile.linkuspbx.com/openapi/v1.0/cdr/list?access_token=' . $yeasterToken . '&sort_by=id&order_by=desc&status=ANSWERED&call_type=Outbound',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ]);

        $response = curl_exec($curl);

        curl_close($curl);
        // Decode the JSON response
        $data = json_decode($response, true);
        if (json_last_error() !== JSON_ERROR_NONE) {
            $notification = ['error' => 'Oops! Something is wrong...!'];

            return redirect()->back()->with($notification);
        }
        
        $searchNumber = $number;
        $searchNumber = preg_replace('/[^0-9]/', '', $searchNumber); // Remove non-numeric characters
        $searchNumber = preg_replace('/^88/', '', $searchNumber); // Remove the country code if present

        $filterParams = [
            'call_to_number' => $searchNumber,
        ];

        $filteredData = array_filter($data['data'], function ($call) use ($filterParams) {
            $cleanedNumber = preg_replace('/[^0-9]/', '', $call['call_to_number']); // Remove non-numeric characters
            $cleanedNumber = preg_replace('/^88/', '', $cleanedNumber); // Remove the country code if present
            return $cleanedNumber === $filterParams['call_to_number'];
        });

        usort($filteredData, function ($a, $b) {
            return $b['id'] - $a['id'];
        });

        $contactsToInsert = collect($filteredData)->reject(function ($yeasterContact) use ($filteredData) {
            $cleanedNumber = preg_replace('/[^0-9]/', '', $yeasterContact['call_to_number']);

            // Remove "+" and "9" at the beginning of the number
            $cleanedNumber = preg_replace('/^[+9]|^9/', '', $cleanedNumber);

            return in_array($cleanedNumber, $filteredData);
        });
        
        return $contactsToInsert;
    }

    public function downloadRecordings(Request $request)
    {
        $id = $request->id;
        $database_file_path = PlayHistory::where('call_id', $id)->where('date', Carbon::now()->format('Y-m-d'))->first();

        $DatePlayAndDownloadAudio = DatePlayAndDownloadAudio::where('date', Carbon::now()->format('Y-m-d'))->first();

        if (!$DatePlayAndDownloadAudio) {
            $DatePlayAndDownloadAudio = DatePlayAndDownloadAudio::create(['date' => Carbon::now()]);
        }
        
        PlayAudioNumber::create([
            'date_id' => $DatePlayAndDownloadAudio->id,
            'numbers' => $request->number
        ]);

        if ($database_file_path) {
            $play_count = $database_file_path->count_play + 1;
            $database_file_path->update(['count_play' => $play_count]);

            
            return View::make('back-end.voice.audio_render', ['file_name' => $database_file_path->file_name])->render();
        }

        if (!$database_file_path) {
            $yeasterToken = yeaster_token();

            $curl = curl_init();

            curl_setopt_array($curl, [
                CURLOPT_URL => 'https://doctormobile.linkuspbx.com/openapi/v1.0/recording/download?id=' . urlencode($id) . '&access_token=' . $yeasterToken,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'GET',
                CURLOPT_VERBOSE => true, // Enable verbose mode
            ]);

            // Log cURL verbose output to a file
            $verbose = fopen('curl.log', 'w+');
            curl_setopt($curl, CURLOPT_STDERR, $verbose);

            $response = curl_exec($curl);

            $response_data = json_decode($response, true);

            if ($response_data !== null) {
                if (isset($response_data['download_resource_url'])) {
                    $full_download_url = 'https://doctormobile.linkuspbx.com' . $response_data['download_resource_url'] . '?access_token=' . $yeasterToken;

                    // File path to save the downloaded file
                    $file_path = 'public/audio/' . $id . '.wav';

                    if (!$database_file_path) {
                        $database_file_path = PlayHistory::create([
                            'call_id' => $id,
                            'file_name' => $file_path,
                            'count_play' => 1,
                            'count_download' => 0,
                            'number' => $request->number,
                            'date' => Carbon::now(),
                        ]);
                    }
                    if ($database_file_path) {
                        $play_count = $database_file_path->count_play + 1;
                        $database_file_path->update(['count_play' => $play_count]);
                    }
                    // Initialize a file pointer
                    $file_pointer = fopen($file_path, 'w');

                    // Initialize cURL session
                    $curl = curl_init();

                    // Set cURL options
                    curl_setopt_array($curl, [
                        CURLOPT_URL => $full_download_url,
                        CURLOPT_FILE => $file_pointer, // Write the response directly to the file
                        CURLOPT_FOLLOWLOCATION => true, // Follow redirects
                        CURLOPT_SSL_VERIFYPEER => false, // Disable SSL verification (use with caution)
                    ]);

                    // Execute the request
                    curl_exec($curl);

                    // Check for errors
                    if (curl_errno($curl)) {
                        echo 'Error: ' . curl_error($curl);
                    } else {
                        return View::make('back-end.voice.audio_render', ['file_name' => $file_path])->render();
                    }

                    // Close cURL session
                    curl_close($curl);

                    // Close the file pointer
                    fclose($file_pointer);
                } else {
                    echo 'Error: Download resource URL not found in response.';
                }
            } else {
                echo 'Error: Failed to decode JSON response.';
            }
        }
    }

    public function downloadRecordingInLocal($audio_id, $number)
    {
        $id = $audio_id;
        $database_file_path = PlayHistory::where('call_id', $id)->where('date', Carbon::now()->format('Y-m-d'))->first();
// Find or create a DatePlayAndDownloadAudio record for today's date
        $DatePlayAndDownloadAudio = DatePlayAndDownloadAudio::where('date', Carbon::now()->format('Y-m-d'))->first();
        if (!$DatePlayAndDownloadAudio) {
            $DatePlayAndDownloadAudio = DatePlayAndDownloadAudio::create(['date' => Carbon::now()]);
        }

        // Create a DownloadAudioNumber record associated with the DatePlayAndDownloadAudio
        DownloadAudioNumber::create(['date_id' => $DatePlayAndDownloadAudio->id, 'numbers' => $number]);


        if ($database_file_path) {
            $play_count = $database_file_path->count_download + 1;
            $database_file_path->update(['count_download' => $play_count]);

          $file_url = asset($database_file_path->file_name);
            // Check if the file exists
            if (isset($file_url)) {
        
                // Return a response with a redirect to the file URL
                return response()->redirectTo($file_url);
            } else {
                // File does not exist, return an appropriate response
                return response()->json(['error' => 'File not found'], 404);
            }
        }

        if (!$database_file_path) {
            $yeasterToken = yeaster_token();
            $curl = curl_init();

            curl_setopt_array($curl, [
                CURLOPT_URL => 'https://doctormobile.linkuspbx.com/openapi/v1.0/recording/download?id=' . urlencode($id) . '&access_token=' . $yeasterToken,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'GET',
                CURLOPT_VERBOSE => true, // Enable verbose mode
            ]);

            // Log cURL verbose output to a file
            $verbose = fopen('curl.log', 'w+');
            curl_setopt($curl, CURLOPT_STDERR, $verbose);

            $response = curl_exec($curl);

            $response_data = json_decode($response, true);

            if ($response_data !== null) {
                if (isset($response_data['download_resource_url'])) {
                    $full_download_url = 'https://doctormobile.linkuspbx.com' . $response_data['download_resource_url'] . '?access_token=' . $yeasterToken;

                    // File path to save the downloaded file
                    $file_path = 'public/audio/' . $id . '.wav';

                    if (!$database_file_path) {
                        $database_file_path = PlayHistory::create([
                            'call_id' => $id,
                            'file_name' => $file_path,
                            'count_download' => 1,
                            'number' => $number,
                            'date' => Carbon::now(),
                        ]);
                    }
                    // Initialize a file pointer
                    $file_pointer = fopen($file_path, 'w');

                    // Initialize cURL session
                    $curl = curl_init();

                    // Set cURL options
                    curl_setopt_array($curl, [
                        CURLOPT_URL => $full_download_url,
                        CURLOPT_FILE => $file_pointer, // Write the response directly to the file
                        CURLOPT_FOLLOWLOCATION => true, // Follow redirects
                        CURLOPT_SSL_VERIFYPEER => false, // Disable SSL verification (use with caution)
                    ]);

                    // Execute the request
                    curl_exec($curl);

                    // Close cURL session
                    curl_close($curl);

                    // Close the file pointer
                    fclose($file_pointer);

                   
          $file_url = asset($database_file_path->file_name);
        
            // Check if the file exists
            if (file_exists($file_url)) {
                // Return a response with a redirect to the file URL
                return response()->redirectTo($file_url);
            } else {
                // File does not exist, return an appropriate response
                return response()->json(['error' => 'File not found'], 404);
            }
                } else {
                    info('Error: Download resource URL not found in response.');
                }
            }
        }


        
    }
}