<?php

namespace App\Http\Controllers;

use App\Models\YeasterConfig;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Http;

class YesterApiController extends Controller
{
    public function indexYeasterConfig()
    {
        // dd(yeaster_token());
        $data['yester_config'] = YeasterConfig::latest()->first();
        return view('back-end.yeaster.index', $data);
    }

    public function store(Request $request)
    {
        $request->validate([
            'username' => "required|string|max:256",
            'password' => "required|string|max:256",
        ]);

        $config = YeasterConfig::latest()->first();
        if (!$config) {
            $config = new YeasterConfig();
        }

        $config->username = $request->username;
        $config->password = $request->password;
        $config->call_status = $request->call_status;
        $config->call_duration = $request->call_duration;
        $config->communication_type = $request->communication_type;
        $config->created_by = Auth::id();
        $config->save();

        if ($config == true) {
            $notification = ([
                'success' => 'Config Save Successfully',
            ]);
        } else{
            $notification = ([
                'error' => 'Opps! Something is wrong...!',
            ]);
        }

        return redirect()->back()->with($notification);

    }
}
