<?php

namespace App\Imports;

use App\Models\Contact;
use Carbon\Carbon;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Maatwebsite\Excel\Concerns\ToCollection;

class ImportNumbersWithMessage implements ToCollection
{
    /**
    * @param Collection $collection
    */
    
    private $data;

    public function __construct($data)
    {
        $this->data = $data;
    }
    public function collection(Collection $collection)
    {

        // Skip the header row
        $collection = $collection->skip(1);
    
        if ($collection->isNotEmpty()) {
           
            $collection->each(function ($row) {
                
                $phone = $row[0]; 
                $username = $row[$this->data['username']];
                $website = $row[$this->data['website']]; 
                $whatsapp = $row[$this->data['whatsapp']];
                $password = $row[$this->data['password']]; 
    
                // Example: Create a new Contact model if it doesn't exist for the phone number today
                $have_contact = Contact::where('recipient_phone_number', str_replace('+', '', $phone))
                    ->whereDate('date_time', Carbon::today())
                    ->first();
    
                $name_id = Session::get('name_id');

                $message = "Username: $username. Website: $website. Whatsapp: $whatsapp. Password: $password";

                if (!$have_contact) {
                    $contact = new Contact([
                        'date_time' => Carbon::now(), 
                        'sender_id' => '', 
                        'sms_id' => '', 
                        'sms_content' =>  $message,
                        'recipient_phone_number' => str_replace('+', '', $phone),
                        'active_status' => 0,
                        "sms_api_id" => $name_id,
                        "created_by" => Auth::Id(),
                    ]);
    
                    $contact->save();
                }
            });
    
            return 'Contacts created successfully.';
        } else {
            return 'No data found in the Excel file.';
        }
    }
}
