<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Contact extends Model
{
    use HasFactory, SoftDeletes;

    protected $guarded = [];

    public function user()
    {
         // Check if $this->created_by is not null before defining the relationship
         if ($this->created_by !== 0) {
            return $this->belongsTo(User::class, 'created_by');
        } else {
            // Handle the case where created_by is null, return null or handle it accordingly
            return null;
        }
    }
}
