<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('contacts', function (Blueprint $table) {
            $table->string('platform_id')->nullable();
            $table->dateTime('date_time_whats_app_sms_send')->nullable();
            $table->string('whats_app_sms_content')->nullable();
            $table->string('whats_app_sms_send_status')->default('0')->comment('1=send sms; 0=not send')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('contacts', function (Blueprint $table) {
            $table->dropColumn('platform_id')->nullable();
            $table->dropColumn('date_time_whats_app_sms_send')->nullable();
            $table->dropColumn('whats_app_sms_content')->nullable();
            $table->dropColumn('whats_app_sms_send_status')->default('0')->comment('1=send sms; 0=not send')->nullable();
        });
    }
};
