@extends('back-end.layouts.master')

@section('title')
    Deshboard
@endsection

@section('content')
    <section class="content">
        <div class="container-fluid">
            <div class="border border-rounded p-2 border-primary">
                <div class="row">
                    <div class="col-12 col-sm-6 col-md-3">
                        <a href="#" style="color:#000 !important;">
                            <div class="info-box">
                                <span class="info-box-icon bg-info elevation-1"><i class="fab fa-product-hunt"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Total Send SMS</span>
                                    <span class="info-box-number">
                                        {{ $total_send_sms }}
                                    </span>
                                </div>
                                <!-- /.info-box-content -->
                            </div>
                        </a>
                        <!-- /.info-box -->
                    </div>
                    <div class="col-12 col-sm-6 col-md-3">
                        <a href="#" style="color:#000 !important;">
                            <div class="info-box">
                                <span class="info-box-icon bg-info elevation-1"><i class="fab fa-product-hunt"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Total Unsend SMS</span>
                                    <span class="info-box-number">
                                        {{ $total_unsend_sms }}
                                    </span>
                                </div>
                                <!-- /.info-box-content -->
                            </div>
                        </a>
                        <!-- /.info-box -->
                    </div>
                       <div class="col-12 col-sm-6 col-md-3">
                        <a href="#" style="color:#000 !important;">
                            <div class="info-box">
                                <span class="info-box-icon bg-info elevation-1"><i class="fab fa-product-hunt"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Todays Sms Send</span>
                                    <span class="info-box-number">
                                        {{ $today_sms_send }} 
                                    </span>
                                </div>
                                <!-- /.info-box-content -->
                            </div>
                        </a>
                        <!-- /.info-box -->
                    </div>
                    <div class="col-12 col-sm-6 col-md-3">
                        <a href="#" style="color:#000 !important;">
                            <div class="info-box">
                                <span class="info-box-icon bg-info elevation-1"><i class="fab fa-product-hunt"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Yesterday Sms Send</span>
                                    <span class="info-box-number">
                                        {{ $yesterday_sms_send }} 
                                    </span>
                                </div>
                                <!-- /.info-box-content -->
                            </div>
                        </a>
                        <!-- /.info-box -->
                    </div>
                    <div class="col-12 col-sm-6 col-md-3">
                        <a href="#" style="color:#000 !important;">
                            <div class="info-box">
                                <span class="info-box-icon bg-info elevation-1"><i class="fab fa-product-hunt"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Last Week Sms Send</span>
                                    <span class="info-box-number">
                                        {{ $last_weak_sms_send }} 
                                    </span>
                                </div>
                                <!-- /.info-box-content -->
                            </div>
                        </a>
                        <!-- /.info-box -->
                    </div>
                     @php
                    $configs =  App\Models\SmsConfig::orderBy('name')->get();
                    $response = null;
                    @endphp

                    @foreach ($configs as $config)
                    @php

                    if ($config) {
                        $url = 'http://bulksmsbd.net/api/getBalanceApi';
                        $api_key = $config->api_key;
                        $data = [
                            'api_key' => $api_key,
                        ];
                        $ch = curl_init();
                        curl_setopt($ch, CURLOPT_URL, $url);
                        curl_setopt($ch, CURLOPT_POST, 1);
                        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
                        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                        $response = curl_exec($ch);
                        curl_close($ch);
                    }
            
                    $balance = json_decode($response)->balance ?? 0;
                    @endphp
                    <div class="col-12 col-sm-6 col-md-3">
                        <a href="#" style="color:#000 !important;">
                            <div class="info-box">
                                <span class="info-box-icon bg-info elevation-1"><i class="fab fa-product-hunt"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Balance of "{{ $config->name }}"</span>
                                    <span class="info-box-number">
                                        {{ isset($balance) ? $balance : 0 }} BDT
                                    </span>
                                </div>
                                <!-- /.info-box-content -->
                            </div>
                        </a>
                        <!-- /.info-box -->
                    </div>
                    @endforeach
             
                </div>
            </div>
            <div class="border border-rounded p-2 border-primary mt-2">
                <div class="row">
                    <div class="col-12 col-sm-6 col-md-3">
                        <a href="#" style="color:#000 !important;">
                            <div class="info-box">
                                <span class="info-box-icon bg-info elevation-1"><i class="fab fa-product-hunt"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Total WhatsApp Send Message</span>
                                    <span class="info-box-number">
                                        {{ $total_whatsapp_send_sms }}
                                    </span>
                                </div>
                                <!-- /.info-box-content -->
                            </div>
                        </a>
                        <!-- /.info-box -->
                    </div>
                    <div class="col-12 col-sm-6 col-md-3">
                        <a href="#" style="color:#000 !important;">
                            <div class="info-box">
                                <span class="info-box-icon bg-info elevation-1"><i class="fab fa-product-hunt"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Total WhatsApp Unsend Message</span>
                                    <span class="info-box-number">
                                        {{ $total_whatsapp_unsend_sms }}
                                    </span>
                                </div>
                                <!-- /.info-box-content -->
                            </div>
                        </a>
                        <!-- /.info-box -->
                    </div>
                       <div class="col-12 col-sm-6 col-md-3">
                        <a href="#" style="color:#000 !important;">
                            <div class="info-box">
                                <span class="info-box-icon bg-info elevation-1"><i class="fab fa-product-hunt"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Todays WhatsApp Message Send</span>
                                    <span class="info-box-number">
                                        {{ $today_whatsapp_sms_send }} 
                                    </span>
                                </div>
                                <!-- /.info-box-content -->
                            </div>
                        </a>
                        <!-- /.info-box -->
                    </div>
                    <div class="col-12 col-sm-6 col-md-3">
                        <a href="#" style="color:#000 !important;">
                            <div class="info-box">
                                <span class="info-box-icon bg-info elevation-1"><i class="fab fa-product-hunt"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Yesterday WhatsApp Message Send</span>
                                    <span class="info-box-number">
                                        {{ $yesterday_whatsapp_sms_send }} 
                                    </span>
                                </div>
                                <!-- /.info-box-content -->
                            </div>
                        </a>
                        <!-- /.info-box -->
                    </div>
                    <div class="col-12 col-sm-6 col-md-3">
                        <a href="#" style="color:#000 !important;">
                            <div class="info-box">
                                <span class="info-box-icon bg-info elevation-1"><i class="fab fa-product-hunt"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Last Week WhatsApp Message Send</span>
                                    <span class="info-box-number">
                                        {{ $last_weak_whatsapp_sms_send }} 
                                    </span>
                                </div>
                                <!-- /.info-box-content -->
                            </div>
                        </a>
                        <!-- /.info-box -->
                    </div>
              
             
                </div>
            </div>
        </div><!--/. container-fluid -->
    </section>
@endsection
