@extends('back-end.layouts.master')

@section('title')
    MyAlice Config
@endsection

@section('content')
    <section class="content">
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <ol class="breadcrumb ">
                            <li class="breadcrumb-item"><a href="{{ url('dashboard') }}">Dashboard</a></li>
                            <li class="breadcrumb-item active">@yield('title')</li>
                        </ol>
                    </div><!-- /.col -->
                </div><!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
        <!-- /.content-header -->

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12 my-2">
                        <div class="row">
                            <div class="col-md-2">
                                <button type="button" data-toggle="modal" data-target="#addConfig"
                                    class="btn btn-success  rounded-pill"><i class="fas fa-plus"></i> Configure
                                </button>
                            </div>
                            {{-- @dd( $myalice->status) --}}
                            <div class="col-md-5">
                                <div class="form-group">
                                    @php
                                        $status = $myalice->status == 2 ? "" : "checked";
                                    @endphp
                                    <div class="custom-control custom-switch">
                                        <input type="checkbox" class="custom-control-input sms_status" value="{{ $myalice->status }}" id="status" {{$status}}>
                                        <label class="custom-control-label" for="status">Auto Send What's App Message</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header bg-gray text-bold">
                                MyAlice API Setting Table
                            </div>

                            <table class="table align-middle mb-0 bg-white table-bordered">
                                <thead class="bg-light">
                                    <tr>
                                        <th>MyAlice Api Url</th>
                                        <th>Api Key</th>
                                        <th>Channel ID</th>
                                        <th>Template ID</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @if ($myalice)
                                        <tr>
                                            <td>{{ $myalice->api_url }}</td>
                                            <td>{{ $myalice->api_key }}</td>
                                            <td>{{ $myalice->channel_id }}</td>
                                            <td>{{ $myalice->template_id }}</td>
                                            <td>
                                                <button type="button" data-toggle="modal" data-target="#addConfig"
                                                    class="btn btn-primary btn-sm rounded-pill btn-rounded text-light">
                                                    <i class="fas fa-pencil-alt"></i> Edit
                                                </button>
                                                <a href="{{ url('delete-sms-config/' . $myalice->id) }}" id="delete"
                                                    type="button"
                                                    class="btn btn-danger btn-sm rounded-pill btn-rounded text-light">
                                                    <i class="fas fa-trash"></i> Delete
                                                </a>
                                            </td>
                                        </tr>
                                    @else
                                        <tr>
                                            <td colspan="10" class="text-danger text-center">Data Not Found!</td>
                                        </tr>
                                    @endif
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <!-- Modal register -->
                <div class="modal fade" id="addConfig" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
                    aria-hidden="true">
                    <div class="modal-dialog modal-lg" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="exampleModalLabel">Config Form</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <form action="{{ url('whats-app-sms-config-store') }}" method="POST" enctype="multipart/form-data">
                                @csrf
                                <div class="modal-body">
                                    <div class="card-body">
                                        <div class="form-group row">
                                            <label class="col-md-3" for="api_url">Api Url</label>
                                            <input type="text" name="api_url" id="api_url" required
                                                class="form-control col-md-9" placeholder="Enter Api Url"
                                                value="{{ $myalice->api_url ?? old('api_url') }}">
                                            @error('api_url')
                                                <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>

                                        <div class="form-group row">
                                            <label class="col-md-3" for="api_key">Api Key</label>
                                            <input type="text" name="api_key" id="api_key" required
                                                class="form-control col-md-9" placeholder="Enter Api Key"
                                                value="{{ $myalice->api_key ?? old('api_key') }}">
                                            @error('api_key')
                                                <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>

                                        <div class="form-group row">
                                            <label class="col-md-3" for="channel_id">Channel ID</label>
                                            <input type="text" name="channel_id" id="channel_id" required
                                                class="form-control col-md-9" placeholder="Enter Channel ID"
                                                value="{{ $myalice->channel_id ?? old('channel_id') }}">
                                            @error('channel_id')
                                                <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>

                                        <div class="form-group row">
                                            <label class="col-md-3" for="template_id">Template ID</label>
                                            <input type="text" name="template_id" id="template_id" required
                                                class="form-control col-md-9" placeholder="Enter Template ID" value="{{ $myalice->template_id ?? old('template_id') }}">
                                            @error('template_id')
                                                <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>

                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary rounded-pill"
                                        data-dismiss="modal">Close</button>
                                    <div class="modal-footer">
                                        <button type="submit" class="btn btn-primary rounded-pill">Save</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        @push('js')
        <script>
            $(document).ready(function () {
                $(".sms_status").change(function (e) {
                    e.preventDefault();
                    var status = $(this).prop('checked') ? 1 : 2;
                    
                    $.ajax({
                        type: "GET", // Change the request type to POST
                        url: "{{ secure_url('update-whats-app-sms-status-ajax') }}",
                        data: {
                            status: status
                        },
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        success: function (response) {
                            // Handle success, if needed
                            console.log(response);
                        },
                        complete: function (done) {
                            if (done.status == 200) {
                                location.reload(true);
                            }
                        }
                    });
                });
            });
        </script>
        
        
            {{-- <script>
                $(document).ready(function () {
                    $(".sms_status").change(function(e) {
                        e.preventDefault();
                        var active_status = $(this).val();

                        $.ajax({
                            type: "GET",
                            url: "{{ url('update-sms-status-ajax') }}",
                            data: {
                                active_status: active_status
                            },
                            success: function(response) {

                            },
                            complete: function(done) {
                                if (done.status == 200) {
                                    location.reload(true);
                                }
                            }
                        });
                    });

                });
            </script> --}}
        @endpush
    </section>
@endsection
