@extends('back-end.layouts.master')

@section('title')
    Whats App Message Inbox
@endsection

@section('content')
    <section class="content">
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <ol class="breadcrumb ">
                            <li class="breadcrumb-item"><a href="{{ url('dashboard') }}">Dashboard</a></li>
                            <li class="breadcrumb-item active">@yield('title')</li>
                        </ol>
                    </div><!-- /.col -->
                </div><!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
        <!-- /.content-header -->

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row justify-content-between">
                    <div class="col-12">
                        <form action="{{ url('whats-app-sms-inbox') }}" method="GET">
                            <div class="form-row {{-- align-items-left  float-right --}}  mb-3">
                                <div class="col-md-2">
                                    <label for="sms_id">ID</label>
                                    <input type="search" class="form-control" name="sms_id" placeholder="Enter Sms ID..."
                                        value="{{ isset($request) ? $request->sms_id : '' }}">
                                </div>
                                <div class="col-md-2">
                                    <label for="platform_id">Platform ID</label>
                                    <input type="search" class="form-control" name="platform_id"
                                        placeholder="Enter Platform ID..."
                                        value="{{ isset($request) ? $request->platform_id : '' }}">
                                </div>
                                <div class="col-md-2">
                                    <label for="recipient_phone_number">Recipient Phone Number</label>
                                    <input type="search" class="form-control" name="recipient_phone_number"
                                        placeholder="Enter Recipient Number..."
                                        value="{{ isset($request) ? $request->recipient_phone_number : '' }}">
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label for="first_date">Date Time</label>
                                        <input type="date" class="form-control" name="date_time"
                                            placeholder="Enter Date Time..."
                                            value="{{ isset($request) ? $request->date_time : '' }}">
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <label for="whats_app_sms_send_status">Status</label>
                                    <select name="whats_app_sms_send_status" class="form-control select2"
                                        data-pleaceholder="Select Option" id="whats_app_sms_send_status">
                                        <option selected value="2">Select Option</option>
                                        <option value="1"
                                            {{ isset($request) && $request->whats_app_sms_send_status == 1 ? 'selected' : '' }}>Send
                                        </option>
                                        <option value="0"
                                            {{ isset($request) && $request->whats_app_sms_send_status === '0' ? 'selected' : '' }}>Not
                                            Send
                                        </option>
                                    </select>
                                </div>
                                <div class="col-md-12 mt-2">
                                    <button class="btn btn-success" id="submit"><i class="fas fa-search"></i>
                                        Search</button>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header bg-gray text-bold">
                                Contact Table
                            </div>
                            <table class="table align-middle mb-0 bg-white table-bordered">
                                <thead class="bg-light">
                                    <tr>
                                        <th style="width: 5%">ID</th>
                                        <th style="width: 15%">Date Time</th>
                                        <th style="width: 15%">System Send Time</th>
                                        <th style="width: 10%">Platform ID</th>
                                        <th style="width: 10%">Recipient Phone Number</th>
                                        <th style="width: 60%">Message Content</th>
                                        <th style="width: 10%">Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php
                                        $serial = ($contacts->currentpage() - 1) * $contacts->perpage() + 1;
                                    @endphp

                                    @forelse ($contacts as $contact)
                                        @if ($contact->whats_app_sms_send_status == 1)
                                        <tr>
                                            <td>{{ $contact->sms_id == 0 ? 'Manual' : $contact->sms_id }}</td>
                                            <td>{{ \Carbon\Carbon::parse($contact->date_time)->format('Y-m-d h:i a') }}</td>
                                            <td>{{ $contact->date_time_whats_app_sms_send != null ? \Carbon\Carbon::parse($contact->date_time_whats_app_sms_send)->format('Y-m-d h:i a') : '' }}
                                            </td>

                                            <td>{{ $contact->platform_id }}</td>
                                            <td>{{ $contact->recipient_phone_number }}</td>
                                            <td>{{ $contact->whats_app_sms_content }}</td>
                                            <td><span
                                                    class="badge badge-{{ $contact->whats_app_sms_send_status == 1 ? 'success' : 'danger' }}">{{ $contact->whats_app_sms_send_status == 1 ? 'Send' : 'Not Send' }}</span>
                                            </td>
                                        </tr>
                                            
                                        @endif
                                    @empty
                                        <tr>
                                            <td colspan="10" class="text-danger text-center">Data Not Found!</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>

                        {{ $contacts->links() }}
                    </div>
                </div>
            </div>
        </section>
    </section>
@endsection
