@extends('back-end.layouts.master')

@section('title')
Basic Setup
@endsection

@section('content')
    <section class="content">
        <div class="container-fluid">
            <!-- form start -->
            <form class="form-horizontal" method="POST" action="{{ url('basic-setup-store') }}" accept-charset="utf-8"
                enctype="multipart/form-data">
                @csrf
                <div class="row">
                    <div class="col-md-9">

                        <div class="card card-info">
                            <div class="card-header">
                                <h3 class="card-title">Basic Setup</h3>
                            </div>
                            <!-- /.card-header -->
                            <div class="card-body">
                                <div class="form-group row">
                                    <label class="col-sm-3 control-label">App Name</label>
                                    <div class="col-sm-9">
                                        <input type="text" class="form-control @error('name') is-invalid @enderror"
                                            name="name" required placeholder="Enter Name" value="{{ $basic->name }}">
                                        @error('name')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label class="col-sm-3 control-label">Total Message Send At A Time</label>
                                    <div class="col-sm-9">
                                        <input type="number" class="form-control @error('total_sms_send_at_a_time') is-invalid @enderror"
                                            name="total_sms_send_at_a_time" required placeholder="Enter number" value="{{ $basic->total_sms_send_at_a_time }}">
                                        @error('total_sms_send_at_a_time')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label class="col-sm-3 control-label">Send SMS List Row Show Per Page</label>
                                    <div class="col-sm-9">
                                        <input type="number" class="form-control @error('pagination_limit') is-invalid @enderror"
                                            name="pagination_limit" required placeholder="Enter number" value="{{ $basic->pagination_limit }}">
                                        @error('pagination_limit')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>

                            </div>
                            <!-- /.card-body -->
                            <div class="card-footer">
                                <button type="submit" class="btn btn-info">Save</button>
                            </div>
                        </div>

                    </div>

                </div>
            </form>
        </div><!--/. container-fluid -->

    </section>
@endsection

@section('script')
    @foreach (['success', 'error'] as $type)
        @if (Session::has('msg-' . $type))
            toastr.{{ $type }}('{{ Session::get('msg-' . $type) }}');
        @endif
    @endforeach
@endsection
