@extends('back-end.layouts.master')

@section('title')
    Sms Config
@endsection

@section('content')
    <section class="content">
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <ol class="breadcrumb ">
                            <li class="breadcrumb-item"><a href="{{ url('dashboard') }}">Dashboard</a></li>
                            <li class="breadcrumb-item active">@yield('title')</li>
                        </ol>
                    </div><!-- /.col -->
                </div><!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
        <!-- /.content-header -->

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12 my-2">
                        <div class="row">
                            <div class="col-md-2">
                                <button type="button" data-toggle="modal" data-target="#addConfig"
                                    class="btn btn-success  rounded-pill"><i class="fas fa-plus"></i> Add New Api
                                </button>
                            </div>
                            {{-- @dd( $sms_config->status) --}}
                            <div class="col-md-2">

                                {{-- <div class="form-group">
                                    <div class="custom-control custom-switch">
                                        <input type="checkbox" class="custom-control-input sms_status"
                                            value="{{ $sms_config->status }}" id="status{{ $sms_config->status }}"
                                            {{ $sms_config->status == 1 ? 'checked' : '' }}>
                                        <label class="custom-control-label"
                                            for="status{{ $sms_config->status }}">Auto Send Sms</label>
                                    </div>
                                </div> --}}
                            </div>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header bg-gray text-bold">
                                Sms Config Table
                            </div>

                            <table class="table align-middle mb-0 bg-white table-bordered">
                                <thead class="bg-light">
                                    <tr>
                                        <th>Name</th>
                                        <th>Api Url</th>
                                        <th>Api Key</th>
                                        <th>Type</th>
                                        <th>Auto Send Sms</th>
                                        <th>Default Send Sms</th>
                                        <th>Sender ID</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($sms_configs as $sms_config)
                                        @if ($sms_config)
                                            <tr>
                                                <td>{{ $sms_config->name }}</td>
                                                <td>{{ $sms_config->api_url }}</td>
                                                <td>{{ $sms_config->api_key }}</td>
                                                <td>{{ $sms_config->type }}</td>
                                                <td>
                                                    <div class="form-group">
                                                        @php
                                                            $status = $sms_config->status == 2 ? '' : 'checked';
                                                        @endphp
                                                        <div class="custom-control custom-switch">
                                                            <input type="checkbox"
                                                                class="custom-control-input sms_status{{ $sms_config->id }}"
                                                                value="{{ $sms_config->status }}"
                                                                data-id="{{ $sms_config->id }}"
                                                                id="status{{ $sms_config->id }}" {{ $status }}>
                                                            <label class="custom-control-label"
                                                                for="status{{ $sms_config->id }}">{{ $sms_config->status == 2 ? 'Inactive' : 'Active' }}</label>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="form-group">
                                                        @php
                                                            $default_send_status = $sms_config->default_send_status == 2 ? '' : 'checked';
                                                        @endphp
                                                        <div class="custom-control custom-switch">
                                                            <input type="checkbox"
                                                                class="custom-control-input default_send_status{{ $sms_config->id }}"
                                                                value="{{ $sms_config->default_send_status }}"
                                                                data-id="{{ $sms_config->id }}"
                                                                id="default_send_status{{ $sms_config->id }}" {{ $default_send_status }}>
                                                            <label class="custom-control-label"
                                                                for="default_send_status{{ $sms_config->id }}">{{ $sms_config->default_send_status == 2 ? 'Inactive' : 'Active'}}</label>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>{{ $sms_config->sender_id }}</td>
                                                <td>
                                                    <button type="button" data-toggle="modal"
                                                        data-target="#addConfig{{ $sms_config->id }}"
                                                        class="btn btn-primary btn-sm rounded-pill btn-rounded text-light">
                                                        <i class="fas fa-pencil-alt"></i> Edit
                                                    </button>
                                                    <a href="{{ url('delete-sms-config/' . $sms_config->id) }}"
                                                        id="delete" type="button"
                                                        class="btn btn-danger btn-sm rounded-pill btn-rounded text-light">
                                                        <i class="fas fa-trash"></i> Delete
                                                    </a>
                                                </td>
                                            </tr>
                                        @else
                                            <tr>
                                                <td colspan="10" class="text-danger text-center">Data Not Found!</td>
                                            </tr>
                                        @endif

                                        <!-- Modal register -->
                                        <div class="modal fade" id="addConfig{{ $sms_config->id }}" tabindex="-1"
                                            role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                            <div class="modal-dialog modal-lg" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="exampleModalLabel">Sms Config Edit Form
                                                        </h5>
                                                        <button type="button" class="close" data-dismiss="modal"
                                                            aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <form action="{{ url('sms-config-update') }}" method="POST"
                                                        enctype="multipart/form-data">
                                                        @csrf
                                                        <div class="modal-body">
                                                            <div class="card-body">
                                                                <input type="hidden" name="id"
                                                                    value="{{ $sms_config->id }}">
                                                                <div class="form-group row">
                                                                    <label class="col-md-3" for="name">Api Name</label>
                                                                    <input type="text" name="name" id="name"
                                                                        required class="form-control col-md-9"
                                                                        placeholder="Enter Api Name"
                                                                        value="{{ $sms_config->name ?? old('name') }}">
                                                                    @error('name')
                                                                        <span class="text-danger">{{ $message }}</span>
                                                                    @enderror
                                                                </div>

                                                                <div class="form-group row">
                                                                    <label class="col-md-3" for="api_url">Api Url</label>
                                                                    <input type="text" name="api_url" id="api_url"
                                                                        required class="form-control col-md-9"
                                                                        placeholder="Enter Api Url"
                                                                        value="{{ $sms_config->api_url ?? old('api_url') }}">
                                                                    @error('api_url')
                                                                        <span class="text-danger">{{ $message }}</span>
                                                                    @enderror
                                                                </div>

                                                                <div class="form-group row">
                                                                    <label class="col-md-3" for="api_key">Api Key</label>
                                                                    <input type="text" name="api_key" id="api_key"
                                                                        required class="form-control col-md-9"
                                                                        placeholder="Enter Api Key"
                                                                        value="{{ $sms_config->api_key ?? old('api_key') }}">
                                                                    @error('api_key')
                                                                        <span class="text-danger">{{ $message }}</span>
                                                                    @enderror
                                                                </div>

                                                                <div class="form-group row">
                                                                    <label class="col-md-3" for="sender_id">Sender
                                                                        ID</label>
                                                                    <input type="text" name="sender_id" id="sender_id"
                                                                        required class="form-control col-md-9"
                                                                        placeholder="Enter Api Key"
                                                                        value="{{ $sms_config->sender_id ?? old('sender_id') }}">
                                                                    @error('sender_id')
                                                                        <span class="text-danger">{{ $message }}</span>
                                                                    @enderror
                                                                </div>

                                                                <div class="form-group row">
                                                                    <label class="col-md-3" for="type">Type</label>
                                                                    <input type="text" name="type" id="type"
                                                                        required class="form-control col-md-9"
                                                                        placeholder="Enter Api Key" value="text">
                                                                    @error('type')
                                                                        <span class="text-danger">{{ $message }}</span>
                                                                    @enderror
                                                                </div>

                                                            </div>
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary rounded-pill"
                                                                data-dismiss="modal">Close</button>
                                                            <div class="modal-footer">
                                                                <button type="submit"
                                                                    class="btn btn-primary rounded-pill">Update</button>
                                                            </div>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>

                                        @push('js')
                                            <script>
                                                $(document).ready(function() {
                                                    $(".sms_status{{ $sms_config->id }}").change(function(e) {
                                                        e.preventDefault();
                                                        var status = $(this).prop('checked') ? 1 : 2;
                                                        var id = $(this).data('id');
                                                        $.ajax({
                                                            type: "GET", // Change the request type to POST
                                                            url: "{{ secure_url('update-sms-status-ajax') }}",
                                                            data: {
                                                                status: status,
                                                                id: id
                                                            },
                                                            headers: {
                                                                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                                                            },
                                                            success: function(response) {
                                                                // Handle success, if needed
                                                                console.log(response);
                                                            },
                                                            complete: function(done) {
                                                                if (done.status == 200) {
                                                                    location.reload(true);
                                                                }
                                                            }
                                                        });
                                                    });
                                                    
                                                    $(".default_send_status{{ $sms_config->id }}").change(function(e) {
                                                        e.preventDefault();
                                                        var status = $(this).prop('checked') ? 1 : 2;
                                                        var id = $(this).data('id');
                                                        $.ajax({
                                                            type: "GET", // Change the request type to POST
                                                            url: "{{ secure_url('update-sms-default-status-ajax') }}",
                                                            data: {
                                                                status: status,
                                                                id: id
                                                            },
                                                            headers: {
                                                                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                                                            },
                                                            success: function(response) {
                                                                // Handle success, if needed
                                                                console.log(response);
                                                            },
                                                            complete: function(done) {
                                                                if (done.status == 200) {
                                                                    location.reload(true);
                                                                }
                                                            }
                                                        });
                                                    });
                                                });
                                            </script>


                                            {{-- <script>
                                            $(document).ready(function () {
                                                $(".sms_status").change(function(e) {
                                                    e.preventDefault();
                                                    var active_status = $(this).val();
                            
                                                    $.ajax({
                                                        type: "GET",
                                                        secure_url: "{{ url('update-sms-status-ajax') }}",
                                                        data: {
                                                            active_status: active_status
                                                        },
                                                        success: function(response) {
                            
                                                        },
                                                        complete: function(done) {
                                                            if (done.status == 200) {
                                                                location.reload(true);
                                                            }
                                                        }
                                                    });
                                                });
                            
                                            });
                                        </script> --}}
                                        @endpush
                                    @endforeach

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <!-- Modal register -->
                <div class="modal fade" id="addConfig" tabindex="-1" role="dialog"
                    aria-labelledby="exampleModalLabel" aria-hidden="true">
                    <div class="modal-dialog modal-lg" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="exampleModalLabel">Sms Config Add Form</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <form action="{{ url('sms-config-store') }}" method="POST" enctype="multipart/form-data">
                                @csrf
                                <div class="modal-body">
                                    <div class="card-body">
                                        <div class="form-group row">
                                            <label class="col-md-3" for="name">Api Name</label>
                                            <input type="text" name="name" id="name" required
                                                class="form-control col-md-9" placeholder="Enter Api Name"
                                                value="{{ old('name') }}">
                                            @error('name')
                                                <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>

                                        <div class="form-group row">
                                            <label class="col-md-3" for="api_url">Api Url</label>
                                            <input type="text" name="api_url" id="api_url" required
                                                class="form-control col-md-9" placeholder="Enter Api Url"
                                                value="{{ old('api_url') }}">
                                            @error('api_url')
                                                <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>

                                        <div class="form-group row">
                                            <label class="col-md-3" for="api_key">Api Key</label>
                                            <input type="text" name="api_key" id="api_key" required
                                                class="form-control col-md-9" placeholder="Enter Api Key"
                                                value="{{ old('api_key') }}">
                                            @error('api_key')
                                                <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>

                                        <div class="form-group row">
                                            <label class="col-md-3" for="sender_id">Sender ID</label>
                                            <input type="text" name="sender_id" id="sender_id" required
                                                class="form-control col-md-9" placeholder="Enter Sender ID"
                                                value="{{ old('sender_id') }}">
                                            @error('sender_id')
                                                <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>

                                        <div class="form-group row">
                                            <label class="col-md-3" for="type">Type</label>
                                            <input type="text" name="type" id="type" required
                                                class="form-control col-md-9" placeholder="Enter Api Key" value="text">
                                            @error('type')
                                                <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>

                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary rounded-pill"
                                        data-dismiss="modal">Close</button>
                                    <div class="modal-footer">
                                        <button type="submit" class="btn btn-primary rounded-pill">Save</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                
            </div>
        </section>

    </section>
@endsection
