<div class="col-12">

    @if ($request->start_date && $request->end_date)
        <p>Search From
            <strong>{{ \Carbon\Carbon::parse($request->start_date)->format('Y-m-d') }}</strong> To
            <strong>{{ \Carbon\Carbon::parse($request->end_date)->format('Y-m-d') }}</strong>
        </p>
    @endif
    <div class="card">
        <div class="card-header bg-gray text-bold">
            Contact Table
        </div>
        <table class="table align-middle mb-0 bg-white table-bordered">
            <thead class="bg-light">
                <tr>
                    <th style="width: 5%">Serial</th>
                    <th style="width: 5%">ID</th>
                    <th style="width: 11%">Date Time</th>
                    <th style="width: 11%">System Send Time</th>
                    <th style="width: 8%">Sender ID</th>
                    <th style="width: 10%">Recipient Phone Number</th>
                    <th style="width: 50%">Sms Content</th>
                    <th style="width: 15%">User</th>
                    <th style="width: 10%">Status</th>
                </tr>
            </thead>
            <tbody>
                @php
                    $serial = ($contacts->currentpage() - 1) * $contacts->perpage() + 1;
                @endphp

                @forelse ($contacts as $contact)
                    @if ($contact->active_status == 1)
                        <tr>
                            <td>{{ $serial++ }}</td>
                            <td>{{ $contact->sms_id == 0 ? 'Manual' : $contact->sms_id }}</td>
                            <td>{{ \Carbon\Carbon::parse($contact->date_time)->format('Y-m-d h:i a') }}
                            </td>
                            <td>{{ $contact->system_send_time != null ? \Carbon\Carbon::parse($contact->system_send_time)->format('Y-m-d h:i a') : '' }}
                            </td>

                            <td>{{ $contact->sender_id }}</td>
                            <td>{{ $contact->recipient_phone_number }}</td>
                            <td>{{ $contact->sms_content }}</td>
                            <td>{{ $contact->user == null ? 'System' : $contact->user->name }}</td>
                            <td><span
                                    class="badge badge-{{ $contact->active_status == 1 ? 'success' : 'danger' }}">{{ $contact->active_status == 1 ? 'Send' : 'Not Send' }}</span>
                            </td>
                        </tr>
                    @endif
                @empty
                    <tr>
                        <td colspan="10" class="text-danger text-center">Data Not Found!</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    {{ $contacts->appends($request->query())->links() }}
</div>
