@extends('back-end.layouts.master')

@section('title')
    Send Sms
@endsection

@section('content')
    <section class="content">
        @push('css')
            <style>
                .custom-file-upload {
                    border: 1px solid #ccc;
                    display: inline-block;
                    padding: 6px 12px;
                    cursor: pointer;
                    position: relative;
                }
            </style>
        @endpush
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <ol class="breadcrumb ">
                            <li class="breadcrumb-item"><a href="{{ url('dashboard') }}">Dashboard</a></li>
                            <li class="breadcrumb-item active">@yield('title')</li>
                        </ol>
                    </div><!-- /.col -->
                </div><!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
        <!-- /.content-header -->

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header bg-gray text-bold">
                                Sms Send Form
                            </div>
                            {{-- <form id="formData" action="{{ route('send-manual-sms') }}" method="POST" enctype="multipart/form-data"> --}}
                            {{--  @csrf --}}
                            <div class="modal-body">
                                <div class="card-body">
                                    <div class="form-group">
                                        <div class="row">
                                            <label class="col-md-3" for="numbers">Enter Numbers</label>
                                            <div class="col-md-9">
                                                <div class="row">
                                                    <div class="form-group clearfix">
                                                        <div class="icheck-primary d-inline">
                                                            <input type="radio" id="default_status" name="template_status_select"
                                                                value="1" checked="">
                                                            <label for="default_status">
                                                                Default Template
                                                            </label>
                                                        </div>
                                                        <div class="icheck-primary d-inline">
                                                            <input type="radio" id="costom_template"
                                                                name="template_status_select" value="2">
                                                            <label for="costom_template">Custom Template
                                                            </label>
                                                        </div>
                                                        <div class="icheck-primary d-inline">
                                                            <input type="radio" id="costom_excel_sms"
                                                                name="template_status_select" value="3">
                                                            <label for="costom_excel_sms">Custom Excel SMS
                                                            </label>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-12 d-none" id="import_excel_file_div">
                                                        <div class="form-group col-md-6 row">
                                                            <label for="file-upload" name='upload_cont_img'
                                                                class="custom-file-upload">
                                                                <i class="fa fa-cloud-upload"></i> Import Excel File
                                                            </label>
                                                            <input id="file-upload" name='upload_cont_img' type="file"
                                                                style="display: none"
                                                                accept=".xlsx, .xls, application/vnd.openxmlformats-officedocument.spreadsheetml.sheet, application/vnd.ms-excel">
                                                            <div class="file-name-display"></div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div id="basic_sms">
                                            <form id="formData" action="{{ route('send-manual-sms') }}" method="POST"
                                                enctype="multipart/form-data">
                                                @csrf
                                                @include('back-end.sms.include.basic_sms')
                                            </form>
                                        </div>
                                        <div id="advance_sms" class="d-none">
                                            @include('back-end.sms.include.advance_sms')
                                        </div>
                                    </div>
                                </div>
                            </div>
                            {{-- </form> --}}
                        </div>
                    </div>
                </div>
            </div>

        </section>
        @push('js')
            <script>
                $(document).ready(function() {
                    //input field 
                    const fileUpload = document.getElementById('file-upload');
                    const fileName = document.getElementsByClassName('file-name-display');

                    fileUpload.addEventListener('change', (event) => {

                        let newFilePath = event.target.value;
                        fileName[0].innerHTML = newFilePath;

                    });

                    //mood
                    var status = $('#default_status').val();
                    if (status == 1) {
                        $('#custom_message').addClass('d-none');
                        $("#basic_sms").removeClass("d-none");
                        $("#advance_sms").addClass("d-none");
                        $("#form_templte_status").val(status);
                    }
                    $("#costom_template").change(function(e) {
                        e.preventDefault();
                        $('#custom_message').removeClass('d-none');
                        $("#message").attr('required', true);
                        $("#import_excel_file_div").addClass("d-none");
                        $("#basic_sms").removeClass("d-none");
                        $("#advance_sms").addClass("d-none");
                        $("#form_templte_status").val($(this).val());
                    });

                    $("#default_status").change(function(e) {
                        e.preventDefault();
                        $('#custom_message').addClass('d-none');
                        $("#message").removeAttr('required');
                        $("#import_excel_file_div").addClass("d-none");
                        $("#basic_sms").removeClass("d-none");
                        $("#advance_sms").addClass("d-none");
                        $("#form_templte_status").val($(this).val());
                    });

                    $("#costom_excel_sms").change(function(e) {
                        e.preventDefault();
                        $('#custom_message').removeClass('d-none');
                        $("#message").attr('required', true);
                        $("#import_excel_file_div").removeClass("d-none");
                        $("#basic_sms").addClass("d-none");
                        $("#advance_sms").removeClass("d-none");
                        $("#form_templte_status").val("");
                    });


                    $('#preview_button').click(function(e) {
                        e.preventDefault(); // Prevent the default form submission

                        // Extract data from form fields
                        var firstBoxData = $('#first_box').val();
                        var secondBoxData = $('#second_box').val();

                        // Prepare form data
                        var formData = new FormData();
                        var fileInput = $('#file-upload')[0].files[0];
                        formData.append('excel_upload', fileInput);
                        formData.append('first_box', firstBoxData);
                        formData.append('second_box', secondBoxData);

                        // Make AJAX request
                        $.ajax({
                            type: "POST",
                            url: "{{ secure_url('preview-excel-sms-first-row-ajax') }}",
                            data: formData,
                            processData: false,
                            contentType: false,
                            headers: {
                                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                            },
                            success: function(response) {

                                $("#preview_first_row_excel").html(response.data);
                                if (response.success) {
                                    toastr.success(response.success);
                                } else if (response.error) {
                                    toastr.error(response.error);
                                }
                            },
                            error: function(xhr, status, error) {
                                console.log(error);
                                if (xhr.responseJSON && xhr.responseJSON.error) {
                                    toastr.error(xhr.responseJSON.error);
                                } else if (xhr.responseJSON && xhr.responseJSON.errors) {
                                    // If there are multiple validation errors, loop through them
                                    $.each(xhr.responseJSON.errors, function(field_name, error) {
                                        toastr.error(error[
                                            0
                                            ]); // Displaying the first error message for each field
                                    });
                                } else {
                                    toastr.error('An error occurred while processing your request.');
                                }
                            }
                        });
                    });
                });
            </script>
        @endpush
    </section>
@endsection
