<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>@yield('title', 'Call Report')</title>

    <!-- Font Awesome Icons -->
    <link rel="stylesheet" href="{{ asset('/') }}back-end/plugins/fontawesome-free/css/all.min.css">
    <!-- overlayScrollbars -->
    <link rel="stylesheet" href="{{ asset('/') }}back-end/plugins/overlayScrollbars/css/OverlayScrollbars.min.css">
    <!-- Theme style -->
    <link rel="stylesheet" href="{{ asset('/') }}back-end/dist/css/adminlte.min.css">
    <!-- Toastr -->
    <link rel="stylesheet" href="{{ asset('/') }}back-end/plugins/toastr/toastr.min.css">
    <!-- summernote -->
    <link rel="stylesheet" href="{{ asset('/') }}back-end/plugins/summernote/summernote-bs4.css">
    <link rel="stylesheet" href="{{ asset('/') }}back-end/plugins/sweetalert2/sweetalert2.min.css">
    <!-- Select2 -->
    <link rel="stylesheet" href="{{ asset('back-end/plugins/select2/css/select2.min.css') }}">
    <link rel="stylesheet" href="{{ asset('/') }}back-end/plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css"><!-- Bootstrap4 Duallistbox -->
    <link rel="stylesheet" href="../../plugins/bootstrap4-duallistbox/bootstrap-duallistbox.min.css">
    <link rel="stylesheet" href="{{ asset('css/preloader.css') }}">
    <!-- Google Font: Source Sans Pro -->
    <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
    <style>
        .nav-treeview>.nav-item>.nav-link.active {
            background-color: #7e7ee4 !important;
            color: #212529;
        }
    </style>
    @stack('css')
    @livewireStyles
</head>

<body class="hold-transition sidebar-mini layout-fixed layout-navbar-fixed layout-footer-fixed">
    <div id="preloader">
        <div class="load-me">
            <div class="la-ball-running-dots la-2x ball-color">
                <div></div>
                <div></div>
                <div></div>
                <div></div>
                <div></div>
            </div>
        </div>
    </div>
    <div class="wrapper">
        <style>
            /* Button Styles */
        button {
            border: none;
            cursor: pointer;
            padding: 8px 12px;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            transition: background-color 0.3s ease;
        }
        
        button .fa-play-circle {
            margin-right: 5px;
        }
        
 
        
        .playBtn:hover {
            background-color: #0056b3;
        }
        
     
        
        .download-link .fa-cloud-download-alt {
            margin-right: 5px;
        }
        
        .download-link {
            color: #007bff;
            text-decoration: none;
        }
            .download-link-gray {
                color: #808488;
                text-decoration: none;
            }
        
        .download-link:hover {
            color: #0056b3;
        }
        
        </style>
            <section class="content">
                <!-- Main content -->
                <section class="content">
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-header bg-gray text-bold">
                                        Call To {{ $number }}
                                    </div>
                                    <table class="table align-middle mb-0 bg-white table-bordered">
                                        <thead class="thead-light">
                                            <tr>
                                                <th scope="col">Time</th>
                                                <th scope="col">Call From</th>
                                                <th scope="col">Call Duration</th>
                                                <th scope="col">Ring Duration</th>
                                                <th scope="col">Talk Duration</th>
                                                <th scope="col">Communication Type</th>
                                                <th scope="col">Status</th>
                                                <th scope="col">Recording File</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @if($yesterData != null)
                                            @foreach ($yesterData as $data)
                                                <tr>
                                                    <th scope="row">{{ $data['time'] }}</th>
                                                    <td>{{ $data['call_from'] }}</td>
                                                    @if (isset($data['record_file']))
                                                        <td>{{ isset($data['duration']) ? timeFormat($data['duration']) : '' }}</td>
                                                        <td>{{ isset($data['ring_duration']) ? timeFormat($data['ring_duration']) : '' }}
                                                        </td>
                                                        <td>{{ isset($data['talk_duration']) ? timeFormat($data['talk_duration']) : '' }}
                                                        </td>
                                                    @else
                                                        <td>00:00:00</td>
                                                        <td>00:00:00</td>
                                                        <td>00:00:00</td>
                                                    @endif
                                                    <td>{{ $data['call_type'] }}</td>
                                                    <td>{{ $data['disposition'] }}</td>
                                                    {{-- <td>{{ isset($data['record_file']) ? $data['record_file'] : '' }}</td> --}}
                                                       @if (isset($data['record_file']))
                                                 <td class="d-flex">
                                                <button class="playBtn btn btn-light audioBtn" data-id="{{ $data['id'] }}"
                                                        data-number="{{ $number }}" data-toggle="modal"
                                                        data-target="#playAudio">
                                                            <i class="far fa-play-circle text-primary"></i>
                                                        </button>
                                                <a target="_blank" style="margin-top: 5px;"
                                                    href="{{ url('download-audio/' . $data['id'] . '/' . $number) }}"
                                                    class="download-link d-inline-block">
                                                    <i class="fas fa-cloud-download-alt"></i>
                                                </a>
                                            </td>

                                                @else
                                                    <td>
                                                        <button disabled class="playBtn btn btn-light">
                                                            <i class="far fa-play-circle"></i>
                                                        </button>
                                                        <a href="#" class="download-link-gray"><i disabled
                                                                class="fas fa-cloud-download-alt"></i> </a>
                                                    </td>
                                                @endif

                                                
        
                                                </tr>
                                            @endforeach
                                            @endif
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
        
                    <!-- Modal -->
                    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
                        aria-hidden="true">
                        <div class="modal-dialog modal-xl">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">×</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <div class="col-12">
                                        <form>
                                            <div class="form-row {{-- align-items-left  float-right --}}  mb-3">
                                                <div class="col-md-2">
                                                    <label for="sms_id">ID</label>
                                                    <input type="search" class="form-control" name="sms_id" id="sms_id_value"
                                                        placeholder="Enter Sms ID..." value="">
                                                    <input type="hidden" name="user_id" id="user_id_value" value="">
                                                </div>
                                                <input type="hidden" name="start_date" id="start_date_velue" value="">
                                                <input type="hidden" name="end_date" id="end_date_value" value="">
                                                <div class="col-md-3">
                                                    <label for="sender_id">Sender ID</label>
                                                    <input type="search" class="form-control" name="sender_id"
                                                        placeholder="Enter Sender ID..." id="sender_id_value" value="">
                                                </div>
                                                <div class="col-md-4">
                                                    <label for="recipient_phone_number">Recipient Phone Number</label>
                                                    <input type="search" class="form-control" name="recipient_phone_number"
                                                        placeholder="Enter Recipient Number..." id="recipient_phone_number_value"
                                                        value="">
                                                </div>
        
                                                <div class="col-md-12 mt-2">
                                                    <button class="btn btn-success" type="button" id="searchMe"><i
                                                            class="fas fa-search"></i>
                                                        Search</button>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
        
                                    <div id="showListOfData"></div>
                                </div>
                                <div class="modal-footer justify-content-between">
                                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                </div>
                            </div>
        
                        </div>
                    </div>
        
                    <!-- Modal -->
                    <div class="modal fade" id="playAudio" tabindex="-1" role="dialog"
                        aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalLongTitle">Recording</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <p id="loading_p">Loading...</p>
                                </div>
                                <div class="modal-body" id="audioTag">
        
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                </div>
                            </div>
                        </div>
                    </div>
                    @push('js')
                        <script>
                            $(document).ready(function() {
                                $(".audioBtn").click(function() {
                                    $("#audioTag").html("");
                                    $("#loading_p").removeClass('d-none');
        
                                    var id = $(this).attr("data-id")
                                    var number = $(this).attr("data-number")
                                    $.ajax({
                                        type: "GET",
                                        url: "{{ secure_url('voice-play-audio') }}",
                                        data: {
                                            id: id,
                                            number:number
                                        },
                                        datatype: "json",
                                        success: function(response) {
                                            $("#loading_p").addClass('d-none');
                                            $("#audioTag").html(response);
                                        }
                                    });
                                });
        
                                $('#playAudio').on('hidden.bs.modal', function(e) {
                                    // Pause the audio when the modal is closed
                                    var audio = document.getElementById('audioPlayer');
                                    audio.pause();
                                });
                            });
                        </script>
                    @endpush
                </section>
            </section>
    </div>
    <!-- ./wrapper -->

    @livewireScripts
    <!-- REQUIRED SCRIPTS -->
    <!-- jQuery -->
    <script src="{{ asset('/') }}back-end/plugins/jquery/jquery.min.js"></script>
    <!-- Bootstrap --> <!-- moment -->
    <script src="{{ asset('back-end/plugins/moment/moment.min.js') }}"></script>
    <script src="{{ asset('/') }}back-end/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
    <!-- overlayScrollbars -->
    <script src="{{ asset('/') }}back-end/plugins/overlayScrollbars/js/jquery.overlayScrollbars.min.js"></script>
    <!-- AdminLTE App -->
    <script src="{{ asset('/') }}back-end/dist/js/adminlte.js"></script>
    <!-- Toastr -->
    <script src="{{ asset('/') }}back-end/plugins/toastr/toastr.min.js"></script>
    <!-- Summernote -->
    <script src="{{ asset('/') }}back-end/plugins/summernote/summernote-bs4.min.js"></script>
    {{-- date time picker --}}
    <script src="{{ asset('back-end/plugins/datetimepicker/js/bootstrap-material-datetimepicker.js') }}"></script>

    <script src="{{ asset('/') }}back-end/plugins/jquery-ui/jquery-ui.min.js"></script>
    <script src="{{ asset('/') }}back-end/plugins/sweetalert2/sweetalert2.all.js"></script>
    <!-- Select2 -->
    <script src="{{ asset('back-end/plugins/select2/js/select2.full.min.js') }}"></script>
    <script>
        $(document).on("click", "#delete", function(e) {
            e.preventDefault();
            var link = $(this).attr("href");
            const swalWithBootstrapButtons = Swal.mixin({
                customClass: {
                    confirmButton: 'btn btn-success',
                    cancelButton: 'btn btn-danger'
                },
                buttonsStyling: false
            })

            swalWithBootstrapButtons.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes, delete it!',
                cancelButtonText: 'No, cancel!',
                reverseButtons: true
            }).then((result) => {
                if (result.isConfirmed) {

                    window.location.href = link;
                    swalWithBootstrapButtons.fire(
                        'Deleted!',
                        'Your file has been deleted.',
                        'success'
                    )
                } else if (
                    /* Read more about handling dismissals below */
                    result.dismiss === Swal.DismissReason.cancel
                ) {
                    swalWithBootstrapButtons.fire(
                        'Cancelled',
                        'Your imaginary file is safe :)',
                        'error'
                    )
                }
            })

        });
    </script>
    <script>
        function pleasePreview(input, previewId) {
            var selectorIdAndClass = $('#' + previewId);

            if (input.files && input.files[0]) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    selectorIdAndClass.removeClass('d-none');
                    selectorIdAndClass.attr('src', e.target.result);
                };
                reader.readAsDataURL(input.files[0]);
            } else {
                alert('Select a file to see the preview');
                selectorIdAndClass.attr('src', '');
            }
        }
    </script>
    {{-- preloader  --}}
    <script>
        window.onload = function() {
            window.addEventListener("beforeunload", function(e) {
                $('#preloader').fadeIn();
                $('.wrapper,.main-footer').hide();

            });
            $('#preloader').fadeOut();
            $('.wrapper,.main-footer').show();
        };
    </script>
    @if (Session::has('success'))
        <script>
            toastr.success("{{ Session::get('success') }}")
        </script>
    @elseif (!empty(Session::get('error')))
        <script>
            toastr.error("{{ Session::get('error') }}")
        </script>
    @endif
    <script>
        $(function() {
            $('.select2').select2({
                placeholder: function() {
                    $(this).data('placeholder');
                }
            });
        });
    </script>
    @stack('js')

</body>

</html>


