<?php

use App\Http\Controllers\DashboardController;
use App\Http\Controllers\MyAliceController;
use App\Http\Controllers\SmsController;
use App\Http\Controllers\SmsTempleteController;
use App\Http\Controllers\YesterApiController;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Cache;
use App\Http\Controllers\VoicePlayReportController;
use Illuminate\Support\Facades\Storage;

Route::get('/cache-clear', function () {
    Cache::forget('basic_data');
    Cache::forget('hotdeals1');
    Cache::forget('hotdeals2');
    Cache::forget('latest_products');
    Cache::forget('products_2');

    $directory = 'livewire-tmp';
    Storage::deleteDirectory($directory);
    Storage::makeDirectory($directory);

    return redirect()->back();
});


Route::get('/migration', function () {
    Artisan::call('migrate');
});


Route::get('/', function () {
    return redirect('login');
})->name('/');
Route::get('/yester-api', [YesterApiController::class, 'index'])->name('/yester-api');

Route::get('/yester-get-contact', [SmsController::class, 'getContact'])->name('yester-get-contact');
Route::get('/auto-send-sms', [SmsController::class, 'autoSendSms'])->name('auto-send-sms');
//user role and permission
Route::middleware('auth')->group(function () {
    //role
Route::get('/dashboard', [DashboardController::class, 'index'])->name('/dashboard');

    Route::get('/users', [App\Http\Controllers\user\UserController::class, 'index'])->name('users');
    Route::get('/delete-user/{user_id}', [App\Http\Controllers\user\UserController::class, 'deleteUser']);
    Route::get('/edit-user/{user_id}', [App\Http\Controllers\user\UserController::class, 'editUserPage']);
    Route::post('/update-user', [App\Http\Controllers\user\UserController::class, 'updateUser'])->name('update-user');
    Route::get('/register-user', [App\Http\Controllers\user\UserController::class, 'registerPage'])->name('register-user');
    Route::post('/register-user-post', [App\Http\Controllers\user\UserController::class, 'register'])->name('register-user-post');
    Route::get('/user-role', [App\Http\Controllers\user\RoleAndPermission::class, 'roleIndex'])->name('user-role');
    Route::post('/create-role', [App\Http\Controllers\user\RoleAndPermission::class, 'storeRole'])->name('create_role');
    Route::post('/update-role', [App\Http\Controllers\user\RoleAndPermission::class, 'updateRole'])->name('updateRole');
    Route::post('/login', [App\Http\Controllers\user\UserController::class, 'login'])->name('login');
    Route::get('/change-password', [App\Http\Controllers\user\UserController::class, 'indexChangePass']);
    Route::put('/change-password', [App\Http\Controllers\user\UserController::class, 'updatePassword']);

    //permission and role
    Route::get('permission', [App\Http\Controllers\user\RoleAndPermission::class, 'indexPermission'])->name('permission');
    Route::post('create-permission', [App\Http\Controllers\user\RoleAndPermission::class, 'storePermission'])->name('create-permission');
    Route::post('update-permission', [App\Http\Controllers\user\RoleAndPermission::class, 'updatePermission'])->name('update-permission');
    Route::post('sort-permission-data', [App\Http\Controllers\user\RoleAndPermission::class, 'sortPermissionData'])->name('sort-permission-data');
    Route::get('give-user-role', [App\Http\Controllers\user\RoleAndPermission::class, 'giveUserRole'])->name('give-user-role');
    Route::get('/give-user-permission', [App\Http\Controllers\user\RoleAndPermission::class, 'giveUserPermission'])->name('give-user-permission');
    Route::post('/store-user-permission', [App\Http\Controllers\user\RoleAndPermission::class, 'storeUserPermission'])->name('store-user-permission');
    Route::post('update-given-user-role', [App\Http\Controllers\user\RoleAndPermission::class, 'updateGivenUserRole'])->name('update-given-user-role');
    Route::post('check-user-permission', [App\Http\Controllers\user\RoleAndPermission::class, 'userGivePermissionCheck']);
    Route::post('user-excess-in-card', [App\Http\Controllers\user\RoleAndPermission::class, 'userExcessInCard']);
    Route::get('child-permission/{permission_id}', [App\Http\Controllers\user\RoleAndPermission::class, 'childPermission']);

    //sms config
    Route::get('/sms-config', [SmsController::class, 'indexSmsConfig'])->name('sms-config');
    Route::post('/sms-config-store', [SmsController::class, 'store'])->name('sms-config-store');
    Route::post('/sms-config-update', [SmsController::class, 'update'])->name('sms-config-update');
    Route::get('/delete-sms-config/{config_id}', [SmsController::class, 'delete'])->name('delete-sms-config');
    Route::get('/sms-inbox', [SmsController::class, 'sendSmsList'])->name('sms-inbox');
    Route::get('/send-sms', [SmsController::class, 'sendSms'])->name('send-sms');
    Route::get('/sms-send-count', [SmsController::class, 'smsSendCount'])->name('sms-send-count');
    Route::get('/show-list-of-send-sms', [SmsController::class, 'showListOfSendSms'])->name('show-list-of-send-sms');
    Route::get('/show-list-of-send-sms/{user_id}', [SmsController::class, 'listOfSendSms']);
    // Route::get('/list-of-send-sms/{user_id}/{start_date}/{end_date}', [SmsController::class, 'listOfSendSms'])->name('list-of-send-sms');
    Route::post('/send-manual-sms', [SmsController::class, 'sendManualSms'])->name('send-manual-sms');
    Route::get('/basic', [SmsController::class, 'basicSetup'])->name('basic');
    Route::get('/update-sms-status-ajax', [SmsController::class, 'updateSmsStatusAjax'])->name('update-sms-status-ajax');
    Route::get('/update-sms-default-status-ajax', [SmsController::class, 'updateSmsDefaultStatusAjax'])->name('update-sms-default-status-ajax');
    Route::post('/basic-setup-store', [SmsController::class, 'basicSetupStore'])->name('basic-setup-store');
    Route::post('/preview-excel-sms-first-row-ajax', [SmsController::class, 'previewExcelSmsFirstRowAjax']);
    Route::get('/get_sms_api_ajax', [SmsController::class, 'get_sms_api_ajax']);
    Route::post('/sms-prepare', [SmsController::class, 'smsPrepare']);
    Route::get('/continue_to_send_sms', [SmsController::class, 'continue_to_send_sms']);

    // myalice config
    Route::get('/my-alice-config', [MyAliceController::class, 'indexConfig'])->name('my-alice-config');
    Route::post('/whats-app-sms-config-store', [MyAliceController::class, 'whatsAppSmsConfigStore'])->name('whats-app-sms-config-store');
    Route::get('/update-whats-app-sms-status-ajax', [MyAliceController::class, 'updateWhatsAppSmsConfigStoreAjax'])->name('update-whats-app-sms-status-ajax');
    Route::get('/whats-app-template', [MyAliceController::class, 'whatsAppTemplate'])->name('whats-app-template');
    Route::get('/whats-app-sms-inbox', [MyAliceController::class, 'whatsAppSmsInbox'])->name('whats-app-sms-inbox');
    Route::get('/send-whats-app-sms', [MyAliceController::class, 'sendWhatsAppSms'])->name('send-whats-app-sms');
    Route::post('/send-manual-whats-app-sms', [MyAliceController::class, 'sendManualWhatsAppSms'])->name('send-manual-whats-app-sms');
    Route::get('/whats-template', [MyAliceController::class, 'whatsAppTemplate'])->name('whats-template');
    Route::get('/get-todays-numbers', [MyAliceController::class, 'getTodaysNumbers'])->name('get-todays-numbers');

    //template
    Route::get('/template', [SmsTempleteController::class, 'index'])->name('template');
    Route::get('/delete-template/{template_id}', [SmsTempleteController::class, 'deleteTemplate'])->name('delete-template');
    Route::post('template-store', [SmsTempleteController::class, 'store'])->name('template-store');
    Route::get('/update-template-status-ajax', [SmsTempleteController::class, 'updateTemplateStatusAjax']);
    Route::post('/template-update', [SmsTempleteController::class, 'updateTemplate']);
    
    //yeaster config
    Route::get('/yeaster-config', [YesterApiController::class, 'indexYeasterConfig'])->name('yeaster-config');
    Route::post('/yeaster-config-store', [YesterApiController::class, 'store'])->name('yeaster-config-store');
    Route::get('/delete-yeaster-config/{config_id}', [YesterApiController::class, 'delete'])->name('delete-yeaster-config');


    //voice play report controller
    Route::get('voice-play-report', [VoicePlayReportController::class, 'report'])->name('voice-play-report');
    Route::get('play-numbers-ajax', [VoicePlayReportController::class, 'playNumbersAjax'])->name('play-numbers-ajax');
    Route::get('download-numbers-ajax', [VoicePlayReportController::class, 'downloadNumbersAjax'])->name('download-numbers-ajax');
});
    Route::get('api/{number?}', [VoicePlayReportController::class, 'index'])->name('voice-play-list');
    Route::get('voice-play-audio', [VoicePlayReportController::class, 'downloadRecordings'])->name('voice-play-audio');
    Route::get('download-audio/{audio_id}/{number}', [VoicePlayReportController::class, 'downloadRecordingInLocal'])->name('download-audio');


require __DIR__ . '/auth.php';
