

<?php $__env->startSection('title'); ?>
    Whats App Message Inbox
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <section class="content">
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <ol class="breadcrumb ">
                            <li class="breadcrumb-item"><a href="<?php echo e(url('dashboard')); ?>">Dashboard</a></li>
                            <li class="breadcrumb-item active"><?php echo $__env->yieldContent('title'); ?></li>
                        </ol>
                    </div><!-- /.col -->
                </div><!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
        <!-- /.content-header -->

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row justify-content-between">
                    <div class="col-12">
                        <form action="<?php echo e(url('whats-app-sms-inbox')); ?>" method="GET">
                            <div class="form-row   mb-3">
                                <div class="col-md-2">
                                    <label for="sms_id">ID</label>
                                    <input type="search" class="form-control" name="sms_id" placeholder="Enter Sms ID..."
                                        value="<?php echo e(isset($request) ? $request->sms_id : ''); ?>">
                                </div>
                                <div class="col-md-2">
                                    <label for="platform_id">Platform ID</label>
                                    <input type="search" class="form-control" name="platform_id"
                                        placeholder="Enter Platform ID..."
                                        value="<?php echo e(isset($request) ? $request->platform_id : ''); ?>">
                                </div>
                                <div class="col-md-2">
                                    <label for="recipient_phone_number">Recipient Phone Number</label>
                                    <input type="search" class="form-control" name="recipient_phone_number"
                                        placeholder="Enter Recipient Number..."
                                        value="<?php echo e(isset($request) ? $request->recipient_phone_number : ''); ?>">
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label for="first_date">Date Time</label>
                                        <input type="date" class="form-control" name="date_time"
                                            placeholder="Enter Date Time..."
                                            value="<?php echo e(isset($request) ? $request->date_time : ''); ?>">
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <label for="whats_app_sms_send_status">Status</label>
                                    <select name="whats_app_sms_send_status" class="form-control select2"
                                        data-pleaceholder="Select Option" id="whats_app_sms_send_status">
                                        <option selected value="2">Select Option</option>
                                        <option value="1"
                                            <?php echo e(isset($request) && $request->whats_app_sms_send_status == 1 ? 'selected' : ''); ?>>Send
                                        </option>
                                        <option value="0"
                                            <?php echo e(isset($request) && $request->whats_app_sms_send_status === '0' ? 'selected' : ''); ?>>Not
                                            Send
                                        </option>
                                    </select>
                                </div>
                                <div class="col-md-12 mt-2">
                                    <button class="btn btn-success" id="submit"><i class="fas fa-search"></i>
                                        Search</button>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header bg-gray text-bold">
                                Contact Table
                            </div>
                            <table class="table align-middle mb-0 bg-white table-bordered">
                                <thead class="bg-light">
                                    <tr>
                                        <th style="width: 5%">ID</th>
                                        <th style="width: 15%">Date Time</th>
                                        <th style="width: 15%">System Send Time</th>
                                        <th style="width: 10%">Platform ID</th>
                                        <th style="width: 10%">Recipient Phone Number</th>
                                        <th style="width: 60%">Message Content</th>
                                        <th style="width: 10%">Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                        $serial = ($contacts->currentpage() - 1) * $contacts->perpage() + 1;
                                    ?>

                                    <?php $__empty_1 = true; $__currentLoopData = $contacts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contact): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <?php if($contact->whats_app_sms_send_status == 1): ?>
                                        <tr>
                                            <td><?php echo e($contact->sms_id == 0 ? 'Manual' : $contact->sms_id); ?></td>
                                            <td><?php echo e(\Carbon\Carbon::parse($contact->date_time)->format('Y-m-d h:i a')); ?></td>
                                            <td><?php echo e($contact->date_time_whats_app_sms_send != null ? \Carbon\Carbon::parse($contact->date_time_whats_app_sms_send)->format('Y-m-d h:i a') : ''); ?>

                                            </td>

                                            <td><?php echo e($contact->platform_id); ?></td>
                                            <td><?php echo e($contact->recipient_phone_number); ?></td>
                                            <td><?php echo e($contact->whats_app_sms_content); ?></td>
                                            <td><span
                                                    class="badge badge-<?php echo e($contact->whats_app_sms_send_status == 1 ? 'success' : 'danger'); ?>"><?php echo e($contact->whats_app_sms_send_status == 1 ? 'Send' : 'Not Send'); ?></span>
                                            </td>
                                        </tr>
                                            
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td colspan="10" class="text-danger text-center">Data Not Found!</td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>

                        <?php echo e($contacts->links()); ?>

                    </div>
                </div>
            </div>
        </section>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('back-end.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/jitato/public_html/resources/views/back-end/myalice/send_whats_app_sms_index.blade.php ENDPATH**/ ?>