<?php $__env->startSection('title'); ?>
    Sms Config
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <section class="content">
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <ol class="breadcrumb ">
                            <li class="breadcrumb-item"><a href="<?php echo e(url('dashboard')); ?>">Dashboard</a></li>
                            <li class="breadcrumb-item active"><?php echo $__env->yieldContent('title'); ?></li>
                        </ol>
                    </div><!-- /.col -->
                </div><!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
        <!-- /.content-header -->

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12 my-2">
                        <div class="row">
                            <div class="col-md-2">
                                <button type="button" data-toggle="modal" data-target="#addConfig"
                                    class="btn btn-success  rounded-pill"><i class="fas fa-plus"></i> Add New Api
                                </button>
                            </div>
                            
                            <div class="col-md-2">

                                
                            </div>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header bg-gray text-bold">
                                Sms Config Table
                            </div>

                            <table class="table align-middle mb-0 bg-white table-bordered">
                                <thead class="bg-light">
                                    <tr>
                                        <th>Name</th>
                                        <th>Api Url</th>
                                        <th>Api Key</th>
                                        <th>Type</th>
                                        <th>Auto Send Sms</th>
                                        <th>Default Send Sms</th>
                                        <th>Sender ID</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $sms_configs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sms_config): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($sms_config): ?>
                                            <tr>
                                                <td><?php echo e($sms_config->name); ?></td>
                                                <td><?php echo e($sms_config->api_url); ?></td>
                                                <td><?php echo e($sms_config->api_key); ?></td>
                                                <td><?php echo e($sms_config->type); ?></td>
                                                <td>
                                                    <div class="form-group">
                                                        <?php
                                                            $status = $sms_config->status == 2 ? '' : 'checked';
                                                        ?>
                                                        <div class="custom-control custom-switch">
                                                            <input type="checkbox"
                                                                class="custom-control-input sms_status<?php echo e($sms_config->id); ?>"
                                                                value="<?php echo e($sms_config->status); ?>"
                                                                data-id="<?php echo e($sms_config->id); ?>"
                                                                id="status<?php echo e($sms_config->id); ?>" <?php echo e($status); ?>>
                                                            <label class="custom-control-label"
                                                                for="status<?php echo e($sms_config->id); ?>"><?php echo e($sms_config->status == 2 ? 'Inactive' : 'Active'); ?></label>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="form-group">
                                                        <?php
                                                            $default_send_status = $sms_config->default_send_status == 2 ? '' : 'checked';
                                                        ?>
                                                        <div class="custom-control custom-switch">
                                                            <input type="checkbox"
                                                                class="custom-control-input default_send_status<?php echo e($sms_config->id); ?>"
                                                                value="<?php echo e($sms_config->default_send_status); ?>"
                                                                data-id="<?php echo e($sms_config->id); ?>"
                                                                id="default_send_status<?php echo e($sms_config->id); ?>" <?php echo e($default_send_status); ?>>
                                                            <label class="custom-control-label"
                                                                for="default_send_status<?php echo e($sms_config->id); ?>"><?php echo e($sms_config->default_send_status == 2 ? 'Inactive' : 'Active'); ?></label>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td><?php echo e($sms_config->sender_id); ?></td>
                                                <td>
                                                    <button type="button" data-toggle="modal"
                                                        data-target="#addConfig<?php echo e($sms_config->id); ?>"
                                                        class="btn btn-primary btn-sm rounded-pill btn-rounded text-light">
                                                        <i class="fas fa-pencil-alt"></i> Edit
                                                    </button>
                                                    <a href="<?php echo e(url('delete-sms-config/' . $sms_config->id)); ?>"
                                                        id="delete" type="button"
                                                        class="btn btn-danger btn-sm rounded-pill btn-rounded text-light">
                                                        <i class="fas fa-trash"></i> Delete
                                                    </a>
                                                </td>
                                            </tr>
                                        <?php else: ?>
                                            <tr>
                                                <td colspan="10" class="text-danger text-center">Data Not Found!</td>
                                            </tr>
                                        <?php endif; ?>

                                        <!-- Modal register -->
                                        <div class="modal fade" id="addConfig<?php echo e($sms_config->id); ?>" tabindex="-1"
                                            role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                            <div class="modal-dialog modal-lg" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="exampleModalLabel">Sms Config Edit Form
                                                        </h5>
                                                        <button type="button" class="close" data-dismiss="modal"
                                                            aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <form action="<?php echo e(url('sms-config-update')); ?>" method="POST"
                                                        enctype="multipart/form-data">
                                                        <?php echo csrf_field(); ?>
                                                        <div class="modal-body">
                                                            <div class="card-body">
                                                                <input type="hidden" name="id"
                                                                    value="<?php echo e($sms_config->id); ?>">
                                                                <div class="form-group row">
                                                                    <label class="col-md-3" for="name">Api Name</label>
                                                                    <input type="text" name="name" id="name"
                                                                        required class="form-control col-md-9"
                                                                        placeholder="Enter Api Name"
                                                                        value="<?php echo e($sms_config->name ?? old('name')); ?>">
                                                                    <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                        <span class="text-danger"><?php echo e($message); ?></span>
                                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                                </div>

                                                                <div class="form-group row">
                                                                    <label class="col-md-3" for="api_url">Api Url</label>
                                                                    <input type="text" name="api_url" id="api_url"
                                                                        required class="form-control col-md-9"
                                                                        placeholder="Enter Api Url"
                                                                        value="<?php echo e($sms_config->api_url ?? old('api_url')); ?>">
                                                                    <?php $__errorArgs = ['api_url'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                        <span class="text-danger"><?php echo e($message); ?></span>
                                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                                </div>

                                                                <div class="form-group row">
                                                                    <label class="col-md-3" for="api_key">Api Key</label>
                                                                    <input type="text" name="api_key" id="api_key"
                                                                        required class="form-control col-md-9"
                                                                        placeholder="Enter Api Key"
                                                                        value="<?php echo e($sms_config->api_key ?? old('api_key')); ?>">
                                                                    <?php $__errorArgs = ['api_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                        <span class="text-danger"><?php echo e($message); ?></span>
                                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                                </div>

                                                                <div class="form-group row">
                                                                    <label class="col-md-3" for="sender_id">Sender
                                                                        ID</label>
                                                                    <input type="text" name="sender_id" id="sender_id"
                                                                        required class="form-control col-md-9"
                                                                        placeholder="Enter Api Key"
                                                                        value="<?php echo e($sms_config->sender_id ?? old('sender_id')); ?>">
                                                                    <?php $__errorArgs = ['sender_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                        <span class="text-danger"><?php echo e($message); ?></span>
                                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                                </div>

                                                                <div class="form-group row">
                                                                    <label class="col-md-3" for="type">Type</label>
                                                                    <input type="text" name="type" id="type"
                                                                        required class="form-control col-md-9"
                                                                        placeholder="Enter Api Key" value="text">
                                                                    <?php $__errorArgs = ['type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                        <span class="text-danger"><?php echo e($message); ?></span>
                                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                                </div>

                                                            </div>
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary rounded-pill"
                                                                data-dismiss="modal">Close</button>
                                                            <div class="modal-footer">
                                                                <button type="submit"
                                                                    class="btn btn-primary rounded-pill">Update</button>
                                                            </div>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>

                                        <?php $__env->startPush('js'); ?>
                                            <script>
                                                $(document).ready(function() {
                                                    $(".sms_status<?php echo e($sms_config->id); ?>").change(function(e) {
                                                        e.preventDefault();
                                                        var status = $(this).prop('checked') ? 1 : 2;
                                                        var id = $(this).data('id');
                                                        $.ajax({
                                                            type: "GET", // Change the request type to POST
                                                            url: "<?php echo e(secure_url('update-sms-status-ajax')); ?>",
                                                            data: {
                                                                status: status,
                                                                id: id
                                                            },
                                                            headers: {
                                                                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                                                            },
                                                            success: function(response) {
                                                                // Handle success, if needed
                                                                console.log(response);
                                                            },
                                                            complete: function(done) {
                                                                if (done.status == 200) {
                                                                    location.reload(true);
                                                                }
                                                            }
                                                        });
                                                    });
                                                    
                                                    $(".default_send_status<?php echo e($sms_config->id); ?>").change(function(e) {
                                                        e.preventDefault();
                                                        var status = $(this).prop('checked') ? 1 : 2;
                                                        var id = $(this).data('id');
                                                        $.ajax({
                                                            type: "GET", // Change the request type to POST
                                                            url: "<?php echo e(secure_url('update-sms-default-status-ajax')); ?>",
                                                            data: {
                                                                status: status,
                                                                id: id
                                                            },
                                                            headers: {
                                                                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                                                            },
                                                            success: function(response) {
                                                                // Handle success, if needed
                                                                console.log(response);
                                                            },
                                                            complete: function(done) {
                                                                if (done.status == 200) {
                                                                    location.reload(true);
                                                                }
                                                            }
                                                        });
                                                    });
                                                });
                                            </script>


                                            
                                        <?php $__env->stopPush(); ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <!-- Modal register -->
                <div class="modal fade" id="addConfig" tabindex="-1" role="dialog"
                    aria-labelledby="exampleModalLabel" aria-hidden="true">
                    <div class="modal-dialog modal-lg" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="exampleModalLabel">Sms Config Add Form</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <form action="<?php echo e(url('sms-config-store')); ?>" method="POST" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <div class="modal-body">
                                    <div class="card-body">
                                        <div class="form-group row">
                                            <label class="col-md-3" for="name">Api Name</label>
                                            <input type="text" name="name" id="name" required
                                                class="form-control col-md-9" placeholder="Enter Api Name"
                                                value="<?php echo e(old('name')); ?>">
                                            <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="text-danger"><?php echo e($message); ?></span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                        <div class="form-group row">
                                            <label class="col-md-3" for="api_url">Api Url</label>
                                            <input type="text" name="api_url" id="api_url" required
                                                class="form-control col-md-9" placeholder="Enter Api Url"
                                                value="<?php echo e(old('api_url')); ?>">
                                            <?php $__errorArgs = ['api_url'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="text-danger"><?php echo e($message); ?></span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                        <div class="form-group row">
                                            <label class="col-md-3" for="api_key">Api Key</label>
                                            <input type="text" name="api_key" id="api_key" required
                                                class="form-control col-md-9" placeholder="Enter Api Key"
                                                value="<?php echo e(old('api_key')); ?>">
                                            <?php $__errorArgs = ['api_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="text-danger"><?php echo e($message); ?></span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                        <div class="form-group row">
                                            <label class="col-md-3" for="sender_id">Sender ID</label>
                                            <input type="text" name="sender_id" id="sender_id" required
                                                class="form-control col-md-9" placeholder="Enter Sender ID"
                                                value="<?php echo e(old('sender_id')); ?>">
                                            <?php $__errorArgs = ['sender_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="text-danger"><?php echo e($message); ?></span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                        <div class="form-group row">
                                            <label class="col-md-3" for="type">Type</label>
                                            <input type="text" name="type" id="type" required
                                                class="form-control col-md-9" placeholder="Enter Api Key" value="text">
                                            <?php $__errorArgs = ['type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="text-danger"><?php echo e($message); ?></span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary rounded-pill"
                                        data-dismiss="modal">Close</button>
                                    <div class="modal-footer">
                                        <button type="submit" class="btn btn-primary rounded-pill">Save</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                
            </div>
        </section>

    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('back-end.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/jitato/public_html/resources/views/back-end/sms/indexSmsConfig.blade.php ENDPATH**/ ?>