<?php $__env->startSection('title'); ?>
    MyAlice Config
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <section class="content">
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <ol class="breadcrumb ">
                            <li class="breadcrumb-item"><a href="<?php echo e(url('dashboard')); ?>">Dashboard</a></li>
                            <li class="breadcrumb-item active"><?php echo $__env->yieldContent('title'); ?></li>
                        </ol>
                    </div><!-- /.col -->
                </div><!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
        <!-- /.content-header -->

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12 my-2">
                        <div class="row">
                            <div class="col-md-2">
                                <button type="button" data-toggle="modal" data-target="#addConfig"
                                    class="btn btn-success  rounded-pill"><i class="fas fa-plus"></i> Configure
                                </button>
                            </div>
                            
                            <div class="col-md-5">
                                <div class="form-group">
                                    <?php
                                        $status = $myalice->status == 2 ? "" : "checked";
                                    ?>
                                    <div class="custom-control custom-switch">
                                        <input type="checkbox" class="custom-control-input sms_status" value="<?php echo e($myalice->status); ?>" id="status" <?php echo e($status); ?>>
                                        <label class="custom-control-label" for="status">Auto Send What's App Message</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header bg-gray text-bold">
                                MyAlice API Setting Table
                            </div>

                            <table class="table align-middle mb-0 bg-white table-bordered">
                                <thead class="bg-light">
                                    <tr>
                                        <th>MyAlice Api Url</th>
                                        <th>Api Key</th>
                                        <th>Channel ID</th>
                                        <th>Template ID</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if($myalice): ?>
                                        <tr>
                                            <td><?php echo e($myalice->api_url); ?></td>
                                            <td><?php echo e($myalice->api_key); ?></td>
                                            <td><?php echo e($myalice->channel_id); ?></td>
                                            <td><?php echo e($myalice->template_id); ?></td>
                                            <td>
                                                <button type="button" data-toggle="modal" data-target="#addConfig"
                                                    class="btn btn-primary btn-sm rounded-pill btn-rounded text-light">
                                                    <i class="fas fa-pencil-alt"></i> Edit
                                                </button>
                                                <a href="<?php echo e(url('delete-sms-config/' . $myalice->id)); ?>" id="delete"
                                                    type="button"
                                                    class="btn btn-danger btn-sm rounded-pill btn-rounded text-light">
                                                    <i class="fas fa-trash"></i> Delete
                                                </a>
                                            </td>
                                        </tr>
                                    <?php else: ?>
                                        <tr>
                                            <td colspan="10" class="text-danger text-center">Data Not Found!</td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <!-- Modal register -->
                <div class="modal fade" id="addConfig" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
                    aria-hidden="true">
                    <div class="modal-dialog modal-lg" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="exampleModalLabel">Config Form</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <form action="<?php echo e(url('whats-app-sms-config-store')); ?>" method="POST" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <div class="modal-body">
                                    <div class="card-body">
                                        <div class="form-group row">
                                            <label class="col-md-3" for="api_url">Api Url</label>
                                            <input type="text" name="api_url" id="api_url" required
                                                class="form-control col-md-9" placeholder="Enter Api Url"
                                                value="<?php echo e($myalice->api_url ?? old('api_url')); ?>">
                                            <?php $__errorArgs = ['api_url'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="text-danger"><?php echo e($message); ?></span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                        <div class="form-group row">
                                            <label class="col-md-3" for="api_key">Api Key</label>
                                            <input type="text" name="api_key" id="api_key" required
                                                class="form-control col-md-9" placeholder="Enter Api Key"
                                                value="<?php echo e($myalice->api_key ?? old('api_key')); ?>">
                                            <?php $__errorArgs = ['api_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="text-danger"><?php echo e($message); ?></span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                        <div class="form-group row">
                                            <label class="col-md-3" for="channel_id">Channel ID</label>
                                            <input type="text" name="channel_id" id="channel_id" required
                                                class="form-control col-md-9" placeholder="Enter Channel ID"
                                                value="<?php echo e($myalice->channel_id ?? old('channel_id')); ?>">
                                            <?php $__errorArgs = ['channel_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="text-danger"><?php echo e($message); ?></span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                        <div class="form-group row">
                                            <label class="col-md-3" for="template_id">Template ID</label>
                                            <input type="text" name="template_id" id="template_id" required
                                                class="form-control col-md-9" placeholder="Enter Template ID" value="<?php echo e($myalice->template_id ?? old('template_id')); ?>">
                                            <?php $__errorArgs = ['template_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="text-danger"><?php echo e($message); ?></span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary rounded-pill"
                                        data-dismiss="modal">Close</button>
                                    <div class="modal-footer">
                                        <button type="submit" class="btn btn-primary rounded-pill">Save</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <?php $__env->startPush('js'); ?>
        <script>
            $(document).ready(function () {
                $(".sms_status").change(function (e) {
                    e.preventDefault();
                    var status = $(this).prop('checked') ? 1 : 2;
                    
                    $.ajax({
                        type: "GET", // Change the request type to POST
                        url: "<?php echo e(secure_url('update-whats-app-sms-status-ajax')); ?>",
                        data: {
                            status: status
                        },
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        success: function (response) {
                            // Handle success, if needed
                            console.log(response);
                        },
                        complete: function (done) {
                            if (done.status == 200) {
                                location.reload(true);
                            }
                        }
                    });
                });
            });
        </script>
        
        
            
        <?php $__env->stopPush(); ?>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('back-end.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/jitato/public_html/resources/views/back-end/myalice/myalice_config.blade.php ENDPATH**/ ?>