<?php $__env->startSection('title'); ?>
    Sms Templete
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <section class="content">
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <ol class="breadcrumb ">
                            <li class="breadcrumb-item"><a href="<?php echo e(url('dashboard')); ?>">Dashboard</a></li>
                            <li class="breadcrumb-item active"><?php echo $__env->yieldContent('title'); ?></li>
                        </ol>
                    </div><!-- /.col -->
                </div><!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
        <!-- /.content-header -->

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12 my-2">
                        <button type="button" data-toggle="modal" data-target="#addNew"
                            class="btn btn-success  rounded-pill"><i class="fas fa-plus"></i> Add New Templete
                        </button>
                    </div>
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header bg-gray text-bold">
                                Sms Templete List Table
                            </div>
                            <table class="table align-middle mb-0 bg-white table-bordered">
                                <thead class="bg-light">
                                    <tr>
                                        <th style="20%">Actions</th>
                                        <th style="10%">Active Status</th>
                                        <th style="70%">Message</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                        $serial = ($templates->currentpage() - 1) * $templates->perpage() + 1;
                                    ?>
                                    <?php $__currentLoopData = $templates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $template): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td>
                                                <button type="button" data-toggle="modal" data-target="#editModal"
                                                    class="text-primary p-0 btn editModal" data-template="<?php echo e($template); ?>">
                                                    <i class="fas fa-pencil-alt fa-2x"></i>
                                                </button>
                                                <a href="<?php echo e(url('delete-template/' . $template->id)); ?>" id="delete"
                                                    type="button" class="text-danger btn">
                                                    <i class="fas fa-trash fa-2x"></i>
                                                </a>
                                            </td>
                                            <td>
                                                <div class="form-group">
                                                    <div class="custom-control custom-switch">
                                                        <input type="checkbox" class="custom-control-input templete_status"
                                                            data-id="<?php echo e($template->id); ?>"
                                                            id="active_status<?php echo e($template->id); ?>"
                                                            value="<?php echo e($template->active_status); ?>"
                                                            <?php echo e($template->active_status == 1 ? 'checked' : ''); ?>>
                                                        <label class="custom-control-label"
                                                            for="active_status<?php echo e($template->id); ?>"></label>
                                                    </div>
                                                </div>
                                            </td>
                                            <td><?php echo e($template->message); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                <!-- Modal addNew -->
                <div class="modal fade" id="addNew" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
                    aria-hidden="true">
                    <div class="modal-dialog modal-lg" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="exampleModalLabel">Add New Sms Templete Form</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <form action="<?php echo e(route('template-store')); ?>" method="POST" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <div class="modal-body">
                                    <div class="card-body">
                                        <div class="form-group row">
                                            <label class="col-md-3" for="message">Message</label>
                                            <textarea type="text" name="message" id="message" required class="form-control col-md-9" rows="6"
                                                placeholder="Enter Templete Message"><?php echo e(old('message')); ?></textarea>
                                            <?php $__errorArgs = ['message'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="text-danger"><?php echo e($message); ?></span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary rounded-pill"
                                        data-dismiss="modal">Close</button>
                                    <button type="submit" class="btn btn-primary rounded-pill">Save</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                <!-- Modal EDIT -->
                <div class="modal fade" id="editModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
                    aria-hidden="true">
                    <div class="modal-dialog modal-lg" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="exampleModalLabel">Edit Sms Templete Form</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <form action="<?php echo e(url('template-update')); ?>" method="POST" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <div class="modal-body">
                                    <div class="card-body">
                                        <input type="hidden" name="id" id="id_e">
                                        <div class="form-group row">
                                            <label class="col-md-3" for="message_e">Message</label>
                                            <textarea type="text" name="message" id="message_e" required class="form-control col-md-9" rows="6"
                                                placeholder="Enter Templete Message"><?php echo e(old('message')); ?></textarea>
                                       
                                            <span class="text-danger validate_e" data-field="message"></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary rounded-pill"
                                        data-dismiss="modal">Close</button>
                                    <button type="submit" class="btn btn-primary rounded-pill">Save</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

        </section>
        <?php $__env->startPush('js'); ?>
            <script>
                $(document).ready(function() {
                    $(".editModal").click(function (e) { 
                        e.preventDefault();
                        $('#id_e').val($(this).data('template').id);
                        $('#message_e').val($(this).data('template').message);
                    });


                    $(".templete_status").change(function(e) {
                        e.preventDefault();
                        var templete_id = $(this).data('id');
                        var active_status = $(this).val();

                        $.ajax({
                            type: "GET",
                            url: "<?php echo e(secure_url('update-template-status-ajax')); ?>",
                            data: {
                                id: templete_id,
                                active_status: active_status
                            },
                            success: function(response) {

                            },
                            complete: function(done) {
                                if (done.status == 200) {
                                    location.reload(true);
                                }
                            }
                        });
                    });


                    $("#editData").submit(function(e) {
                        e.preventDefault();
                        var id = $('#id_e').val();
                        var message = $('#message_e').val();
                        $.ajax({
                            type: "POST",
                            url: "<?php echo e(url('template-update')); ?>",
                            headers: {
                                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                            },
                            data: {
                                id: id,
                                message: message
                            },
                            success: function(response) {
                                if (response.success) {
                                    toastr.success(response.success);
                                } else if (response.error) {
                                    toastr.error(response.error);
                                }
                            },
                            error: function(error) {
                                $('.validate').text('');
                                $.each(error.responseJSON.errors, function(field_name, error) {
                                    const errorElement = $('.validate_e[data-field="' +
                                        field_name + '"]');
                                    if (errorElement.length > 0) {
                                        errorElement.text(error[0]);
                                        toastr.error(error);
                                    }
                                });
                            },

                            complete: function(done) {
                                if (done.status == 200) {
                                    window.location.reload();
                                }
                            }

                        });
                    });
                });
            </script>
        <?php $__env->stopPush(); ?>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('back-end.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/jitato/public_html/resources/views/back-end/templete/index.blade.php ENDPATH**/ ?>