<nav class="mt-2">

    <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu" data-accordion="true">
        <div class="mt-3 pb-3 mb-3 d-flex">
            <div class="image">
                <img src="<?php echo e(custom_asset(auth()->user()->photo)); ?>" class="img-circle elevation-2" width="50"
                    height="50" alt="User Image">
            </div>
            <div class="info pl-2">
                <a href="#" class="d-block"><?php echo e(auth()->user()->name); ?></a>
                <small class="text-muted">Role: <?php echo e(auth()->user()->getRoleNames()->first()); ?></small>
                <div class="mt-1">
                    <a href="<?php echo e(route('logout')); ?>" class="btn btn-outline-danger btn-sm"
                        onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                        <i class="fas fa-sign-out-alt"></i> Logout
                    </a>
                    <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
                        <?php echo csrf_field(); ?>
                    </form>
                </div>
            </div>
            <hr>
        </div>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('dashboard')): ?>
            <li class="nav-item">
                <a href="<?php echo e(url('dashboard')); ?>" class="nav-link <?php echo e(request()->is('dashboard') ? 'active' : ''); ?>">
                    <i class="nav-icon fas fa-tachometer-alt"></i>
                    <p>
                        Dashboard
                    </p>
                </a>
            </li>
        <?php endif; ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('sms')): ?>
        <li class="nav-item has-treeview <?php echo e(request()->is('template', 'sms-inbox', 'send-sms', 'sms-send-count',"show-list-of-send-sms*") ? 'menu-open' : ''); ?>">
            <a href="#" class="nav-link <?php echo e(request()->is('template', 'sms-inbox', 'send-sms', 'sms-send-count',"show-list-of-send-sms*") ? 'active' : ''); ?>">
                <i class="nav-icon fab fa-product-hunt"></i>
                <p>
                    Sms
                    <i class="right fas fa-angle-left"></i>
                </p>
            </a>
            <ul class="nav nav-treeview">
                <li class="nav-item">
                    <a href="<?php echo e(url('template')); ?>" class="nav-link <?php echo e(request()->is('template') ? 'active' : ''); ?>">
                        <i class="far fa-circle nav-icon"></i>
                        <p>Sms Template</p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="<?php echo e(url('/send-sms')); ?>" class="nav-link <?php echo e(request()->is('send-sms') ? 'active' : ''); ?>">
                        <i class="far fa-circle nav-icon"></i>
                        <p>Send Sms</p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="<?php echo e(url('/sms-send-count')); ?>" class="nav-link <?php echo e(request()->is('sms-send-count',"show-list-of-send-sms*") ? 'active' : ''); ?>">
                        <i class="far fa-circle nav-icon"></i>
                        <p>Sms send count</p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="<?php echo e(url('/sms-inbox')); ?>"
                        class="nav-link <?php echo e(request()->is('sms-inbox') ? 'active' : ''); ?>">
                        <i class="far fa-circle nav-icon"></i>
                        <p>Send Sms List</p>
                    </a>
                </li>
            </ul>
        </li>
        <?php endif; ?>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('whatsapp')): ?>
        <li class="nav-item has-treeview <?php echo e(request()->is('whats-app-template', 'whats-app-sms-inbox', 'send-whats-app-sms') ? 'menu-open' : ''); ?>">
            <a href="#" class="nav-link <?php echo e(request()->is('whats-app-template', 'whats-app-sms-inbox', 'send-whats-app-sms') ? 'active' : ''); ?>">
                <i class="nav-icon fab fa-product-hunt"></i>
                <p>
                    WhatsApp 
                    <i class="right fas fa-angle-left"></i>
                </p>
            </a>
            <ul class="nav nav-treeview">
                <li class="nav-item">
                    <a href="<?php echo e(url('whats-app-template')); ?>" class="nav-link <?php echo e(request()->is('whats-app-template') ? 'active' : ''); ?>">
                        <i class="far fa-circle nav-icon"></i>
                        <p>WhatsApp Template</p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="<?php echo e(url('/send-whats-app-sms')); ?>" class="nav-link <?php echo e(request()->is('send-whats-app-sms') ? 'active' : ''); ?>">
                        <i class="far fa-circle nav-icon"></i>
                        <p>Send WhatsApp Message</p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="<?php echo e(url('/whats-app-sms-inbox')); ?>"
                        class="nav-link <?php echo e(request()->is('whats-app-sms-inbox') ? 'active' : ''); ?>">
                        <i class="far fa-circle nav-icon"></i>
                        <p>Send WhatsApp Message List</p>
                    </a>
                </li>
            </ul>
        </li>
        <?php endif; ?>


        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('settings')): ?>
        <li
            class="nav-item has-treeview <?php echo e(request()->is(
                'addRole',
                'user-role',
                'permission',
                'give-user-role',
                'give-user-permission',
                'child-permission*',
                'users',
                'change-password',
                'sms-config',
                'yeaster-config',
                'basic',
                'register-user',
                'edit-user*',
                "my-alice-config"
            )
                ? 'menu-open'
                : ''); ?>">
            <a href="#"
                class="nav-link <?php echo e(request()->is(
                    'addRole',
                    'user-role',
                    'permission',
                    'give-user-role',
                    'give-user-permission',
                    'child-permission*',
                    'users',
                    'change-password',
                    'sms-config',
                    'yeaster-config',
                    'basic',
                    'register-user',
                    'edit-user*',
                    "my-alice-config"
                )
                    ? 'active'
                    : ''); ?>">
                <i class="nav-icon fas fa-cog"></i>
                <p>
                    Settings
                    <i class="right fas fa-angle-left"></i>
                </p>
            </a>
            <ul class="nav nav-treeview">

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Basic Setup')): ?>
                <li class="nav-item">
                    <a href="<?php echo e(url('basic')); ?>" class="nav-link <?php echo e(request()->is('basic') ? 'active' : ''); ?>">
                        <i class="far fa-circle nav-icon"></i>
                        <p>Basic Setup</p>
                    </a>
                </li>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('user-role')): ?>
                <li class="nav-item">
                    <a href="<?php echo e(route('user-role')); ?>"
                        class="nav-link <?php echo e(request()->is('user-role') ? 'active' : ''); ?>">
                        <i class="far fa-circle nav-icon"></i>
                        <p>
                            User Role
                        </p>
                    </a>
                </li>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('users')): ?>
                <li class="nav-item">
                    <a href="<?php echo e(route('users')); ?>" class="nav-link <?php echo e(request()->is('users','register-user','edit-user*') ? 'active' : ''); ?>">
                        <i class="far fa-circle nav-icon"></i>
                        <p>
                            Users
                        </p>
                    </a>
                </li>
                <?php endif; ?>
                
                
                
                
                
                
                
                
                
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('change-password')): ?>
                <li class="nav-item">
                    <a href="<?php echo e(url('change-password')); ?>"
                        class="nav-link <?php echo e(request()->is('change-password') ? 'active' : ''); ?>">
                        <i class="far fa-circle nav-icon"></i>
                        <p>Change Password</p>
                    </a>
                </li>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('myalice-configuration')): ?>
                    <li class="nav-item">
                        <a href="<?php echo e(url('my-alice-config')); ?>"
                            class="nav-link <?php echo e(request()->is('my-alice-config') ? 'active' : ''); ?>">
                            <i class="far fa-circle nav-icon"></i>
                            <p>MyAlice Configuration</p>
                        </a>
                    </li>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('sms-configuration')): ?>
                    <li class="nav-item">
                        <a href="<?php echo e(url('sms-config')); ?>"
                            class="nav-link <?php echo e(request()->is('sms-config') ? 'active' : ''); ?>">
                            <i class="far fa-circle nav-icon"></i>
                            <p>SMS Configuration</p>
                        </a>
                    </li>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('yeaster-configuration')): ?>
                    <li class="nav-item">
                        <a href="<?php echo e(url('yeaster-config')); ?>"
                            class="nav-link <?php echo e(request()->is('yeaster-config') ? 'active' : ''); ?>">
                            <i class="far fa-circle nav-icon"></i>
                            <p>Yeaster Configuration</p>
                        </a>
                    </li>
                <?php endif; ?>
            </ul>
        </li>
        <?php endif; ?>
    </ul>
</nav>
<?php /**PATH C:\laragon\www\sms_gatway_malaysia\resources\views/back-end/includes/sidebar.blade.php ENDPATH**/ ?>