<nav class="mt-2">

    <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu" data-accordion="true">
        <div class="mt-3 pb-3 mb-3 d-flex">
            <div class="image">
                <img src="{{ custom_asset(auth()->user()->photo) }}" class="img-circle elevation-2" width="50"
                    height="50" alt="User Image">
            </div>
            <div class="info pl-2">
                <a href="#" class="d-block">{{ auth()->user()->name }}</a>
                <small class="text-muted">Role: {{ auth()->user()->getRoleNames()->first() }}</small>
                <div class="mt-1">
                    <a href="{{ route('logout') }}" class="btn btn-outline-danger btn-sm"
                        onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                        <i class="fas fa-sign-out-alt"></i> Logout
                    </a>
                    <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: none;">
                        @csrf
                    </form>
                </div>
            </div>
            <hr>
        </div>
        @can('dashboard')
            <li class="nav-item">
                <a href="{{ url('dashboard') }}" class="nav-link {{ request()->is('dashboard') ? 'active' : '' }}">
                    <i class="nav-icon fas fa-tachometer-alt"></i>
                    <p>
                        Dashboard
                    </p>
                </a>
            </li>
        @endcan
        @can('sms')
        <li class="nav-item has-treeview {{ request()->is('template', 'sms-inbox', 'send-sms', 'sms-send-count',"show-list-of-send-sms*") ? 'menu-open' : '' }}">
            <a href="#" class="nav-link {{ request()->is('template', 'sms-inbox', 'send-sms', 'sms-send-count',"show-list-of-send-sms*") ? 'active' : '' }}">
                <i class="nav-icon fab fa-product-hunt"></i>
                <p>
                    Sms
                    <i class="right fas fa-angle-left"></i>
                </p>
            </a>
            <ul class="nav nav-treeview">
                <li class="nav-item">
                    <a href="{{ url('template') }}" class="nav-link {{ request()->is('template') ? 'active' : '' }}">
                        <i class="far fa-circle nav-icon"></i>
                        <p>Sms Template</p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="{{ url('/send-sms') }}" class="nav-link {{ request()->is('send-sms') ? 'active' : '' }}">
                        <i class="far fa-circle nav-icon"></i>
                        <p>Send Sms</p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="{{ url('/sms-send-count') }}" class="nav-link {{ request()->is('sms-send-count',"show-list-of-send-sms*") ? 'active' : '' }}">
                        <i class="far fa-circle nav-icon"></i>
                        <p>Sms send count</p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="{{ url('/sms-inbox') }}"
                        class="nav-link {{ request()->is('sms-inbox') ? 'active' : '' }}">
                        <i class="far fa-circle nav-icon"></i>
                        <p>Send Sms List</p>
                    </a>
                </li>
            </ul>
        </li>
        @endcan

        @can('whatsapp')
        <li class="nav-item has-treeview {{ request()->is('whats-app-template', 'whats-app-sms-inbox', 'send-whats-app-sms') ? 'menu-open' : '' }}">
            <a href="#" class="nav-link {{ request()->is('whats-app-template', 'whats-app-sms-inbox', 'send-whats-app-sms') ? 'active' : '' }}">
                <i class="nav-icon fab fa-product-hunt"></i>
                <p>
                    WhatsApp 
                    <i class="right fas fa-angle-left"></i>
                </p>
            </a>
            <ul class="nav nav-treeview">
                <li class="nav-item">
                    <a href="{{ url('whats-app-template') }}" class="nav-link {{ request()->is('whats-app-template') ? 'active' : '' }}">
                        <i class="far fa-circle nav-icon"></i>
                        <p>WhatsApp Template</p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="{{ url('/send-whats-app-sms') }}" class="nav-link {{ request()->is('send-whats-app-sms') ? 'active' : '' }}">
                        <i class="far fa-circle nav-icon"></i>
                        <p>Send WhatsApp Message</p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="{{ url('/whats-app-sms-inbox') }}"
                        class="nav-link {{ request()->is('whats-app-sms-inbox') ? 'active' : '' }}">
                        <i class="far fa-circle nav-icon"></i>
                        <p>Send WhatsApp Message List</p>
                    </a>
                </li>
            </ul>
        </li>
        @endcan

    @can("audio-play")
        <li class="nav-item has-treeview {{ request()->is('voice-play-report', 'voice-play-list') ? 'menu-open' : '' }}">
            <a href="#" class="nav-link {{ request()->is('voice-play-report', 'voice-play-list') ? 'active' : '' }}">
                <i class="nav-icon fab fa-product-hunt"></i>
                <p>
                    Voice Play 
                    <i class="right fas fa-angle-left"></i>
                </p>
            </a>
            {{--  <ul class="nav nav-treeview">
                <li class="nav-item">
                    <a href="{{ url('voice-play-list') }}" class="nav-link {{ request()->is('voice-play-list') ? 'active' : '' }}">
                        <i class="far fa-circle nav-icon"></i>
                        <p>Voice Play List </p>
                    </a>
                </li>
            </ul>  --}}
            <ul class="nav nav-treeview">
                <li class="nav-item">
                    <a href="{{ url('voice-play-report') }}" class="nav-link {{ request()->is('voice-play-report') ? 'active' : '' }}">
                        <i class="far fa-circle nav-icon"></i>
                        <p>Voice Play Report </p>
                    </a>
                </li>
            </ul>
        </li>
        @endcan

        @can('settings')
        <li
            class="nav-item has-treeview {{ request()->is(
                'addRole',
                'user-role',
                'permission',
                'give-user-role',
                'give-user-permission',
                'child-permission*',
                'users',
                'change-password',
                'sms-config',
                'yeaster-config',
                'basic',
                'register-user',
                'edit-user*',
                "my-alice-config"
            )
                ? 'menu-open'
                : '' }}">
            <a href="#"
                class="nav-link {{ request()->is(
                    'addRole',
                    'user-role',
                    'permission',
                    'give-user-role',
                    'give-user-permission',
                    'child-permission*',
                    'users',
                    'change-password',
                    'sms-config',
                    'yeaster-config',
                    'basic',
                    'register-user',
                    'edit-user*',
                    "my-alice-config"
                )
                    ? 'active'
                    : '' }}">
                <i class="nav-icon fas fa-cog"></i>
                <p>
                    Settings
                    <i class="right fas fa-angle-left"></i>
                </p>
            </a>
            <ul class="nav nav-treeview">

                @can('Basic Setup')
                <li class="nav-item">
                    <a href="{{ url('basic') }}" class="nav-link {{ request()->is('basic') ? 'active' : '' }}">
                        <i class="far fa-circle nav-icon"></i>
                        <p>Basic Setup</p>
                    </a>
                </li>
                @endcan
                @can('user-role')
                <li class="nav-item">
                    <a href="{{ route('user-role') }}"
                        class="nav-link {{ request()->is('user-role') ? 'active' : '' }}">
                        <i class="far fa-circle nav-icon"></i>
                        <p>
                            User Role
                        </p>
                    </a>
                </li>
                @endcan
                @can('users')
                <li class="nav-item">
                    <a href="{{ route('users') }}" class="nav-link {{ request()->is('users','register-user','edit-user*') ? 'active' : '' }}">
                        <i class="far fa-circle nav-icon"></i>
                        <p>
                            Users
                        </p>
                    </a>
                </li>
                @endcan
                {{-- @can('user-permission') --}}
                {{-- <li class="nav-item">
                    <a href="{{ route('permission') }}"
                        class="nav-link {{ request()->is('permission', 'child-permission*') ? 'active' : '' }}">
                        <i class="far fa-circle nav-icon"></i>
                        <p>
                            User Permission
                        </p>
                    </a>
                </li> --}}
                {{-- @endcan --}}
                {{-- @can('give-user-role') --}}
                {{-- <li class="nav-item">
                    <a href="{{ route('give-user-role') }}"
                        class="nav-link {{ request()->is('give-user-role') ? 'active' : '' }}">
                        <i class="far fa-circle nav-icon"></i>
                        <p>
                            Give User Role
                        </p>
                    </a>
                </li> --}}
                {{-- @endcan --}}
                {{-- @can('give-user-permission') --}}
                {{-- <li class="nav-item">
                    <a href="{{ route('give-user-permission') }}"
                        class="nav-link {{ request()->is('give-user-permission') ? 'active' : '' }}">
                        <i class="far fa-circle nav-icon"></i>
                        <p>
                            Give User Permission
                        </p>
                    </a>
                </li> --}}
                {{-- @endcan --}}
                @can('change-password')
                <li class="nav-item">
                    <a href="{{ url('change-password') }}"
                        class="nav-link {{ request()->is('change-password') ? 'active' : '' }}">
                        <i class="far fa-circle nav-icon"></i>
                        <p>Change Password</p>
                    </a>
                </li>
                @endcan
                @can('myalice-configuration')
                    <li class="nav-item">
                        <a href="{{ url('my-alice-config') }}"
                            class="nav-link {{ request()->is('my-alice-config') ? 'active' : '' }}">
                            <i class="far fa-circle nav-icon"></i>
                            <p>MyAlice Configuration</p>
                        </a>
                    </li>
                @endcan
                @can('sms-configuration')
                    <li class="nav-item">
                        <a href="{{ url('sms-config') }}"
                            class="nav-link {{ request()->is('sms-config') ? 'active' : '' }}">
                            <i class="far fa-circle nav-icon"></i>
                            <p>SMS Configuration</p>
                        </a>
                    </li>
                @endcan
                @can('yeaster-configuration')
                    <li class="nav-item">
                        <a href="{{ url('yeaster-config') }}"
                            class="nav-link {{ request()->is('yeaster-config') ? 'active' : '' }}">
                            <i class="far fa-circle nav-icon"></i>
                            <p>Yeaster Configuration</p>
                        </a>
                    </li>
                @endcan
            </ul>
        </li>
        @endcan
    </ul>
</nav>
