@extends('back-end.layouts.master')

@section('title')
    List of send sms
@endsection

@section('content')
    <section class="content">
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <ol class="breadcrumb ">
                            <li class="breadcrumb-item"><a href="{{ url('dashboard') }}">Dashboard</a></li>
                            <li class="breadcrumb-item active">{{ $user->name }}</li>
                            <li class="breadcrumb-item active">@yield('title')</li>
                        </ol>
                    </div><!-- /.col -->
                </div><!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
        <!-- /.content-header -->

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row justify-content-between">
                    <div class="col-12">
                        <form action="{{ url('show-list-of-send-sms') }}" method="GET">
                            <div class="form-row {{-- align-items-left  float-right --}}  mb-3">
                                <div class="col-md-2">
                                    <label for="sms_id">ID</label>
                                    <input type="search" class="form-control" name="sms_id" placeholder="Enter Sms ID..."
                                        value="{{ isset($request) ? $request->sms_id : '' }}">
                                    <input type="hidden" name="user_id" value="{{ $user->id }}">
                                </div>
                                <input type="hidden" name="start_date" value="{{ $request->start_date }}">
                                <input type="hidden" name="end_date" value="{{ $request->end_date }}">
                                <div class="col-md-2">
                                    <label for="sender_id">Sender ID</label>
                                    <input type="search" class="form-control" name="sender_id"
                                        placeholder="Enter Sender ID..."
                                        value="{{ isset($request) ? $request->sender_id : '' }}">
                                </div>
                                <div class="col-md-2">
                                    <label for="recipient_phone_number">Recipient Phone Number</label>
                                    <input type="search" class="form-control" name="recipient_phone_number"
                                        placeholder="Enter Recipient Number..."
                                        value="{{ isset($request) ? $request->recipient_phone_number : '' }}">
                                </div>

                                <div class="col-md-12 mt-2">
                                    <button class="btn btn-success" id="submit"><i class="fas fa-search"></i>
                                        Search</button>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="col-12">

                        @if ($request->start_date && $request->end_date)
                            <p>Search From
                                <strong>{{ \Carbon\Carbon::parse($request->start_date)->format('Y-m-d') }}</strong> To
                                <strong>{{ \Carbon\Carbon::parse($request->end_date)->format('Y-m-d') }}</strong>
                            </p>
                        @endif
                        <div class="card">
                            <div class="card-header bg-gray text-bold">
                                Contact Table
                            </div>
                            <table class="table align-middle mb-0 bg-white table-bordered">
                                <thead class="bg-light">
                                    <tr>
                                        <th style="width: 5%">ID</th>
                                        <th style="width: 11%">Date Time</th>
                                        <th style="width: 11%">System Send Time</th>
                                        <th style="width: 8%">Sender ID</th>
                                        <th style="width: 10%">Recipient Phone Number</th>
                                        <th style="width: 50%">Sms Content</th>
                                        <th style="width: 10%">Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php
                                        $serial = ($contacts->currentpage() - 1) * $contacts->perpage() + 1;
                                    @endphp

                                    @forelse ($contacts as $contact)
                                        @if ($contact->active_status == 1)
                                            <tr>
                                                <td>{{ $contact->sms_id == 0 ? 'Manual' : $contact->sms_id }}</td>
                                                <td>{{ \Carbon\Carbon::parse($contact->date_time)->format('Y-m-d h:i a') }}
                                                </td>
                                                <td>{{ $contact->system_send_time != null ? \Carbon\Carbon::parse($contact->system_send_time)->format('Y-m-d h:i a') : '' }}
                                                </td>

                                                <td>{{ $contact->sender_id }}</td>
                                                <td>{{ $contact->recipient_phone_number }}</td>
                                                <td>{{ $contact->sms_content }}</td>
                                                <td><span
                                                        class="badge badge-{{ $contact->active_status == 1 ? 'success' : 'danger' }}">{{ $contact->active_status == 1 ? 'Send' : 'Not Send' }}</span>
                                                </td>
                                            </tr>
                                        @endif
                                    @empty
                                        <tr>
                                            <td colspan="10" class="text-danger text-center">Data Not Found!</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>

                        {{ $contacts->appends($request->query())->links() }}
                    </div>
                </div>
            </div>
        </section>
    </section>
@endsection
