@extends('back-end.layouts.master')

@section('title')
    Register User
@endsection

@section('content')
    <section class="content">
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <ol class="breadcrumb ">
                            <li class="breadcrumb-item"><a href="{{ url('dashboard') }}">Dashboard</a></li>
                            <li class="breadcrumb-item active">@yield('title')</li>
                        </ol>
                    </div><!-- /.col -->
                </div><!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
        <!-- /.content-header -->

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12 my-2">
                        <a href="{{ url('register-user') }}" class="btn btn-success  rounded-pill"><i
                                class="fas fa-plus"></i> Register
                            User
                        </a>
                    </div>
                    <div class="col-6">
                        <div class="card">
                            <div class="card-header bg-secondary">
                                Register User Form
                            </div>
                            <form action="{{ route('register-user-post') }}" method="POST" enctype="multipart/form-data">
                                @csrf
                                <div class="card-body">
                                    <div class="form-group row">
                                        <label class="col-md-3" for="name">Name</label>
                                        <input type="text" name="name" id="name" required
                                            class="form-control col-md-9" placeholder="Enter User Name"
                                            value="{{ old('name') }}">
                                        @error('name')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group row">
                                        <label class="col-md-3" for="email">Email</label>
                                        <input type="text" name="email" id="email" required
                                            class="form-control col-md-9" placeholder="Enter User Email"
                                            value="{{ old('email') }}">
                                        @error('email')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>

                                    <div class="form-group row">
                                        <label class="col-md-3" for="password">Password</label>
                                        <div class="col-md-9 px-0">
                                            <input type="password" name="password" id="password" required
                                                class="form-control" placeholder="Enter User Password"
                                                value="{{ old('password') }}">
                                            @error('password')
                                                <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                            <span id="password_alert" class="text-danger mb-1"></span>
                                        </div>

                                    </div>
                                    <div class="form-group row">
                                        <label class="col-md-3" for="photo">Photo</label>
                                        <input type="file" name="photo" id="photoUpload" required
                                            class="form-control col-md-9" placeholder="Enter User Name"
                                            value="{{ old('photo') }}">
                                        @error('photo')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="col-md-3 offset-3">
                                        <img class="previewHolder" src="" alt="">
                                    </div>
                                    <div class="form-group row">
                                        <label class="col-md-3">User Role</label>
                                        <div class="col-md-9 px-0">
                                            <select name="user_type" required class="form-control select2"
                                                style="width: 100%;">
                                                <option label="Choose Type" selected disabled>Select One</option>
                                                @foreach ($roles as $role)
                                                    <option value="{{ $role->name }}">{{ $role->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        @error('type')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <strong>Permissions:</strong>
                                    @foreach ($permissions as $permission)
                                    <div class="custom-control custom-checkbox">
                                        <input class="custom-control-input" type="checkbox" name="permission[]" id="permission{{ $permission->name }}" value="{{ $permission->id }}">
                                        <label for="permission{{ $permission->name }}" class="custom-control-label">{{ $permission->name }}</label>
                                    </div>
                                    @endforeach
                                    {{-- <div class="form-group row">
                                        <label class="col-md-3" for="password_confirmation">Confirm Password</label>
                                        <input type="password" name="password_confirmation" id="password_confirmation"
                                            required class="form-control col-md-9" placeholder="Enter Confirmation Password"
                                            value="{{ old('password_confirmation') }}">
                                        @error('password_confirmation')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div> --}}
                                    <div class="pt-2">
                                        <button type="submit" class="btn btn-block btn-primary">
                                            Register</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    @endsection

    @section('script')
        <script>
            //password chacker
            $(document).ready(function() {
                $('#password').keyup(function() {
                    value = $(this).val();
                    if (value.length < 8) {
                        $('#password_alert').html('Please Enter Minimum 8 Digit!');
                    } else if (value.length >= 8) {
                        $('#password_alert').empty();
                    };
                });
            });
        </script>
        <script>
            $(document).ready(function() {
                //edit modal close restart
                $(".editUser").on("hidden.bs.modal", function() {
                    $(this).find('form').trigger('reset');
                });
                //add modal reset
                $('#registerUser').on("hidden.bs.modal", function() {
                    $('#name').val('');
                    $('#email').val('');
                    $('#photoUpload').val('');
                    $('#user_type').val('');
                    $('.previewHolder').attr('src', '');

                });

                //preview image user
                function readURL(input) {
                    if (input.files && input.files[0]) {
                        var reader = new FileReader();
                        reader.onload = function(e) {
                            $('.previewHolder').attr('src', '');
                            $('.previewHolder').attr('src', e.target.result);
                            $('.previewHolder').css('width', '100px')
                        }
                        reader.readAsDataURL(input.files[0]);
                    } else {
                        alert('select a file to see preview');
                        $('.previewHolder').attr('src', '');
                    }
                }
                $("#photoUpload").change(function() {
                    readURL(this);
                });

                //preview image user
                function readURL(input) {
                    if (input.files && input.files[0]) {
                        var reader = new FileReader();
                        reader.onload = function(e) {
                            $('.previewUpdate').attr('src', '');
                            $('.previewUpdate').attr('src', e.target.result);
                            $('.previewUpdate').css('width', '100px')
                        }
                        reader.readAsDataURL(input.files[0]);
                    } else {
                        alert('select a file to see preview');
                        $('.previewUpdate').attr('src', '');
                    }
                }
                $(".photoUpdate").change(function() {
                    readURL(this);
                });
            });
        </script>
    @endsection
