@extends('back-end.layouts.master')

@section('title')
Yeaster Config
@endsection

@section('content')
    <section class="content">
        <div class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <ol class="breadcrumb ">
                            <li class="breadcrumb-item"><a href="{{ url('dashboard') }}">Dashboard</a></li>
                            <li class="breadcrumb-item active">@yield('title')</li>
                        </ol>
                    </div><!-- /.col -->
                </div><!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
        <!-- /.content-header -->

        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12 my-2">
                        <button type="button" data-toggle="modal" data-target="#addConfig"
                            class="btn btn-success  rounded-pill"><i class="fas fa-plus"></i> Configure
                        </button>
                    </div>
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header bg-gray text-bold">
                                Yeaster Config Table
                            </div>
                            <table class="table align-middle mb-0 bg-white table-bordered">
                                <thead class="bg-light">
                                    <tr>
                                        <th>Username/Client ID </th>
                                        <th>Password/Client Secret</th>
                                        <th>Call Status</th>
                                        <th>Communication Type</th>
                                        <th>Call Duration</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @if ($yester_config)
                                    <tr>
                                        <td>{{ $yester_config->username }}</td>
                                        <td>{{ $yester_config->password }}</td>
                                        <td>{{ $yester_config->call_status }}</td>
                                        <td>{{ $yester_config->communication_type }}</td>
                                        <td>{{ $yester_config->call_duration }}</td>
                                        <td>
                                            <button type="button" data-toggle="modal"
                                                data-target="#addConfig"
                                                class="btn btn-primary btn-sm rounded-pill btn-rounded text-light">
                                                <i class="fas fa-pencil-alt"></i> Edit
                                            </button>
                                            <a href="{{ url('delete-sms-config/' . $yester_config->id) }}" id="delete" type="button"
                                                class="btn btn-danger btn-sm rounded-pill btn-rounded text-light">
                                                <i class="fas fa-trash"></i> Delete
                                            </a>
                                        </td>
                                    </tr>
                                    @else
                                    <tr>
                                        <td colspan="10" class="text-danger text-center">Data Not Found!</td>
                                    </tr>
                                    @endif
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <!-- Modal register -->
                <div class="modal fade" id="addConfig" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
                    aria-hidden="true">
                    <div class="modal-dialog modal-lg" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="exampleModalLabel">Yeaster Config Form</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <form action="{{ url('yeaster-config-store') }}" method="POST" enctype="multipart/form-data">
                                @csrf
                                <div class="modal-body">
                                    <div class="card-body">
                                        <div class="form-group row">
                                            <label class="col-md-3" for="username">Username/Client ID</label>
                                            <input type="text" name="username" id="username" required
                                                class="form-control col-md-9" placeholder="Enter Username/Client ID"
                                                value="{{ $yester_config->username ?? old('username') }}">
                                            @error('username')
                                                <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>

                                        <div class="form-group row">
                                            <label class="col-md-3" for="password">Password/Client Secret</label>
                                            <input type="text" name="password" id="password" required
                                                class="form-control col-md-9" placeholder="Enter Password/Client Secret"
                                                value="{{ $yester_config->password ?? old('password')  }}">
                                            @error('password')
                                                <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>

                                        <div class="form-group row">
                                            <label class="col-md-3" for="call_status">Call Status</label>
                                            <input type="text" name="call_status" id="call_status" required
                                                class="form-control col-md-9" placeholder="Enter Call Status"
                                                value="{{ $yester_config->call_status ?? old('call_status')  }}">
                                            @error('call_status')
                                                <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>

                                        <div class="form-group row">
                                            <label class="col-md-3" for="communication_type">Communication Type</label>
                                            <input type="text" name="communication_type" id="communication_type" required
                                                class="form-control col-md-9" placeholder="Enter Password/Client Secret"
                                                value="{{ $yester_config->communication_type ?? old('call_status')  }}">
                                            @error('communication_type')
                                                <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>

                                        <div class="form-group row">
                                            <label class="col-md-3" for="call_duration">Call Duration</label>
                                            <input type="numeric" name="call_duration" id="call_duration" required
                                                class="form-control col-md-9" placeholder="Enter Call Duration"
                                                value="{{ $yester_config->call_duration ?? old('call_duration')  }}">
                                            @error('call_duration')
                                                <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary rounded-pill"
                                        data-dismiss="modal">Close</button>
                                    <div class="modal-footer">
                                        <button type="submit" class="btn btn-primary rounded-pill">Save</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </section>
@endsection
