import { OverridableMap } from '../../types/overridable-map';
import { Injectable } from '@angular/core';
import * as i0 from "@angular/core";
class RecordMapperRegistry {
    constructor() {
        this.init();
    }
    register(module, key, mapper) {
        this.map.addEntry(module, key, mapper);
    }
    exclude(module, key) {
        this.map.excludeEntry(module, key);
    }
    get(module) {
        return this.map.getGroupEntries(module);
    }
    has(module, key) {
        const moduleFields = this.map.getGroupEntries(module);
        return !!moduleFields[key];
    }
    init() {
        this.map = new OverridableMap();
    }
    static { this.ɵfac = function RecordMapperRegistry_Factory(t) { return new (t || RecordMapperRegistry)(); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: RecordMapperRegistry, factory: RecordMapperRegistry.ɵfac, providedIn: 'root' }); }
}
export { RecordMapperRegistry };
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(RecordMapperRegistry, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return []; }, null); })();
//# sourceMappingURL=data:application/json;base64,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