/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
import { Component, ElementRef, NgZone, ViewChild } from '@angular/core';
import { ActivatedRoute, Router } from '@angular/router';
import { DomSanitizer } from '@angular/platform-browser';
import { IframeResizeHandlerHandler } from '../../services/iframe-resize-handler.service';
import { SystemConfigStore } from '../../../../store/system-config/system-config.store';
import { AuthService } from '../../../../services/auth/auth.service';
import { RouteConverter } from '../../../../services/navigation/route-converter/route-converter.service';
import { IframePageChangeObserver } from '../../services/iframe-page-change-observer.service';
import { take } from "rxjs/operators";
import * as i0 from "@angular/core";
import * as i1 from "@angular/router";
import * as i2 from "@angular/platform-browser";
import * as i3 from "../../../../services/navigation/route-converter/route-converter.service";
import * as i4 from "../../../../services/auth/auth.service";
import * as i5 from "../../../../store/system-config/system-config.store";
const _c0 = ["dataContainer"];
class ClassicViewUiComponent {
    constructor(route, router, sanitizer, routeConverter, auth, ngZone, systemConfigs) {
        this.route = route;
        this.router = router;
        this.sanitizer = sanitizer;
        this.routeConverter = routeConverter;
        this.auth = auth;
        this.ngZone = ngZone;
        this.systemConfigs = systemConfigs;
        this.iframe = null;
    }
    ngOnInit() {
        this.url = this.route.snapshot.data.legacyUrl;
    }
    ngAfterViewInit() {
        this.initIframe();
    }
    ngOnDestroy() {
        this.cleanObservers();
        this.iframe = null;
        const placeholder = this.wrapper;
        if (this.wrapper.firstChild) {
            placeholder.removeChild(placeholder.firstChild);
        }
        placeholder.innerHTML = '<iframe></iframe>';
        this.wrapper = null;
    }
    cleanObservers() {
        if (this.iframeResizeHandler) {
            this.iframeResizeHandler.destroy();
            this.iframeResizeHandler = null;
        }
        if (this.iframePageChangeHandler) {
            this.iframePageChangeHandler.destroy();
            this.iframePageChangeHandler = null;
        }
    }
    initIframe() {
        this.wrapper = this.dataContainer.nativeElement;
        if (this.wrapper.firstChild) {
            this.wrapper.removeChild(this.wrapper.firstChild);
        }
        const iframe = document.createElement('iframe');
        iframe.src = this.url;
        this.wrapper.appendChild(iframe);
        this.iframe = iframe;
        this.iframe.style.display = 'block';
        this.initObservers();
    }
    initObservers() {
        this.iframePageChangeHandler = this.buildIframePageChangeObserver();
        this.iframeResizeHandler = this.buildIframeResizeHandlerHandler();
        if (this.iframePageChangeHandler) {
            this.iframePageChangeHandler.init();
        }
    }
    onPageChange(newLocation) {
        if (this.shouldRedirect(newLocation) === false) {
            this.iframe.style.display = 'block';
            this.cleanObservers();
            this.initObservers();
            return;
        }
        const location = this.routeConverter.toFrontEndRoute(newLocation);
        if (location === '/users/login') {
            this.auth.logout('LBL_SESSION_EXPIRED');
            return;
        }
        this.ngZone.run(() => this.router.navigateByUrl(location).then()).then();
    }
    onIFrameLoad() {
        // Do not show scroll at any time, to avoid flickering
        this.iframe.contentWindow.document.body.style.overflow = 'hidden';
        // Init resize handler
        this.iframeResizeHandler.init(this.iframe);
        this.forceCacheRebuildAfterRepairAndRebuild();
    }
    // Temporary solution. Force a cache rebuild after quick repair and rebuild.
    // Can be removed after Repair and Rebuild page is re-done with to Suite8 views.
    forceCacheRebuildAfterRepairAndRebuild() {
        const iframeUrl = this.iframe.contentWindow.location.href;
        const url = new URL(iframeUrl);
        const params = new URLSearchParams(url.search);
        if (params.get('module') === 'Administration' && params.get('action') === 'repair') {
            this.auth.fetchSessionStatus().pipe(take(1)).subscribe();
        }
    }
    onIFrameUnload() {
        // hide iframe, while being re-directed
        this.iframe.style.display = 'none';
        this.iframeResizeHandler.destroy();
    }
    buildIframePageChangeObserver() {
        return new IframePageChangeObserver(this.iframe, this.onPageChange.bind(this), this.onIFrameLoad.bind(this), this.onIFrameUnload.bind(this));
    }
    buildIframeResizeHandlerHandler() {
        return new IframeResizeHandlerHandler();
    }
    /**
     * Check if should re-direct to link or if it was excluded
     *
     * @param {string} legacyLink to check
     * @returns {boolean} should redirect
     */
    shouldRedirect(legacyLink) {
        if (legacyLink && legacyLink.includes('/#/')) {
            return true;
        }
        const routeInfo = this.routeConverter.parse(legacyLink);
        // if no route or no module, don't re-direct
        if (!routeInfo || !routeInfo.module) {
            return false;
        }
        const reuse = this.routeConverter.matchesActiveRoute(this.route, routeInfo);
        if (reuse === true) {
            return false;
        }
        if (!routeInfo.action) {
            return true;
        }
        return this.toExclude(routeInfo);
    }
    /**
     * Check if given route is to exclude from redirection
     *
     * @param {object} routeInfo to check
     * @returns {boolean} is to exclude
     */
    toExclude(routeInfo) {
        const exclusions = this.systemConfigs.getConfigValue('classicview_routing_exclusions');
        if (!exclusions || Object.keys(exclusions).length === 0) {
            return true;
        }
        // if action is excluded for any module, don't re-direct
        if (exclusions.any && exclusions.any.includes(routeInfo.action)) {
            return false;
        }
        if (!exclusions[routeInfo.module]) {
            return true;
        }
        // if module action is excluded, don't re-direct
        const moduleExclusions = exclusions[routeInfo.module];
        return !(moduleExclusions && moduleExclusions.includes(routeInfo.action));
    }
    static { this.ɵfac = function ClassicViewUiComponent_Factory(t) { return new (t || ClassicViewUiComponent)(i0.ɵɵdirectiveInject(i1.ActivatedRoute), i0.ɵɵdirectiveInject(i1.Router), i0.ɵɵdirectiveInject(i2.DomSanitizer), i0.ɵɵdirectiveInject(i3.RouteConverter), i0.ɵɵdirectiveInject(i4.AuthService), i0.ɵɵdirectiveInject(i0.NgZone), i0.ɵɵdirectiveInject(i5.SystemConfigStore)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: ClassicViewUiComponent, selectors: [["scrm-classic-view-ui"]], viewQuery: function ClassicViewUiComponent_Query(rf, ctx) { if (rf & 1) {
            i0.ɵɵviewQuery(_c0, 7);
        } if (rf & 2) {
            let _t;
            i0.ɵɵqueryRefresh(_t = i0.ɵɵloadQuery()) && (ctx.dataContainer = _t.first);
        } }, decls: 3, vars: 0, consts: [[1, "classic-view-container"], ["dataContainer", ""]], template: function ClassicViewUiComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵelementStart(0, "div", 0, 1);
            i0.ɵɵelement(2, "iframe");
            i0.ɵɵelementEnd();
        } }, encapsulation: 2 }); }
}
export { ClassicViewUiComponent };
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ClassicViewUiComponent, [{
        type: Component,
        args: [{ selector: 'scrm-classic-view-ui', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<div class=\"classic-view-container\" #dataContainer>\n    <iframe></iframe>\n</div>\n" }]
    }], function () { return [{ type: i1.ActivatedRoute }, { type: i1.Router }, { type: i2.DomSanitizer }, { type: i3.RouteConverter }, { type: i4.AuthService }, { type: i0.NgZone }, { type: i5.SystemConfigStore }]; }, { dataContainer: [{
            type: ViewChild,
            args: ['dataContainer', { static: true }]
        }] }); })();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2xhc3NpYy12aWV3LmNvbXBvbmVudC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uLy4uLy4uL2NvcmUvYXBwL2NvcmUvc3JjL2xpYi92aWV3cy9jbGFzc2ljL2NvbXBvbmVudHMvY2xhc3NpYy12aWV3L2NsYXNzaWMtdmlldy5jb21wb25lbnQudHMiLCIuLi8uLi8uLi8uLi8uLi8uLi8uLi8uLi9jb3JlL2FwcC9jb3JlL3NyYy9saWIvdmlld3MvY2xhc3NpYy9jb21wb25lbnRzL2NsYXNzaWMtdmlldy9jbGFzc2ljLXZpZXcuY29tcG9uZW50Lmh0bWwiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztHQXdCRztBQUVILE9BQU8sRUFBZ0IsU0FBUyxFQUFFLFVBQVUsRUFBRSxNQUFNLEVBQXFCLFNBQVMsRUFBQyxNQUFNLGVBQWUsQ0FBQztBQUN6RyxPQUFPLEVBQUMsY0FBYyxFQUFFLE1BQU0sRUFBQyxNQUFNLGlCQUFpQixDQUFDO0FBQ3ZELE9BQU8sRUFBQyxZQUFZLEVBQUMsTUFBTSwyQkFBMkIsQ0FBQztBQUN2RCxPQUFPLEVBQUMsMEJBQTBCLEVBQUMsTUFBTSw4Q0FBOEMsQ0FBQztBQUN4RixPQUFPLEVBQUMsaUJBQWlCLEVBQUMsTUFBTSxxREFBcUQsQ0FBQztBQUN0RixPQUFPLEVBQUMsV0FBVyxFQUFDLE1BQU0sd0NBQXdDLENBQUM7QUFDbkUsT0FBTyxFQUFDLGNBQWMsRUFBWSxNQUFNLHlFQUF5RSxDQUFDO0FBQ2xILE9BQU8sRUFBQyx3QkFBd0IsRUFBQyxNQUFNLG9EQUFvRCxDQUFDO0FBQzVGLE9BQU8sRUFBQyxJQUFJLEVBQUMsTUFBTSxnQkFBZ0IsQ0FBQzs7Ozs7Ozs7QUFNcEMsTUFLYSxzQkFBc0I7SUFTL0IsWUFDWSxLQUFxQixFQUNyQixNQUFjLEVBQ2QsU0FBdUIsRUFDdkIsY0FBOEIsRUFDOUIsSUFBaUIsRUFDakIsTUFBYyxFQUNkLGFBQWdDO1FBTmhDLFVBQUssR0FBTCxLQUFLLENBQWdCO1FBQ3JCLFdBQU0sR0FBTixNQUFNLENBQVE7UUFDZCxjQUFTLEdBQVQsU0FBUyxDQUFjO1FBQ3ZCLG1CQUFjLEdBQWQsY0FBYyxDQUFnQjtRQUM5QixTQUFJLEdBQUosSUFBSSxDQUFhO1FBQ2pCLFdBQU0sR0FBTixNQUFNLENBQVE7UUFDZCxrQkFBYSxHQUFiLGFBQWEsQ0FBbUI7UUFYbEMsV0FBTSxHQUFHLElBQUksQ0FBQztJQWF4QixDQUFDO0lBRUQsUUFBUTtRQUNKLElBQUksQ0FBQyxHQUFHLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQztJQUNsRCxDQUFDO0lBRUQsZUFBZTtRQUNYLElBQUksQ0FBQyxVQUFVLEVBQUUsQ0FBQztJQUN0QixDQUFDO0lBRUQsV0FBVztRQUNQLElBQUksQ0FBQyxjQUFjLEVBQUUsQ0FBQztRQUV0QixJQUFJLENBQUMsTUFBTSxHQUFHLElBQUksQ0FBQztRQUNuQixNQUFNLFdBQVcsR0FBRyxJQUFJLENBQUMsT0FBTyxDQUFDO1FBQ2pDLElBQUksSUFBSSxDQUFDLE9BQU8sQ0FBQyxVQUFVLEVBQUU7WUFDekIsV0FBVyxDQUFDLFdBQVcsQ0FBQyxXQUFXLENBQUMsVUFBVSxDQUFDLENBQUM7U0FDbkQ7UUFDRCxXQUFXLENBQUMsU0FBUyxHQUFHLG1CQUFtQixDQUFDO1FBQzVDLElBQUksQ0FBQyxPQUFPLEdBQUcsSUFBSSxDQUFDO0lBQ3hCLENBQUM7SUFFRCxjQUFjO1FBQ1YsSUFBSSxJQUFJLENBQUMsbUJBQW1CLEVBQUU7WUFDMUIsSUFBSSxDQUFDLG1CQUFtQixDQUFDLE9BQU8sRUFBRSxDQUFDO1lBQ25DLElBQUksQ0FBQyxtQkFBbUIsR0FBRyxJQUFJLENBQUM7U0FFbkM7UUFDRCxJQUFJLElBQUksQ0FBQyx1QkFBdUIsRUFBRTtZQUM5QixJQUFJLENBQUMsdUJBQXVCLENBQUMsT0FBTyxFQUFFLENBQUM7WUFDdkMsSUFBSSxDQUFDLHVCQUF1QixHQUFHLElBQUksQ0FBQztTQUN2QztJQUNMLENBQUM7SUFFRCxVQUFVO1FBQ04sSUFBSSxDQUFDLE9BQU8sR0FBRyxJQUFJLENBQUMsYUFBYSxDQUFDLGFBQWEsQ0FBQztRQUVoRCxJQUFJLElBQUksQ0FBQyxPQUFPLENBQUMsVUFBVSxFQUFFO1lBQ3pCLElBQUksQ0FBQyxPQUFPLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsVUFBVSxDQUFDLENBQUM7U0FDckQ7UUFDRCxNQUFNLE1BQU0sR0FBRyxRQUFRLENBQUMsYUFBYSxDQUFDLFFBQVEsQ0FBQyxDQUFDO1FBQ2hELE1BQU0sQ0FBQyxHQUFHLEdBQUcsSUFBSSxDQUFDLEdBQUcsQ0FBQztRQUV0QixJQUFJLENBQUMsT0FBTyxDQUFDLFdBQVcsQ0FBQyxNQUFNLENBQUMsQ0FBQztRQUVqQyxJQUFJLENBQUMsTUFBTSxHQUFHLE1BQU0sQ0FBQztRQUVyQixJQUFJLENBQUMsTUFBTSxDQUFDLEtBQUssQ0FBQyxPQUFPLEdBQUcsT0FBTyxDQUFDO1FBRXBDLElBQUksQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUN6QixDQUFDO0lBRUQsYUFBYTtRQUNULElBQUksQ0FBQyx1QkFBdUIsR0FBRyxJQUFJLENBQUMsNkJBQTZCLEVBQUUsQ0FBQztRQUNwRSxJQUFJLENBQUMsbUJBQW1CLEdBQUcsSUFBSSxDQUFDLCtCQUErQixFQUFFLENBQUM7UUFFbEUsSUFBSSxJQUFJLENBQUMsdUJBQXVCLEVBQUU7WUFDOUIsSUFBSSxDQUFDLHVCQUF1QixDQUFDLElBQUksRUFBRSxDQUFDO1NBQ3ZDO0lBQ0wsQ0FBQztJQUVTLFlBQVksQ0FBQyxXQUFXO1FBRTlCLElBQUksSUFBSSxDQUFDLGNBQWMsQ0FBQyxXQUFXLENBQUMsS0FBSyxLQUFLLEVBQUU7WUFDNUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxLQUFLLENBQUMsT0FBTyxHQUFHLE9BQU8sQ0FBQztZQUNwQyxJQUFJLENBQUMsY0FBYyxFQUFFLENBQUM7WUFDdEIsSUFBSSxDQUFDLGFBQWEsRUFBRSxDQUFDO1lBQ3JCLE9BQU87U0FDVjtRQUVELE1BQU0sUUFBUSxHQUFHLElBQUksQ0FBQyxjQUFjLENBQUMsZUFBZSxDQUFDLFdBQVcsQ0FBQyxDQUFDO1FBRWxFLElBQUksUUFBUSxLQUFLLGNBQWMsRUFBRTtZQUM3QixJQUFJLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO1lBQ3hDLE9BQU87U0FDVjtRQUVELElBQUksQ0FBQyxNQUFNLENBQUMsR0FBRyxDQUFDLEdBQUcsRUFBRSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsYUFBYSxDQUFDLFFBQVEsQ0FBQyxDQUFDLElBQUksRUFBRSxDQUFDLENBQUMsSUFBSSxFQUFFLENBQUM7SUFDN0UsQ0FBQztJQUVTLFlBQVk7UUFDbEIsc0RBQXNEO1FBQ3RELElBQUksQ0FBQyxNQUFNLENBQUMsYUFBYSxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLFFBQVEsR0FBRyxRQUFRLENBQUM7UUFFbEUsc0JBQXNCO1FBQ3RCLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxDQUFDO1FBRTNDLElBQUksQ0FBQyxzQ0FBc0MsRUFBRSxDQUFDO0lBQ2xELENBQUM7SUFFRCw0RUFBNEU7SUFDNUUsZ0ZBQWdGO0lBQ3RFLHNDQUFzQztRQUM1QyxNQUFNLFNBQVMsR0FBRyxJQUFJLENBQUMsTUFBTSxDQUFDLGFBQWEsQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDO1FBRTFELE1BQU0sR0FBRyxHQUFHLElBQUksR0FBRyxDQUFDLFNBQVMsQ0FBQyxDQUFDO1FBQy9CLE1BQU0sTUFBTSxHQUFHLElBQUksZUFBZSxDQUFDLEdBQUcsQ0FBQyxNQUFNLENBQUMsQ0FBQztRQUUvQyxJQUFJLE1BQU0sQ0FBQyxHQUFHLENBQUMsUUFBUSxDQUFDLEtBQUssZ0JBQWdCLElBQUksTUFBTSxDQUFDLEdBQUcsQ0FBQyxRQUFRLENBQUMsS0FBSyxRQUFRLEVBQUU7WUFDaEYsSUFBSSxDQUFDLElBQUksQ0FBQyxrQkFBa0IsRUFBRSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLEVBQUUsQ0FBQztTQUM1RDtJQUNMLENBQUM7SUFFUyxjQUFjO1FBQ3BCLHVDQUF1QztRQUN2QyxJQUFJLENBQUMsTUFBTSxDQUFDLEtBQUssQ0FBQyxPQUFPLEdBQUcsTUFBTSxDQUFDO1FBQ25DLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxPQUFPLEVBQUUsQ0FBQztJQUN2QyxDQUFDO0lBRVMsNkJBQTZCO1FBQ25DLE9BQU8sSUFBSSx3QkFBd0IsQ0FDL0IsSUFBSSxDQUFDLE1BQU0sRUFDWCxJQUFJLENBQUMsWUFBWSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsRUFDNUIsSUFBSSxDQUFDLFlBQVksQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLEVBQzVCLElBQUksQ0FBQyxjQUFjLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUNqQyxDQUFDO0lBQ04sQ0FBQztJQUVTLCtCQUErQjtRQUNyQyxPQUFPLElBQUksMEJBQTBCLEVBQUUsQ0FBQztJQUM1QyxDQUFDO0lBRUQ7Ozs7O09BS0c7SUFDTyxjQUFjLENBQUMsVUFBa0I7UUFFdkMsSUFBSSxVQUFVLElBQUksVUFBVSxDQUFDLFFBQVEsQ0FBQyxLQUFLLENBQUMsRUFBRTtZQUMxQyxPQUFPLElBQUksQ0FBQztTQUNmO1FBRUQsTUFBTSxTQUFTLEdBQUcsSUFBSSxDQUFDLGNBQWMsQ0FBQyxLQUFLLENBQUMsVUFBVSxDQUFDLENBQUM7UUFFeEQsNENBQTRDO1FBQzVDLElBQUksQ0FBQyxTQUFTLElBQUksQ0FBQyxTQUFTLENBQUMsTUFBTSxFQUFFO1lBQ2pDLE9BQU8sS0FBSyxDQUFDO1NBQ2hCO1FBRUQsTUFBTSxLQUFLLEdBQUcsSUFBSSxDQUFDLGNBQWMsQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsS0FBSyxFQUFFLFNBQVMsQ0FBQyxDQUFDO1FBRTVFLElBQUksS0FBSyxLQUFLLElBQUksRUFBRTtZQUNoQixPQUFPLEtBQUssQ0FBQztTQUNoQjtRQUVELElBQUksQ0FBQyxTQUFTLENBQUMsTUFBTSxFQUFFO1lBQ25CLE9BQU8sSUFBSSxDQUFDO1NBQ2Y7UUFFRCxPQUFPLElBQUksQ0FBQyxTQUFTLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDckMsQ0FBQztJQUVEOzs7OztPQUtHO0lBQ08sU0FBUyxDQUFDLFNBQW9CO1FBQ3BDLE1BQU0sVUFBVSxHQUFzQixJQUFJLENBQUMsYUFBYSxDQUFDLGNBQWMsQ0FBQyxnQ0FBZ0MsQ0FBQyxDQUFDO1FBRTFHLElBQUksQ0FBQyxVQUFVLElBQUksTUFBTSxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsQ0FBQyxNQUFNLEtBQUssQ0FBQyxFQUFFO1lBQ3JELE9BQU8sSUFBSSxDQUFDO1NBQ2Y7UUFFRCx3REFBd0Q7UUFDeEQsSUFBSSxVQUFVLENBQUMsR0FBRyxJQUFJLFVBQVUsQ0FBQyxHQUFHLENBQUMsUUFBUSxDQUFDLFNBQVMsQ0FBQyxNQUFNLENBQUMsRUFBRTtZQUM3RCxPQUFPLEtBQUssQ0FBQztTQUNoQjtRQUVELElBQUksQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDLE1BQU0sQ0FBQyxFQUFFO1lBQy9CLE9BQU8sSUFBSSxDQUFDO1NBQ2Y7UUFFRCxnREFBZ0Q7UUFDaEQsTUFBTSxnQkFBZ0IsR0FBRyxVQUFVLENBQUMsU0FBUyxDQUFDLE1BQU0sQ0FBQyxDQUFDO1FBQ3RELE9BQU8sQ0FBQyxDQUFDLGdCQUFnQixJQUFJLGdCQUFnQixDQUFDLFFBQVEsQ0FBQyxTQUFTLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQztJQUM5RSxDQUFDO3VGQXJNUSxzQkFBc0I7b0VBQXRCLHNCQUFzQjs7Ozs7O1lDbEJuQyxpQ0FBbUQ7WUFDL0MseUJBQWlCO1lBQ3JCLGlCQUFNOzs7U0RnQk8sc0JBQXNCO3VGQUF0QixzQkFBc0I7Y0FMbEMsU0FBUzsyQkFDSSxzQkFBc0I7Nk5BTVksYUFBYTtrQkFBeEQsU0FBUzttQkFBQyxlQUFlLEVBQUUsRUFBQyxNQUFNLEVBQUUsSUFBSSxFQUFDIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBTdWl0ZUNSTSBpcyBhIGN1c3RvbWVyIHJlbGF0aW9uc2hpcCBtYW5hZ2VtZW50IHByb2dyYW0gZGV2ZWxvcGVkIGJ5IFNhbGVzQWdpbGl0eSBMdGQuXG4gKiBDb3B5cmlnaHQgKEMpIDIwMjEgU2FsZXNBZ2lsaXR5IEx0ZC5cbiAqXG4gKiBUaGlzIHByb2dyYW0gaXMgZnJlZSBzb2Z0d2FyZTsgeW91IGNhbiByZWRpc3RyaWJ1dGUgaXQgYW5kL29yIG1vZGlmeSBpdCB1bmRlclxuICogdGhlIHRlcm1zIG9mIHRoZSBHTlUgQWZmZXJvIEdlbmVyYWwgUHVibGljIExpY2Vuc2UgdmVyc2lvbiAzIGFzIHB1Ymxpc2hlZCBieSB0aGVcbiAqIEZyZWUgU29mdHdhcmUgRm91bmRhdGlvbiB3aXRoIHRoZSBhZGRpdGlvbiBvZiB0aGUgZm9sbG93aW5nIHBlcm1pc3Npb24gYWRkZWRcbiAqIHRvIFNlY3Rpb24gMTUgYXMgcGVybWl0dGVkIGluIFNlY3Rpb24gNyhhKTogRk9SIEFOWSBQQVJUIE9GIFRIRSBDT1ZFUkVEIFdPUktcbiAqIElOIFdISUNIIFRIRSBDT1BZUklHSFQgSVMgT1dORUQgQlkgU0FMRVNBR0lMSVRZLCBTQUxFU0FHSUxJVFkgRElTQ0xBSU1TIFRIRVxuICogV0FSUkFOVFkgT0YgTk9OIElORlJJTkdFTUVOVCBPRiBUSElSRCBQQVJUWSBSSUdIVFMuXG4gKlxuICogVGhpcyBwcm9ncmFtIGlzIGRpc3RyaWJ1dGVkIGluIHRoZSBob3BlIHRoYXQgaXQgd2lsbCBiZSB1c2VmdWwsIGJ1dCBXSVRIT1VUXG4gKiBBTlkgV0FSUkFOVFk7IHdpdGhvdXQgZXZlbiB0aGUgaW1wbGllZCB3YXJyYW50eSBvZiBNRVJDSEFOVEFCSUxJVFkgb3IgRklUTkVTU1xuICogRk9SIEEgUEFSVElDVUxBUiBQVVJQT1NFLiBTZWUgdGhlIEdOVSBBZmZlcm8gR2VuZXJhbCBQdWJsaWMgTGljZW5zZSBmb3IgbW9yZVxuICogZGV0YWlscy5cbiAqXG4gKiBZb3Ugc2hvdWxkIGhhdmUgcmVjZWl2ZWQgYSBjb3B5IG9mIHRoZSBHTlUgQWZmZXJvIEdlbmVyYWwgUHVibGljIExpY2Vuc2VcbiAqIGFsb25nIHdpdGggdGhpcyBwcm9ncmFtLiAgSWYgbm90LCBzZWUgPGh0dHA6Ly93d3cuZ251Lm9yZy9saWNlbnNlcy8+LlxuICpcbiAqIEluIGFjY29yZGFuY2Ugd2l0aCBTZWN0aW9uIDcoYikgb2YgdGhlIEdOVSBBZmZlcm8gR2VuZXJhbCBQdWJsaWMgTGljZW5zZVxuICogdmVyc2lvbiAzLCB0aGVzZSBBcHByb3ByaWF0ZSBMZWdhbCBOb3RpY2VzIG11c3QgcmV0YWluIHRoZSBkaXNwbGF5IG9mIHRoZVxuICogXCJTdXBlcmNoYXJnZWQgYnkgU3VpdGVDUk1cIiBsb2dvLiBJZiB0aGUgZGlzcGxheSBvZiB0aGUgbG9nb3MgaXMgbm90IHJlYXNvbmFibHlcbiAqIGZlYXNpYmxlIGZvciB0ZWNobmljYWwgcmVhc29ucywgdGhlIEFwcHJvcHJpYXRlIExlZ2FsIE5vdGljZXMgbXVzdCBkaXNwbGF5XG4gKiB0aGUgd29yZHMgXCJTdXBlcmNoYXJnZWQgYnkgU3VpdGVDUk1cIi5cbiAqL1xuXG5pbXBvcnQge0FmdGVyVmlld0luaXQsIENvbXBvbmVudCwgRWxlbWVudFJlZiwgTmdab25lLCBPbkRlc3Ryb3ksIE9uSW5pdCwgVmlld0NoaWxkfSBmcm9tICdAYW5ndWxhci9jb3JlJztcbmltcG9ydCB7QWN0aXZhdGVkUm91dGUsIFJvdXRlcn0gZnJvbSAnQGFuZ3VsYXIvcm91dGVyJztcbmltcG9ydCB7RG9tU2FuaXRpemVyfSBmcm9tICdAYW5ndWxhci9wbGF0Zm9ybS1icm93c2VyJztcbmltcG9ydCB7SWZyYW1lUmVzaXplSGFuZGxlckhhbmRsZXJ9IGZyb20gJy4uLy4uL3NlcnZpY2VzL2lmcmFtZS1yZXNpemUtaGFuZGxlci5zZXJ2aWNlJztcbmltcG9ydCB7U3lzdGVtQ29uZmlnU3RvcmV9IGZyb20gJy4uLy4uLy4uLy4uL3N0b3JlL3N5c3RlbS1jb25maWcvc3lzdGVtLWNvbmZpZy5zdG9yZSc7XG5pbXBvcnQge0F1dGhTZXJ2aWNlfSBmcm9tICcuLi8uLi8uLi8uLi9zZXJ2aWNlcy9hdXRoL2F1dGguc2VydmljZSc7XG5pbXBvcnQge1JvdXRlQ29udmVydGVyLCBSb3V0ZUluZm99IGZyb20gJy4uLy4uLy4uLy4uL3NlcnZpY2VzL25hdmlnYXRpb24vcm91dGUtY29udmVydGVyL3JvdXRlLWNvbnZlcnRlci5zZXJ2aWNlJztcbmltcG9ydCB7SWZyYW1lUGFnZUNoYW5nZU9ic2VydmVyfSBmcm9tICcuLi8uLi9zZXJ2aWNlcy9pZnJhbWUtcGFnZS1jaGFuZ2Utb2JzZXJ2ZXIuc2VydmljZSc7XG5pbXBvcnQge3Rha2V9IGZyb20gXCJyeGpzL29wZXJhdG9yc1wiO1xuXG5pbnRlcmZhY2UgUm91dGluZ0V4Y2x1c2lvbnMge1xuICAgIFtrZXk6IHN0cmluZ106IHN0cmluZ1tdO1xufVxuXG5AQ29tcG9uZW50KHtcbiAgICBzZWxlY3RvcjogJ3Njcm0tY2xhc3NpYy12aWV3LXVpJyxcbiAgICB0ZW1wbGF0ZVVybDogJy4vY2xhc3NpYy12aWV3LmNvbXBvbmVudC5odG1sJyxcbiAgICBzdHlsZVVybHM6IFtdXG59KVxuZXhwb3J0IGNsYXNzIENsYXNzaWNWaWV3VWlDb21wb25lbnQgaW1wbGVtZW50cyBPbkluaXQsIE9uRGVzdHJveSwgQWZ0ZXJWaWV3SW5pdCB7XG5cbiAgICBAVmlld0NoaWxkKCdkYXRhQ29udGFpbmVyJywge3N0YXRpYzogdHJ1ZX0pIGRhdGFDb250YWluZXI6IEVsZW1lbnRSZWY7XG4gICAgcHVibGljIHdyYXBwZXI6IGFueTtcbiAgICBwdWJsaWMgdXJsOiBzdHJpbmc7XG4gICAgcHJvdGVjdGVkIGlmcmFtZSA9IG51bGw7XG4gICAgcHJpdmF0ZSBpZnJhbWVQYWdlQ2hhbmdlSGFuZGxlcjogSWZyYW1lUGFnZUNoYW5nZU9ic2VydmVyO1xuICAgIHByaXZhdGUgaWZyYW1lUmVzaXplSGFuZGxlcjogSWZyYW1lUmVzaXplSGFuZGxlckhhbmRsZXI7XG5cbiAgICBjb25zdHJ1Y3RvcihcbiAgICAgICAgcHJpdmF0ZSByb3V0ZTogQWN0aXZhdGVkUm91dGUsXG4gICAgICAgIHByaXZhdGUgcm91dGVyOiBSb3V0ZXIsXG4gICAgICAgIHByaXZhdGUgc2FuaXRpemVyOiBEb21TYW5pdGl6ZXIsXG4gICAgICAgIHByaXZhdGUgcm91dGVDb252ZXJ0ZXI6IFJvdXRlQ29udmVydGVyLFxuICAgICAgICBwcml2YXRlIGF1dGg6IEF1dGhTZXJ2aWNlLFxuICAgICAgICBwcml2YXRlIG5nWm9uZTogTmdab25lLFxuICAgICAgICBwcml2YXRlIHN5c3RlbUNvbmZpZ3M6IFN5c3RlbUNvbmZpZ1N0b3JlLFxuICAgICkge1xuICAgIH1cblxuICAgIG5nT25Jbml0KCk6IHZvaWQge1xuICAgICAgICB0aGlzLnVybCA9IHRoaXMucm91dGUuc25hcHNob3QuZGF0YS5sZWdhY3lVcmw7XG4gICAgfVxuXG4gICAgbmdBZnRlclZpZXdJbml0KCk6IHZvaWQge1xuICAgICAgICB0aGlzLmluaXRJZnJhbWUoKTtcbiAgICB9XG5cbiAgICBuZ09uRGVzdHJveSgpOiB2b2lkIHtcbiAgICAgICAgdGhpcy5jbGVhbk9ic2VydmVycygpO1xuXG4gICAgICAgIHRoaXMuaWZyYW1lID0gbnVsbDtcbiAgICAgICAgY29uc3QgcGxhY2Vob2xkZXIgPSB0aGlzLndyYXBwZXI7XG4gICAgICAgIGlmICh0aGlzLndyYXBwZXIuZmlyc3RDaGlsZCkge1xuICAgICAgICAgICAgcGxhY2Vob2xkZXIucmVtb3ZlQ2hpbGQocGxhY2Vob2xkZXIuZmlyc3RDaGlsZCk7XG4gICAgICAgIH1cbiAgICAgICAgcGxhY2Vob2xkZXIuaW5uZXJIVE1MID0gJzxpZnJhbWU+PC9pZnJhbWU+JztcbiAgICAgICAgdGhpcy53cmFwcGVyID0gbnVsbDtcbiAgICB9XG5cbiAgICBjbGVhbk9ic2VydmVycygpOiB2b2lkIHtcbiAgICAgICAgaWYgKHRoaXMuaWZyYW1lUmVzaXplSGFuZGxlcikge1xuICAgICAgICAgICAgdGhpcy5pZnJhbWVSZXNpemVIYW5kbGVyLmRlc3Ryb3koKTtcbiAgICAgICAgICAgIHRoaXMuaWZyYW1lUmVzaXplSGFuZGxlciA9IG51bGw7XG5cbiAgICAgICAgfVxuICAgICAgICBpZiAodGhpcy5pZnJhbWVQYWdlQ2hhbmdlSGFuZGxlcikge1xuICAgICAgICAgICAgdGhpcy5pZnJhbWVQYWdlQ2hhbmdlSGFuZGxlci5kZXN0cm95KCk7XG4gICAgICAgICAgICB0aGlzLmlmcmFtZVBhZ2VDaGFuZ2VIYW5kbGVyID0gbnVsbDtcbiAgICAgICAgfVxuICAgIH1cblxuICAgIGluaXRJZnJhbWUoKTogdm9pZCB7XG4gICAgICAgIHRoaXMud3JhcHBlciA9IHRoaXMuZGF0YUNvbnRhaW5lci5uYXRpdmVFbGVtZW50O1xuXG4gICAgICAgIGlmICh0aGlzLndyYXBwZXIuZmlyc3RDaGlsZCkge1xuICAgICAgICAgICAgdGhpcy53cmFwcGVyLnJlbW92ZUNoaWxkKHRoaXMud3JhcHBlci5maXJzdENoaWxkKTtcbiAgICAgICAgfVxuICAgICAgICBjb25zdCBpZnJhbWUgPSBkb2N1bWVudC5jcmVhdGVFbGVtZW50KCdpZnJhbWUnKTtcbiAgICAgICAgaWZyYW1lLnNyYyA9IHRoaXMudXJsO1xuXG4gICAgICAgIHRoaXMud3JhcHBlci5hcHBlbmRDaGlsZChpZnJhbWUpO1xuXG4gICAgICAgIHRoaXMuaWZyYW1lID0gaWZyYW1lO1xuXG4gICAgICAgIHRoaXMuaWZyYW1lLnN0eWxlLmRpc3BsYXkgPSAnYmxvY2snO1xuXG4gICAgICAgIHRoaXMuaW5pdE9ic2VydmVycygpO1xuICAgIH1cblxuICAgIGluaXRPYnNlcnZlcnMoKTogdm9pZCB7XG4gICAgICAgIHRoaXMuaWZyYW1lUGFnZUNoYW5nZUhhbmRsZXIgPSB0aGlzLmJ1aWxkSWZyYW1lUGFnZUNoYW5nZU9ic2VydmVyKCk7XG4gICAgICAgIHRoaXMuaWZyYW1lUmVzaXplSGFuZGxlciA9IHRoaXMuYnVpbGRJZnJhbWVSZXNpemVIYW5kbGVySGFuZGxlcigpO1xuXG4gICAgICAgIGlmICh0aGlzLmlmcmFtZVBhZ2VDaGFuZ2VIYW5kbGVyKSB7XG4gICAgICAgICAgICB0aGlzLmlmcmFtZVBhZ2VDaGFuZ2VIYW5kbGVyLmluaXQoKTtcbiAgICAgICAgfVxuICAgIH1cblxuICAgIHByb3RlY3RlZCBvblBhZ2VDaGFuZ2UobmV3TG9jYXRpb24pOiB2b2lkIHtcblxuICAgICAgICBpZiAodGhpcy5zaG91bGRSZWRpcmVjdChuZXdMb2NhdGlvbikgPT09IGZhbHNlKSB7XG4gICAgICAgICAgICB0aGlzLmlmcmFtZS5zdHlsZS5kaXNwbGF5ID0gJ2Jsb2NrJztcbiAgICAgICAgICAgIHRoaXMuY2xlYW5PYnNlcnZlcnMoKTtcbiAgICAgICAgICAgIHRoaXMuaW5pdE9ic2VydmVycygpO1xuICAgICAgICAgICAgcmV0dXJuO1xuICAgICAgICB9XG5cbiAgICAgICAgY29uc3QgbG9jYXRpb24gPSB0aGlzLnJvdXRlQ29udmVydGVyLnRvRnJvbnRFbmRSb3V0ZShuZXdMb2NhdGlvbik7XG5cbiAgICAgICAgaWYgKGxvY2F0aW9uID09PSAnL3VzZXJzL2xvZ2luJykge1xuICAgICAgICAgICAgdGhpcy5hdXRoLmxvZ291dCgnTEJMX1NFU1NJT05fRVhQSVJFRCcpO1xuICAgICAgICAgICAgcmV0dXJuO1xuICAgICAgICB9XG5cbiAgICAgICAgdGhpcy5uZ1pvbmUucnVuKCgpID0+IHRoaXMucm91dGVyLm5hdmlnYXRlQnlVcmwobG9jYXRpb24pLnRoZW4oKSkudGhlbigpO1xuICAgIH1cblxuICAgIHByb3RlY3RlZCBvbklGcmFtZUxvYWQoKTogdm9pZCB7XG4gICAgICAgIC8vIERvIG5vdCBzaG93IHNjcm9sbCBhdCBhbnkgdGltZSwgdG8gYXZvaWQgZmxpY2tlcmluZ1xuICAgICAgICB0aGlzLmlmcmFtZS5jb250ZW50V2luZG93LmRvY3VtZW50LmJvZHkuc3R5bGUub3ZlcmZsb3cgPSAnaGlkZGVuJztcblxuICAgICAgICAvLyBJbml0IHJlc2l6ZSBoYW5kbGVyXG4gICAgICAgIHRoaXMuaWZyYW1lUmVzaXplSGFuZGxlci5pbml0KHRoaXMuaWZyYW1lKTtcblxuICAgICAgICB0aGlzLmZvcmNlQ2FjaGVSZWJ1aWxkQWZ0ZXJSZXBhaXJBbmRSZWJ1aWxkKCk7XG4gICAgfVxuXG4gICAgLy8gVGVtcG9yYXJ5IHNvbHV0aW9uLiBGb3JjZSBhIGNhY2hlIHJlYnVpbGQgYWZ0ZXIgcXVpY2sgcmVwYWlyIGFuZCByZWJ1aWxkLlxuICAgIC8vIENhbiBiZSByZW1vdmVkIGFmdGVyIFJlcGFpciBhbmQgUmVidWlsZCBwYWdlIGlzIHJlLWRvbmUgd2l0aCB0byBTdWl0ZTggdmlld3MuXG4gICAgcHJvdGVjdGVkIGZvcmNlQ2FjaGVSZWJ1aWxkQWZ0ZXJSZXBhaXJBbmRSZWJ1aWxkKCk6IHZvaWQge1xuICAgICAgICBjb25zdCBpZnJhbWVVcmwgPSB0aGlzLmlmcmFtZS5jb250ZW50V2luZG93LmxvY2F0aW9uLmhyZWY7XG5cbiAgICAgICAgY29uc3QgdXJsID0gbmV3IFVSTChpZnJhbWVVcmwpO1xuICAgICAgICBjb25zdCBwYXJhbXMgPSBuZXcgVVJMU2VhcmNoUGFyYW1zKHVybC5zZWFyY2gpO1xuXG4gICAgICAgIGlmIChwYXJhbXMuZ2V0KCdtb2R1bGUnKSA9PT0gJ0FkbWluaXN0cmF0aW9uJyAmJiBwYXJhbXMuZ2V0KCdhY3Rpb24nKSA9PT0gJ3JlcGFpcicpIHtcbiAgICAgICAgICAgIHRoaXMuYXV0aC5mZXRjaFNlc3Npb25TdGF0dXMoKS5waXBlKHRha2UoMSkpLnN1YnNjcmliZSgpO1xuICAgICAgICB9XG4gICAgfVxuXG4gICAgcHJvdGVjdGVkIG9uSUZyYW1lVW5sb2FkKCk6IHZvaWQge1xuICAgICAgICAvLyBoaWRlIGlmcmFtZSwgd2hpbGUgYmVpbmcgcmUtZGlyZWN0ZWRcbiAgICAgICAgdGhpcy5pZnJhbWUuc3R5bGUuZGlzcGxheSA9ICdub25lJztcbiAgICAgICAgdGhpcy5pZnJhbWVSZXNpemVIYW5kbGVyLmRlc3Ryb3koKTtcbiAgICB9XG5cbiAgICBwcm90ZWN0ZWQgYnVpbGRJZnJhbWVQYWdlQ2hhbmdlT2JzZXJ2ZXIoKTogSWZyYW1lUGFnZUNoYW5nZU9ic2VydmVyIHtcbiAgICAgICAgcmV0dXJuIG5ldyBJZnJhbWVQYWdlQ2hhbmdlT2JzZXJ2ZXIoXG4gICAgICAgICAgICB0aGlzLmlmcmFtZSxcbiAgICAgICAgICAgIHRoaXMub25QYWdlQ2hhbmdlLmJpbmQodGhpcyksXG4gICAgICAgICAgICB0aGlzLm9uSUZyYW1lTG9hZC5iaW5kKHRoaXMpLFxuICAgICAgICAgICAgdGhpcy5vbklGcmFtZVVubG9hZC5iaW5kKHRoaXMpLFxuICAgICAgICApO1xuICAgIH1cblxuICAgIHByb3RlY3RlZCBidWlsZElmcmFtZVJlc2l6ZUhhbmRsZXJIYW5kbGVyKCk6IElmcmFtZVJlc2l6ZUhhbmRsZXJIYW5kbGVyIHtcbiAgICAgICAgcmV0dXJuIG5ldyBJZnJhbWVSZXNpemVIYW5kbGVySGFuZGxlcigpO1xuICAgIH1cblxuICAgIC8qKlxuICAgICAqIENoZWNrIGlmIHNob3VsZCByZS1kaXJlY3QgdG8gbGluayBvciBpZiBpdCB3YXMgZXhjbHVkZWRcbiAgICAgKlxuICAgICAqIEBwYXJhbSB7c3RyaW5nfSBsZWdhY3lMaW5rIHRvIGNoZWNrXG4gICAgICogQHJldHVybnMge2Jvb2xlYW59IHNob3VsZCByZWRpcmVjdFxuICAgICAqL1xuICAgIHByb3RlY3RlZCBzaG91bGRSZWRpcmVjdChsZWdhY3lMaW5rOiBzdHJpbmcpOiBib29sZWFuIHtcblxuICAgICAgICBpZiAobGVnYWN5TGluayAmJiBsZWdhY3lMaW5rLmluY2x1ZGVzKCcvIy8nKSkge1xuICAgICAgICAgICAgcmV0dXJuIHRydWU7XG4gICAgICAgIH1cblxuICAgICAgICBjb25zdCByb3V0ZUluZm8gPSB0aGlzLnJvdXRlQ29udmVydGVyLnBhcnNlKGxlZ2FjeUxpbmspO1xuXG4gICAgICAgIC8vIGlmIG5vIHJvdXRlIG9yIG5vIG1vZHVsZSwgZG9uJ3QgcmUtZGlyZWN0XG4gICAgICAgIGlmICghcm91dGVJbmZvIHx8ICFyb3V0ZUluZm8ubW9kdWxlKSB7XG4gICAgICAgICAgICByZXR1cm4gZmFsc2U7XG4gICAgICAgIH1cblxuICAgICAgICBjb25zdCByZXVzZSA9IHRoaXMucm91dGVDb252ZXJ0ZXIubWF0Y2hlc0FjdGl2ZVJvdXRlKHRoaXMucm91dGUsIHJvdXRlSW5mbyk7XG5cbiAgICAgICAgaWYgKHJldXNlID09PSB0cnVlKSB7XG4gICAgICAgICAgICByZXR1cm4gZmFsc2U7XG4gICAgICAgIH1cblxuICAgICAgICBpZiAoIXJvdXRlSW5mby5hY3Rpb24pIHtcbiAgICAgICAgICAgIHJldHVybiB0cnVlO1xuICAgICAgICB9XG5cbiAgICAgICAgcmV0dXJuIHRoaXMudG9FeGNsdWRlKHJvdXRlSW5mbyk7XG4gICAgfVxuXG4gICAgLyoqXG4gICAgICogQ2hlY2sgaWYgZ2l2ZW4gcm91dGUgaXMgdG8gZXhjbHVkZSBmcm9tIHJlZGlyZWN0aW9uXG4gICAgICpcbiAgICAgKiBAcGFyYW0ge29iamVjdH0gcm91dGVJbmZvIHRvIGNoZWNrXG4gICAgICogQHJldHVybnMge2Jvb2xlYW59IGlzIHRvIGV4Y2x1ZGVcbiAgICAgKi9cbiAgICBwcm90ZWN0ZWQgdG9FeGNsdWRlKHJvdXRlSW5mbzogUm91dGVJbmZvKTogYm9vbGVhbiB7XG4gICAgICAgIGNvbnN0IGV4Y2x1c2lvbnM6IFJvdXRpbmdFeGNsdXNpb25zID0gdGhpcy5zeXN0ZW1Db25maWdzLmdldENvbmZpZ1ZhbHVlKCdjbGFzc2ljdmlld19yb3V0aW5nX2V4Y2x1c2lvbnMnKTtcblxuICAgICAgICBpZiAoIWV4Y2x1c2lvbnMgfHwgT2JqZWN0LmtleXMoZXhjbHVzaW9ucykubGVuZ3RoID09PSAwKSB7XG4gICAgICAgICAgICByZXR1cm4gdHJ1ZTtcbiAgICAgICAgfVxuXG4gICAgICAgIC8vIGlmIGFjdGlvbiBpcyBleGNsdWRlZCBmb3IgYW55IG1vZHVsZSwgZG9uJ3QgcmUtZGlyZWN0XG4gICAgICAgIGlmIChleGNsdXNpb25zLmFueSAmJiBleGNsdXNpb25zLmFueS5pbmNsdWRlcyhyb3V0ZUluZm8uYWN0aW9uKSkge1xuICAgICAgICAgICAgcmV0dXJuIGZhbHNlO1xuICAgICAgICB9XG5cbiAgICAgICAgaWYgKCFleGNsdXNpb25zW3JvdXRlSW5mby5tb2R1bGVdKSB7XG4gICAgICAgICAgICByZXR1cm4gdHJ1ZTtcbiAgICAgICAgfVxuXG4gICAgICAgIC8vIGlmIG1vZHVsZSBhY3Rpb24gaXMgZXhjbHVkZWQsIGRvbid0IHJlLWRpcmVjdFxuICAgICAgICBjb25zdCBtb2R1bGVFeGNsdXNpb25zID0gZXhjbHVzaW9uc1tyb3V0ZUluZm8ubW9kdWxlXTtcbiAgICAgICAgcmV0dXJuICEobW9kdWxlRXhjbHVzaW9ucyAmJiBtb2R1bGVFeGNsdXNpb25zLmluY2x1ZGVzKHJvdXRlSW5mby5hY3Rpb24pKTtcbiAgICB9XG59XG4iLCI8ISAtLVxuLyoqXG4qIFN1aXRlQ1JNIGlzIGEgY3VzdG9tZXIgcmVsYXRpb25zaGlwIG1hbmFnZW1lbnQgcHJvZ3JhbSBkZXZlbG9wZWQgYnkgU2FsZXNBZ2lsaXR5IEx0ZC5cbiogQ29weXJpZ2h0IChDKSAyMDIxIFNhbGVzQWdpbGl0eSBMdGQuXG4qXG4qIFRoaXMgcHJvZ3JhbSBpcyBmcmVlIHNvZnR3YXJlOyB5b3UgY2FuIHJlZGlzdHJpYnV0ZSBpdCBhbmQvb3IgbW9kaWZ5IGl0IHVuZGVyXG4qIHRoZSB0ZXJtcyBvZiB0aGUgR05VIEFmZmVybyBHZW5lcmFsIFB1YmxpYyBMaWNlbnNlIHZlcnNpb24gMyBhcyBwdWJsaXNoZWQgYnkgdGhlXG4qIEZyZWUgU29mdHdhcmUgRm91bmRhdGlvbiB3aXRoIHRoZSBhZGRpdGlvbiBvZiB0aGUgZm9sbG93aW5nIHBlcm1pc3Npb24gYWRkZWRcbiogdG8gU2VjdGlvbiAxNSBhcyBwZXJtaXR0ZWQgaW4gU2VjdGlvbiA3KGEpOiBGT1IgQU5ZIFBBUlQgT0YgVEhFIENPVkVSRUQgV09SS1xuKiBJTiBXSElDSCBUSEUgQ09QWVJJR0hUIElTIE9XTkVEIEJZIFNBTEVTQUdJTElUWSwgU0FMRVNBR0lMSVRZIERJU0NMQUlNUyBUSEVcbiogV0FSUkFOVFkgT0YgTk9OIElORlJJTkdFTUVOVCBPRiBUSElSRCBQQVJUWSBSSUdIVFMuXG4qXG4qIFRoaXMgcHJvZ3JhbSBpcyBkaXN0cmlidXRlZCBpbiB0aGUgaG9wZSB0aGF0IGl0IHdpbGwgYmUgdXNlZnVsLCBidXQgV0lUSE9VVFxuKiBBTlkgV0FSUkFOVFk7IHdpdGhvdXQgZXZlbiB0aGUgaW1wbGllZCB3YXJyYW50eSBvZiBNRVJDSEFOVEFCSUxJVFkgb3IgRklUTkVTU1xuKiBGT1IgQSBQQVJUSUNVTEFSIFBVUlBPU0UuIFNlZSB0aGUgR05VIEFmZmVybyBHZW5lcmFsIFB1YmxpYyBMaWNlbnNlIGZvciBtb3JlXG4qIGRldGFpbHMuXG4qXG4qIFlvdSBzaG91bGQgaGF2ZSByZWNlaXZlZCBhIGNvcHkgb2YgdGhlIEdOVSBBZmZlcm8gR2VuZXJhbCBQdWJsaWMgTGljZW5zZVxuKiBhbG9uZyB3aXRoIHRoaXMgcHJvZ3JhbS4gIElmIG5vdCwgc2VlIGh0dHA6Ly93d3cuZ251Lm9yZy9saWNlbnNlcy5cbipcbiogSW4gYWNjb3JkYW5jZSB3aXRoIFNlY3Rpb24gNyhiKSBvZiB0aGUgR05VIEFmZmVybyBHZW5lcmFsIFB1YmxpYyBMaWNlbnNlXG4qIHZlcnNpb24gMywgdGhlc2UgQXBwcm9wcmlhdGUgTGVnYWwgTm90aWNlcyBtdXN0IHJldGFpbiB0aGUgZGlzcGxheSBvZiB0aGVcbiogXCJTdXBlcmNoYXJnZWQgYnkgU3VpdGVDUk1cIiBsb2dvLiBJZiB0aGUgZGlzcGxheSBvZiB0aGUgbG9nb3MgaXMgbm90IHJlYXNvbmFibHlcbiogZmVhc2libGUgZm9yIHRlY2huaWNhbCByZWFzb25zLCB0aGUgQXBwcm9wcmlhdGUgTGVnYWwgTm90aWNlcyBtdXN0IGRpc3BsYXlcbiogdGhlIHdvcmRzIFwiU3VwZXJjaGFyZ2VkIGJ5IFN1aXRlQ1JNXCIuXG4qL1xuLS0+XG48ZGl2IGNsYXNzPVwiY2xhc3NpYy12aWV3LWNvbnRhaW5lclwiICNkYXRhQ29udGFpbmVyPlxuICAgIDxpZnJhbWU+PC9pZnJhbWU+XG48L2Rpdj5cbiJdfQ==