/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
import { Component } from "@angular/core";
import { ListViewStore, } from "../../store/list-view/list-view.store";
import { AppStateStore } from "../../../../store/app-state/app-state.store";
import { QuickFiltersService } from "../../services/quick-filters.service";
import { ListViewSidebarWidgetService } from "../../services/list-view-sidebar-widget.service";
import { RecordPaginationService } from "../../../record/store/record-pagination/record-pagination.service";
import * as i0 from "@angular/core";
import * as i1 from "../../../../store/app-state/app-state.store";
import * as i2 from "../../store/list-view/list-view.store";
import * as i3 from "../../services/quick-filters.service";
import * as i4 from "../../services/list-view-sidebar-widget.service";
import * as i5 from "../../../record/store/record-pagination/record-pagination.service";
import * as i6 from "@angular/common";
import * as i7 from "../list-header/list-header.component";
import * as i8 from "../list-container/list-container.component";
function ListComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 1);
    i0.ɵɵelement(1, "scrm-list-header")(2, "scrm-list-container");
    i0.ɵɵelementEnd();
} }
class ListComponent {
    constructor(appState, listStore, quickFilters, sidebarWidgetHandler, recordPaginationService) {
        this.appState = appState;
        this.listStore = listStore;
        this.quickFilters = quickFilters;
        this.sidebarWidgetHandler = sidebarWidgetHandler;
        this.recordPaginationService = recordPaginationService;
        this.vm$ = null;
        this.TAG_COLORS_LIST = {};
        this.CALL_STATUS_STYLES = {};
    }
    ngOnInit() {
        console.log("List component init");
        this.appState.removeAllPrevRoutes();
        this.module = this.appState.getModule();
        this.listSub = this.listStore.init(this.module).subscribe();
        this.vm$ = this.listStore.vm$;
        this.vm$.subscribe(() => {
            // Wait for DOM to render
            setTimeout(() => {
                this.injectListTagColors();
                this.injectCallStatusDotList();
            }, 300);
        });
    }
    ngAfterViewInit() {
        console.log("list.component.ts ngAfterViewInit");
        // Load colors first, then apply
        this.loadColors().then(() => {
            setTimeout(() => {
                this.injectListTagColors();
                this.injectCallStatusDotList();
            }, 500);
        });
        // // Watch for DOM changes
        // const listTable =
        //   document.querySelector(".list-view-table") || document.body;
        // const observer = new MutationObserver(() => {
        //   console.log("[MutationObserver] Detected DOM changes in ListView");
        //   this.injectListTagColors();
        //   this.injectCallStatusDotList();
        // });
        // observer.observe(listTable, { childList: true, subtree: true });
    }
    ngOnDestroy() {
        if (this.listSub) {
            this.listSub.unsubscribe();
        }
        this.updateListLocalStorage();
        this.quickFilters.destroy();
        this.sidebarWidgetHandler.destroy();
        this.listStore.destroy();
    }
    updateListLocalStorage() {
        this.recordPaginationService.updateRecordListLocalStorage(this.listStore.recordList.records, this.listStore.recordList.pagination);
    }
    injectCallStatusDotList() {
        let attempts = 0;
        const interval = setInterval(() => {
            console.log(`[CallStatus][ListView] Attempt ${attempts + 1}...`);
            const callStatusEls = document.querySelectorAll(".field-name-call_status_c scrm-dropdownenum-detail");
            if (callStatusEls.length > 0 || attempts > 10) {
                clearInterval(interval);
                if (callStatusEls.length === 0) {
                    console.warn("[CallStatus][ListView] No elements found after max attempts.");
                    return;
                }
                console.log(`[CallStatus][ListView] Found ${callStatusEls.length} elements.`);
                callStatusEls.forEach((el, index) => {
                    const rawText = el.textContent?.trim() || "";
                    const cleanVal = rawText.toLowerCase().replace(/\s+/g, "");
                    const styleInfo = this.CALL_STATUS_STYLES[cleanVal];
                    console.log(`[CallStatus][ListView][${index}] Raw: "${rawText}", Clean: "${cleanVal}"`);
                    if (styleInfo) {
                        const spanExists = el.querySelector(".call-status-pill");
                        if (!spanExists) {
                            console.log(`[CallStatus][ListView][${index}] Applying color: ${styleInfo.color}`);
                            el.innerHTML = `<span class="call-status-pill">${styleInfo.emoji} ${rawText}</span>`;
                            const span = el.querySelector(".call-status-pill");
                            if (span) {
                                span.style.backgroundColor = styleInfo.color;
                                span.style.color = "#fff";
                                span.style.padding = "2px 10px";
                                span.style.borderRadius = "20px";
                                span.style.fontWeight = "600";
                                span.style.display = "inline-block";
                                span.style.textTransform = "uppercase";
                                span.style.fontSize = "12px";
                                span.style.letterSpacing = "0.5px";
                            }
                        }
                        else {
                            console.log(`[CallStatus][ListView][${index}] Already styled, skipping.`);
                        }
                    }
                    else {
                        console.warn(`[CallStatus][ListView][${index}] No matching style for value: "${cleanVal}"`);
                    }
                });
            }
            attempts++;
        }, 300);
    }
    injectListTagColors() {
        const interval = setInterval(() => {
            const tagLists = document.querySelectorAll(".field-name-tag_c scrm-multienum-detail li");
            if (tagLists.length > 0) {
                clearInterval(interval);
                tagLists.forEach((el) => {
                    const label = el.textContent?.trim().toLowerCase();
                    this.applyFlatTagStyleList(el, label);
                });
            }
        }, 300);
    }
    async loadColors() {
        try {
            const basePath = window.location.pathname.split("/legacy")[0]; // gets "/johncrm"
            const res = await fetch(`${basePath}/legacy/custom/field_colors.php`);
            const data = await res.json();
            this.TAG_COLORS_LIST = data.tagColors;
            this.CALL_STATUS_STYLES = data.callStatus;
        }
        catch (error) {
            console.error("Failed to load color mappings:", error);
        }
    }
    applyFlatTagStyleList(el, label) {
        // const color = this.TAG_COLORS_LIST[label.toLowerCase()];
        const color = this.TAG_COLORS_LIST[label.toLowerCase()];
        if (!color)
            return;
        el.style.backgroundColor = color;
        el.style.color = "white";
        el.style.fontSize = "12px";
        el.style.fontWeight = "bold";
        el.style.padding = "2px 8px";
        el.style.borderRadius = "12px";
        el.style.display = "inline-block";
        el.style.margin = "2px";
    }
    static { this.ɵfac = function ListComponent_Factory(t) { return new (t || ListComponent)(i0.ɵɵdirectiveInject(i1.AppStateStore), i0.ɵɵdirectiveInject(i2.ListViewStore), i0.ɵɵdirectiveInject(i3.QuickFiltersService), i0.ɵɵdirectiveInject(i4.ListViewSidebarWidgetService), i0.ɵɵdirectiveInject(i5.RecordPaginationService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: ListComponent, selectors: [["scrm-list"]], features: [i0.ɵɵProvidersFeature([ListViewStore, QuickFiltersService, ListViewSidebarWidgetService])], decls: 2, vars: 3, consts: [["class", "list-view", 4, "ngIf"], [1, "list-view"]], template: function ListComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, ListComponent_div_0_Template, 3, 0, "div", 0);
            i0.ɵɵpipe(1, "async");
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", i0.ɵɵpipeBind1(1, 1, ctx.vm$));
        } }, dependencies: [i6.NgIf, i7.ListHeaderComponent, i8.ListContainerComponent, i6.AsyncPipe], encapsulation: 2 }); }
}
export { ListComponent };
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ListComponent, [{
        type: Component,
        args: [{ selector: "scrm-list", providers: [ListViewStore, QuickFiltersService, ListViewSidebarWidgetService], template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<!-- Start List View Section -->\n<div class=\"list-view\" *ngIf=\"(vm$ | async) as vm\">\n    <scrm-list-header></scrm-list-header>\n    <scrm-list-container></scrm-list-container>\n</div>\n<!-- End List View Section -->\n" }]
    }], function () { return [{ type: i1.AppStateStore }, { type: i2.ListViewStore }, { type: i3.QuickFiltersService }, { type: i4.ListViewSidebarWidgetService }, { type: i5.RecordPaginationService }]; }, null); })();
//# sourceMappingURL=data:application/json;base64,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