/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
import { Component } from "@angular/core";
import { AppStateStore } from "../../../../store/app-state/app-state.store";
import { RecordViewStore } from "../../store/record-view/record-view.store";
import { ActivatedRoute } from "@angular/router";
import { RecordActionsAdapter } from "../../adapters/actions.adapter";
import { RecordViewSidebarWidgetService } from "../../services/record-view-sidebar-widget.service";
import * as i0 from "@angular/core";
import * as i1 from "../../../../store/app-state/app-state.store";
import * as i2 from "../../store/record-view/record-view.store";
import * as i3 from "@angular/router";
import * as i4 from "../../services/record-view-sidebar-widget.service";
import * as i5 from "@angular/common";
import * as i6 from "../record-container/record-container.component";
import * as i7 from "../record-header/record-header.component";
import * as i8 from "../../../../components/status-bar/status-bar.component";
function RecordComponent_div_0_scrm_status_bar_5_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelement(0, "scrm-status-bar");
} }
function RecordComponent_div_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div", 1)(1, "div", 2);
    i0.ɵɵelement(2, "scrm-record-header");
    i0.ɵɵelementEnd();
    i0.ɵɵelementStart(3, "div", 3);
    i0.ɵɵelement(4, "hr", 4);
    i0.ɵɵelementEnd();
    i0.ɵɵtemplate(5, RecordComponent_div_0_scrm_status_bar_5_Template, 1, 0, "scrm-status-bar", 5);
    i0.ɵɵelement(6, "scrm-record-container");
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵadvance(5);
    i0.ɵɵproperty("ngIf", ctx_r0.showStatusBar);
} }
class RecordComponent {
    constructor(appState, recordStore, route, sidebarWidgetHandler) {
        this.appState = appState;
        this.recordStore = recordStore;
        this.route = route;
        this.sidebarWidgetHandler = sidebarWidgetHandler;
        this.vm$ = null;
        this.showStatusBar = false;
        this.TAG_COLORS = {};
        this.CALL_STATUS_STYLES = {};
    }
    ngOnInit() {
        console.log("[record.component.ts] ngOnInit");
        let mode = "detail";
        this.appState.addToPrevRoute(this.appState.getRouteUrl());
        const data = (this.route.snapshot && this.route.snapshot.data) || {};
        console.log("[record.component.ts] route data:", data);
        if (data.mode) {
            mode = data.mode;
        }
        const params = (this.route.snapshot && this.route.snapshot.queryParams) ||
            {};
        this.recordSub = this.recordStore
            .init(this.appState.getModule(), this.route.snapshot.params.record, mode, params)
            .subscribe();
        this.vm$ = this.recordStore.vm$;
        this.vm$.subscribe((vm) => {
            console.log("[record.component.ts] ViewModel received");
        });
        this.modeSub = this.recordStore.viewMode$.subscribe((mode) => {
            console.log("[record.component.ts] Current view mode is:", mode);
            if (mode === "edit") {
                setTimeout(() => {
                    this.injectCallStatusDot();
                    this.injectEditTagColors();
                }, 300);
            }
            if (mode === "detail") {
                setTimeout(() => {
                    this.injectDetailTagColors();
                    this.injectCallStatusDotDetail();
                }, 300);
            }
        });
        this.loadColors();
    }
    ngAfterViewInit() {
        console.log("[record.component.ts] ngAfterViewInit");
    }
    ngOnDestroy() {
        if (this.recordSub) {
            this.recordSub.unsubscribe();
        }
        if (this.modeSub) {
            this.modeSub.unsubscribe();
        }
        this.sidebarWidgetHandler.destroy();
        this.recordStore.destroy();
    }
    async loadColors() {
        try {
            const basePath = window.location.pathname.split('/legacy')[0];
            const res = await fetch(`${basePath}/legacy/custom/field_colors.php`);
            const data = await res.json();
            this.TAG_COLORS = data.tagColors;
            this.CALL_STATUS_STYLES = data.callStatus;
        }
        catch (error) {
            console.error("[record.component.ts] Failed to load color mappings:", error);
        }
    }
    injectCallStatusDot() {
        let attempts = 0;
        const interval = setInterval(() => {
            const container = document.querySelector(".field-name-call_status_c scrm-dropdownenum-edit select.custom-select");
            if (container || attempts > 10) {
                clearInterval(interval);
                if (!container)
                    return;
                for (let i = 0; i < container.options.length; i++) {
                    const opt = container.options[i];
                    const cleanVal = opt.value?.split(":")[1]?.trim().toLowerCase();
                    const styleInfo = this.CALL_STATUS_STYLES[cleanVal];
                    if (styleInfo && !opt.textContent.trim().startsWith(styleInfo.emoji)) {
                        opt.textContent = `${styleInfo.emoji} ${opt.textContent.trim()}`;
                    }
                }
            }
            attempts++;
        }, 200);
    }
    injectCallStatusDotDetail() {
        let attempts = 0;
        const interval = setInterval(() => {
            const container = document.querySelector(".field-name-call_status_c scrm-dropdownenum-detail");
            if (container || attempts > 10) {
                clearInterval(interval);
                if (!container)
                    return;
                const originalText = container.textContent?.trim() || "";
                const cleanVal = originalText.toLowerCase().replace(/\s+/g, "");
                const styleInfo = this.CALL_STATUS_STYLES[cleanVal];
                if (styleInfo && !originalText.startsWith(styleInfo.emoji)) {
                    container.textContent = `${styleInfo.emoji} ${originalText}`;
                }
            }
            attempts++;
        }, 200);
    }
    applyFlatTagStyle(el, label) {
        const color = this.TAG_COLORS[label.toLowerCase()];
        if (!color)
            return;
        el.style.backgroundColor = color;
        el.style.color = "white";
        el.style.fontSize = "12px";
        el.style.fontWeight = "bold";
        el.style.padding = "2px 8px";
        el.style.borderRadius = "12px";
        el.style.display = "inline-block";
        el.style.margin = "2px";
    }
    injectEditTagColors() {
        let attempts = 0;
        const interval = setInterval(() => {
            const wrapper = document.querySelector(".dynamic-field-name-tag_c p-multiselect");
            const tokens = document.querySelectorAll(".p-multiselect-token, .p-multiselect-item");
            if ((wrapper && tokens.length > 0) || attempts > 10) {
                clearInterval(interval);
                tokens.forEach((el) => {
                    const label = el.textContent?.trim().toLowerCase();
                    this.applyFlatTagStyle(el, label);
                });
                const trigger = wrapper?.querySelector(".p-multiselect-trigger");
                if (trigger) {
                    trigger.addEventListener("click", () => {
                        setTimeout(() => {
                            const items = document.querySelectorAll(".p-multiselect-item");
                            items.forEach((el) => {
                                const label = el.textContent?.trim().toLowerCase();
                                this.applyFlatTagStyle(el, label);
                            });
                        }, 200);
                    });
                }
            }
            attempts++;
        }, 300);
    }
    injectDetailTagColors() {
        let attempts = 0;
        const interval = setInterval(() => {
            const fieldWrapper = document.querySelector("scrm-field.field-name-tag_c");
            const detailItems = fieldWrapper?.querySelectorAll("scrm-multienum-detail li") || [];
            if (detailItems.length > 0 || attempts > 10) {
                clearInterval(interval);
                detailItems.forEach((el) => {
                    const label = el.textContent?.trim().toLowerCase();
                    this.applyFlatTagStyle(el, label);
                });
            }
            attempts++;
        }, 300);
    }
    static { this.ɵfac = function RecordComponent_Factory(t) { return new (t || RecordComponent)(i0.ɵɵdirectiveInject(i1.AppStateStore), i0.ɵɵdirectiveInject(i2.RecordViewStore), i0.ɵɵdirectiveInject(i3.ActivatedRoute), i0.ɵɵdirectiveInject(i4.RecordViewSidebarWidgetService)); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: RecordComponent, selectors: [["scrm-record"]], features: [i0.ɵɵProvidersFeature([
                RecordViewStore,
                RecordActionsAdapter,
                RecordViewSidebarWidgetService,
            ])], decls: 2, vars: 3, consts: [["class", "record-view", 4, "ngIf"], [1, "record-view"], [1, "record-view-position-sticky"], [1, "record-view-hr-container"], [1, "record-view-hr"], [4, "ngIf"]], template: function RecordComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, RecordComponent_div_0_Template, 7, 1, "div", 0);
            i0.ɵɵpipe(1, "async");
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", i0.ɵɵpipeBind1(1, 1, ctx.vm$));
        } }, dependencies: [i5.NgIf, i6.RecordContainerComponent, i7.RecordHeaderComponent, i8.StatusBarComponent, i5.AsyncPipe], encapsulation: 2 }); }
}
export { RecordComponent };
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(RecordComponent, [{
        type: Component,
        args: [{ selector: "scrm-record", providers: [
                    RecordViewStore,
                    RecordActionsAdapter,
                    RecordViewSidebarWidgetService,
                ], template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<!-- Start Record View Section -->\n<div class=\"record-view\" *ngIf=\"(vm$ | async) as vm\">\n\n    <div class=\"record-view-position-sticky\">\n        <scrm-record-header></scrm-record-header>\n    </div>\n    <div class=\"record-view-hr-container\">\n        <hr class=\"record-view-hr\">\n    </div>\n\n    <scrm-status-bar *ngIf=\"showStatusBar\"></scrm-status-bar>\n    <scrm-record-container></scrm-record-container>\n</div>\n<!-- End Record View Section -->\n" }]
    }], function () { return [{ type: i1.AppStateStore }, { type: i2.RecordViewStore }, { type: i3.ActivatedRoute }, { type: i4.RecordViewSidebarWidgetService }]; }, null); })();
//# sourceMappingURL=data:application/json;base64,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