document.addEventListener('DOMContentLoaded', function () {
    console.log("Custom JS Loaded");
  const targetNode = document.body;

  if (!targetNode) {
    console.warn("document.body not ready yet.");
    return;
  }

  const observer = new MutationObserver(() => {
    const dropdown = document.querySelector('select.custom-select');
    if (dropdown && !dropdown.dataset.enhanced) {
      dropdown.dataset.enhanced = "true";
      console.log("Dropdown enhanced via MutationObserver");

      for (let i = 0; i < dropdown.options.length; i++) {
        const option = dropdown.options[i];
        const val = option.value.split(": ")[1];
        if (val) option.classList.add(`option-${val}`);
      }
    }
  });

  observer.observe(targetNode, { childList: true, subtree: true });
});
