/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
import { Component, Input } from '@angular/core';
import { combineLatestWith } from 'rxjs';
import { map } from 'rxjs/operators';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common";
import * as i2 from "../field-grid/field-grid.component";
import * as i3 from "../action-group-menu/action-group-menu.component";
function RecordGridComponent_ng_container_0_div_1_span_2_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "span", 4);
    i0.ɵɵelement(1, "scrm-action-group-menu", 5);
    i0.ɵɵelementEnd();
} if (rf & 2) {
    const ctx_r3 = i0.ɵɵnextContext(3);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("buttonClass", ctx_r3.config.buttonClass)("config", ctx_r3.config.actions);
} }
function RecordGridComponent_ng_container_0_div_1_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementStart(0, "div")(1, "scrm-field-grid", 2);
    i0.ɵɵtemplate(2, RecordGridComponent_ng_container_0_div_1_span_2_Template, 2, 2, "span", 3);
    i0.ɵɵelementEnd()();
} if (rf & 2) {
    const ctx_r1 = i0.ɵɵnextContext(2);
    i0.ɵɵclassMapInterpolate1("record-grid ", ctx_r1.config && ctx_r1.config.klass || "", "");
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("actions", !!ctx_r1.config.actions)("appendActions", ctx_r1.config && ctx_r1.config.appendActions || false)("colClass", ctx_r1.config && ctx_r1.config.colClass)("fieldMode", ctx_r1.mode)("fields", ctx_r1.fields)("record", ctx_r1.record)("inputClass", ctx_r1.config && ctx_r1.config.inputClass)("labelClass", ctx_r1.config && ctx_r1.config.labelClass)("labelDisplay", ctx_r1.config && ctx_r1.config.labelDisplay || "top")("maxColumns", ctx_r1.maxColumns)("record", ctx_r1.record)("rowClass", ctx_r1.config && ctx_r1.config.rowClass)("sizeMap", ctx_r1.sizeMap)("colAlignItems", ctx_r1.config.colAlignItems);
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", ctx_r1.config.actions);
} }
function RecordGridComponent_ng_container_0_Template(rf, ctx) { if (rf & 1) {
    i0.ɵɵelementContainerStart(0);
    i0.ɵɵtemplate(1, RecordGridComponent_ng_container_0_div_1_Template, 3, 18, "div", 1);
    i0.ɵɵpipe(2, "async");
    i0.ɵɵelementContainerEnd();
} if (rf & 2) {
    const ctx_r0 = i0.ɵɵnextContext();
    i0.ɵɵadvance(1);
    i0.ɵɵproperty("ngIf", i0.ɵɵpipeBind1(2, 1, ctx_r0.vm$));
} }
class RecordGridComponent {
    constructor() {
        this.mode = 'detail';
        this.maxColumns = 4;
        this.sizeMap = {
            handset: 1,
            tablet: 2,
            web: 3,
            wide: 4
        };
        this.fields = [];
        this.special = [];
    }
    ngOnInit() {
        if (!this.config) {
            return;
        }
        const config = this.config;
        this.vm$ = config.record$.pipe(combineLatestWith(config.mode$, config.fields$, config.maxColumns$, config.sizeMap$), map(([record, mode, fields, maxColumns, sizeMap]) => {
            this.mode = mode;
            this.maxColumns = maxColumns;
            this.sizeMap = sizeMap;
            this.fields = this.getFields(record, fields);
            this.record = record;
            return { record, mode, fields, maxColumns };
        }));
    }
    getFields(record, fieldKeys) {
        if (!record || !fieldKeys || !record.fields) {
            return [];
        }
        const fields = [];
        fieldKeys.forEach(fieldKey => {
            if (!record.fields[fieldKey]) {
                return;
            }
            fields.push(record.fields[fieldKey]);
        });
        return fields;
    }
    static { this.ɵfac = function RecordGridComponent_Factory(t) { return new (t || RecordGridComponent)(); }; }
    static { this.ɵcmp = /*@__PURE__*/ i0.ɵɵdefineComponent({ type: RecordGridComponent, selectors: [["scrm-record-grid"]], inputs: { config: "config" }, decls: 1, vars: 1, consts: [[4, "ngIf"], [3, "class", 4, "ngIf"], [3, "actions", "appendActions", "colClass", "fieldMode", "fields", "record", "inputClass", "labelClass", "labelDisplay", "maxColumns", "rowClass", "sizeMap", "colAlignItems"], ["class", "float-right", "field-grid-actions", "", 4, "ngIf"], ["field-grid-actions", "", 1, "float-right"], [3, "buttonClass", "config"]], template: function RecordGridComponent_Template(rf, ctx) { if (rf & 1) {
            i0.ɵɵtemplate(0, RecordGridComponent_ng_container_0_Template, 3, 3, "ng-container", 0);
        } if (rf & 2) {
            i0.ɵɵproperty("ngIf", ctx.config);
        } }, dependencies: [i1.NgIf, i2.FieldGridComponent, i3.ActionGroupMenuComponent, i1.AsyncPipe], encapsulation: 2 }); }
}
export { RecordGridComponent };
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(RecordGridComponent, [{
        type: Component,
        args: [{ selector: 'scrm-record-grid', template: "<! --\n/**\n* SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.\n* Copyright (C) 2021 SalesAgility Ltd.\n*\n* This program is free software; you can redistribute it and/or modify it under\n* the terms of the GNU Affero General Public License version 3 as published by the\n* Free Software Foundation with the addition of the following permission added\n* to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK\n* IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE\n* WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.\n*\n* This program is distributed in the hope that it will be useful, but WITHOUT\n* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n* FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more\n* details.\n*\n* You should have received a copy of the GNU Affero General Public License\n* along with this program.  If not, see http://www.gnu.org/licenses.\n*\n* In accordance with Section 7(b) of the GNU Affero General Public License\n* version 3, these Appropriate Legal Notices must retain the display of the\n* \"Supercharged by SuiteCRM\" logo. If the display of the logos is not reasonably\n* feasible for technical reasons, the Appropriate Legal Notices must display\n* the words \"Supercharged by SuiteCRM\".\n*/\n-->\n<ng-container *ngIf=\"config\">\n    <div *ngIf=\"(vm$ | async) as vm\" class=\"record-grid {{(config && config.klass) || ''}}\">\n        <scrm-field-grid [actions]=\"!!config.actions\"\n                         [appendActions]=\"(config && config.appendActions) || false\"\n                         [colClass]=\"config && config.colClass\"\n                         [fieldMode]=\"mode\"\n                         [fields]=\"fields\"\n                         [record]=\"record\"\n                         [inputClass]=\"config && config.inputClass\"\n                         [labelClass]=\"config && config.labelClass\"\n                         [labelDisplay]=\"(config && config.labelDisplay) || 'top'\"\n                         [maxColumns]=\"maxColumns\"\n                         [record]=\"record\"\n                         [rowClass]=\"config && config.rowClass\"\n                         [sizeMap]=\"sizeMap\"\n                         [colAlignItems]=\"config.colAlignItems\"\n        >\n        <span *ngIf=\"config.actions\" class=\"float-right\" field-grid-actions>\n            <scrm-action-group-menu [buttonClass]=\"config.buttonClass\"\n                                    [config]=\"config.actions\"></scrm-action-group-menu>\n        </span>\n        </scrm-field-grid>\n    </div>\n</ng-container>\n" }]
    }], function () { return []; }, { config: [{
            type: Input
        }] }); })();
//# sourceMappingURL=data:application/json;base64,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