/**
 * SuiteCRM is a customer relationship management program developed by SalesAgility Ltd.
 * Copyright (C) 2021 SalesAgility Ltd.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SALESAGILITY, SALESAGILITY DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Supercharged by SuiteCRM" logo. If the display of the logos is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Supercharged by SuiteCRM".
 */
import { Injectable } from '@angular/core';
import { OverridableMap } from 'common';
import { RequiredValidator } from './validators/required.validator';
import { CurrencyValidator } from './validators/currency.validator';
import { DateValidator } from './validators/date.validator';
import { DateTimeValidator } from './validators/datetime.validator';
import { FloatValidator } from './validators/float.validator';
import { IntValidator } from './validators/int.validator';
import { EmailValidator } from './validators/email.validator';
import { PhoneValidator } from './validators/phone.validator';
import { RangeValidator } from './validators/range.validator';
import { PrimaryEmailValidator } from './validators/primary-email.validator';
import { DuplicateEmailValidator } from './validators/duplicate-email.validator';
import { LineItemsRequiredValidator } from "./validators/line-items-required.validator";
import * as i0 from "@angular/core";
import * as i1 from "./validators/required.validator";
import * as i2 from "./validators/range.validator";
import * as i3 from "./validators/currency.validator";
import * as i4 from "./validators/date.validator";
import * as i5 from "./validators/datetime.validator";
import * as i6 from "./validators/email.validator";
import * as i7 from "./validators/float.validator";
import * as i8 from "./validators/int.validator";
import * as i9 from "./validators/phone.validator";
import * as i10 from "./validators/primary-email.validator";
import * as i11 from "./validators/duplicate-email.validator";
import * as i12 from "./validators/line-items-required.validator";
class ValidationManager {
    constructor(requiredValidator, rangeValidator, currencyValidator, dateValidator, datetimeValidator, emailValidator, floatValidator, intValidator, phoneValidator, primaryEmailValidator, duplicateEmailValidator, lineItemsRequiredValidator) {
        this.requiredValidator = requiredValidator;
        this.rangeValidator = rangeValidator;
        this.currencyValidator = currencyValidator;
        this.dateValidator = dateValidator;
        this.datetimeValidator = datetimeValidator;
        this.emailValidator = emailValidator;
        this.floatValidator = floatValidator;
        this.intValidator = intValidator;
        this.phoneValidator = phoneValidator;
        this.primaryEmailValidator = primaryEmailValidator;
        this.duplicateEmailValidator = duplicateEmailValidator;
        this.lineItemsRequiredValidator = lineItemsRequiredValidator;
        this.filterFieldExclusion = {
            default: {}
        };
        this.saveFieldExclusions = {
            default: {}
        };
        this.saveValidators = new OverridableMap();
        this.itemFormArraySaveValidators = new OverridableMap();
        this.asyncSaveValidators = new OverridableMap();
        this.filterValidators = new OverridableMap();
        this.saveValidators.addEntry('default', this.getKey('required', 'all'), requiredValidator);
        this.saveValidators.addEntry('default', this.getKey('range', 'all'), rangeValidator);
        this.saveValidators.addEntry('default', this.getKey('currency', 'all'), currencyValidator);
        this.saveValidators.addEntry('default', this.getKey('date', 'all'), dateValidator);
        this.saveValidators.addEntry('default', this.getKey('datetime', 'all'), datetimeValidator);
        this.saveValidators.addEntry('default', this.getKey('email', 'all'), emailValidator);
        this.saveValidators.addEntry('default', this.getKey('float', 'all'), floatValidator);
        this.saveValidators.addEntry('default', this.getKey('int', 'all'), intValidator);
        this.saveValidators.addEntry('default', this.getKey('phone', 'all'), phoneValidator);
        this.itemFormArraySaveValidators.addEntry('default', this.getKey('primary-email', 'all'), primaryEmailValidator);
        this.itemFormArraySaveValidators.addEntry('default', this.getKey('duplicate-email', 'all'), duplicateEmailValidator);
        this.itemFormArraySaveValidators.addEntry('default', this.getKey('line-items-required', 'all'), lineItemsRequiredValidator);
        this.filterValidators.addEntry('default', this.getKey('date', 'all'), dateValidator);
        this.filterValidators.addEntry('default', this.getKey('datetime', 'all'), datetimeValidator);
        this.filterValidators.addEntry('default', this.getKey('float', 'all'), floatValidator);
        this.filterValidators.addEntry('default', this.getKey('currency', 'all'), currencyValidator);
        this.filterValidators.addEntry('default', this.getKey('int', 'all'), intValidator);
        this.filterValidators.addEntry('default', this.getKey('phone', 'all'), phoneValidator);
    }
    registerFieldSaveValidator(module, type, field, validator) {
        this.saveValidators.addEntry(module, this.getKey(type, field), validator);
    }
    registerSaveValidator(module, type, validator) {
        this.saveValidators.addEntry(module, this.getKey(type, 'all'), validator);
    }
    registerFieldFilterValidator(module, type, field, validator) {
        this.filterValidators.addEntry(module, this.getKey(type, field), validator);
    }
    registerFilterValidator(module, type, validator) {
        this.filterValidators.addEntry(module, this.getKey(type, 'all'), validator);
    }
    excludeFieldSaveValidator(module, type, field) {
        const moduleExclusions = this.saveFieldExclusions[module] || {};
        const key = this.getKey(type, field);
        moduleExclusions[key] = key;
        this.saveFieldExclusions[module] = moduleExclusions;
    }
    excludeSaveValidator(module, type) {
        this.saveValidators.excludeEntry(module, this.getKey(type, 'all'));
    }
    excludeFieldFilterValidator(module, type, field) {
        const moduleExclusions = this.filterFieldExclusion[module] || {};
        const key = this.getKey(type, field);
        moduleExclusions[key] = key;
        this.filterFieldExclusion[module] = moduleExclusions;
    }
    excludeFilterValidator(module, type) {
        this.filterValidators.excludeEntry(module, this.getKey(type, 'all'));
    }
    registerAsyncSaveValidator(module, type, validator) {
        this.asyncSaveValidators.addEntry(module, this.getKey(type, 'all'), validator);
    }
    excludeAsyncSaveValidator(module, type) {
        this.saveValidators.excludeEntry(module, this.getKey(type, 'all'));
    }
    getSaveValidations(module, viewField, record) {
        const entries = this.saveValidators.getGroupEntries(module);
        const exclusions = this.getExclusions(module, this.saveFieldExclusions);
        return this.filterValidations(entries, exclusions, record, viewField);
    }
    getItemFormArraySaveValidations(module, viewField, record) {
        const entries = this.itemFormArraySaveValidators.getGroupEntries(module);
        const exclusions = this.getExclusions(module, this.saveFieldExclusions);
        return this.filterValidations(entries, exclusions, record, viewField);
    }
    getFilterValidations(module, viewField, record) {
        const entries = this.filterValidators.getGroupEntries(module);
        const exclusions = this.getExclusions(module, this.filterFieldExclusion);
        return this.filterValidations(entries, exclusions, record, viewField);
    }
    getAsyncSaveValidations(module, viewField, record) {
        const validations = [];
        const entries = this.asyncSaveValidators.getGroupEntries(module);
        Object.keys(entries).forEach(validatorKey => {
            const validator = entries[validatorKey];
            if (validator.applies(record, viewField)) {
                validations.push(validator.getValidator(viewField, record));
            }
        });
        return validations;
    }
    getKey(type, field) {
        return `${type}.${field}`;
    }
    parseType(key) {
        const partsType = key.split('.') || [];
        return partsType[0] || '';
    }
    getExclusions(module, exclusionMap) {
        const defaultExclusions = exclusionMap['default'] || {};
        const moduleExclusions = exclusionMap[module] || {};
        return { ...defaultExclusions, ...moduleExclusions };
    }
    filterValidations(entries, fieldExclusions, record, viewField) {
        let validations = [];
        Object.keys(entries).forEach(validatorKey => {
            const defaultTypeKey = this.getKey(this.parseType(validatorKey), viewField.name);
            if (fieldExclusions[validatorKey] || fieldExclusions[defaultTypeKey]) {
                return;
            }
            const validator = entries[validatorKey];
            if (validator.applies(record, viewField)) {
                validations = validations.concat(validator.getValidator(viewField, record));
            }
        });
        return validations;
    }
    static { this.ɵfac = function ValidationManager_Factory(t) { return new (t || ValidationManager)(i0.ɵɵinject(i1.RequiredValidator), i0.ɵɵinject(i2.RangeValidator), i0.ɵɵinject(i3.CurrencyValidator), i0.ɵɵinject(i4.DateValidator), i0.ɵɵinject(i5.DateTimeValidator), i0.ɵɵinject(i6.EmailValidator), i0.ɵɵinject(i7.FloatValidator), i0.ɵɵinject(i8.IntValidator), i0.ɵɵinject(i9.PhoneValidator), i0.ɵɵinject(i10.PrimaryEmailValidator), i0.ɵɵinject(i11.DuplicateEmailValidator), i0.ɵɵinject(i12.LineItemsRequiredValidator)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: ValidationManager, factory: ValidationManager.ɵfac, providedIn: 'root' }); }
}
export { ValidationManager };
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(ValidationManager, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return [{ type: i1.RequiredValidator }, { type: i2.RangeValidator }, { type: i3.CurrencyValidator }, { type: i4.DateValidator }, { type: i5.DateTimeValidator }, { type: i6.EmailValidator }, { type: i7.FloatValidator }, { type: i8.IntValidator }, { type: i9.PhoneValidator }, { type: i10.PrimaryEmailValidator }, { type: i11.DuplicateEmailValidator }, { type: i12.LineItemsRequiredValidator }]; }, null); })();
//# sourceMappingURL=data:application/json;base64,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