import { Injectable } from '@angular/core';
import { NumberFormatter } from '../../../formatters/number/number-formatter.service';
import * as i0 from "@angular/core";
import * as i1 from "../../../formatters/number/number-formatter.service";
export const floatValidator = (formatter) => ((control) => {
    const invalid = formatter.validateFloatUserFormat(control.value);
    return invalid ? {
        floatValidator: {
            valid: false,
            format: formatter.getFloatUserFormatPattern(),
            message: {
                labelKey: 'LBL_VALIDATION_ERROR_FLOAT_FORMAT',
                context: {
                    value: control.value,
                    expected: formatter.toUserFormat('1000.50')
                }
            }
        },
    } : null;
});
class FloatValidator {
    constructor(formatter) {
        this.formatter = formatter;
    }
    applies(record, viewField) {
        if (!viewField || !viewField.fieldDefinition) {
            return false;
        }
        return viewField.type === 'float';
    }
    getValidator(viewField) {
        if (!viewField || !viewField.fieldDefinition) {
            return [];
        }
        return [floatValidator(this.formatter)];
    }
    static { this.ɵfac = function FloatValidator_Factory(t) { return new (t || FloatValidator)(i0.ɵɵinject(i1.NumberFormatter)); }; }
    static { this.ɵprov = /*@__PURE__*/ i0.ɵɵdefineInjectable({ token: FloatValidator, factory: FloatValidator.ɵfac, providedIn: 'root' }); }
}
export { FloatValidator };
(function () { (typeof ngDevMode === "undefined" || ngDevMode) && i0.ɵsetClassMetadata(FloatValidator, [{
        type: Injectable,
        args: [{
                providedIn: 'root'
            }]
    }], function () { return [{ type: i1.NumberFormatter }]; }, null); })();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZmxvYXQudmFsaWRhdG9yLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vLi4vLi4vY29yZS9hcHAvY29yZS9zcmMvbGliL3NlcnZpY2VzL3JlY29yZC92YWxpZGF0aW9uL3ZhbGlkYXRvcnMvZmxvYXQudmFsaWRhdG9yLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQThCQSxPQUFPLEVBQUMsVUFBVSxFQUFDLE1BQU0sZUFBZSxDQUFDO0FBQ3pDLE9BQU8sRUFBQyxlQUFlLEVBQUMsTUFBTSxxREFBcUQsQ0FBQzs7O0FBR3BGLE1BQU0sQ0FBQyxNQUFNLGNBQWMsR0FBRyxDQUFDLFNBQTBCLEVBQXVCLEVBQUUsQ0FBQyxDQUMvRSxDQUFDLE9BQXdCLEVBQW1DLEVBQUU7SUFFMUQsTUFBTSxPQUFPLEdBQUcsU0FBUyxDQUFDLHVCQUF1QixDQUFDLE9BQU8sQ0FBQyxLQUFLLENBQUMsQ0FBQztJQUNqRSxPQUFPLE9BQU8sQ0FBQyxDQUFDLENBQUM7UUFDYixjQUFjLEVBQUU7WUFDWixLQUFLLEVBQUUsS0FBSztZQUNaLE1BQU0sRUFBRSxTQUFTLENBQUMseUJBQXlCLEVBQUU7WUFDN0MsT0FBTyxFQUFFO2dCQUNMLFFBQVEsRUFBRSxtQ0FBbUM7Z0JBQzdDLE9BQU8sRUFBRTtvQkFDTCxLQUFLLEVBQUUsT0FBTyxDQUFDLEtBQUs7b0JBQ3BCLFFBQVEsRUFBRSxTQUFTLENBQUMsWUFBWSxDQUFDLFNBQVMsQ0FBQztpQkFDOUM7YUFDSjtTQUNKO0tBQ0osQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDO0FBQ2IsQ0FBQyxDQUNKLENBQUM7QUFFRixNQUdhLGNBQWM7SUFFdkIsWUFBc0IsU0FBMEI7UUFBMUIsY0FBUyxHQUFULFNBQVMsQ0FBaUI7SUFDaEQsQ0FBQztJQUVELE9BQU8sQ0FBQyxNQUFjLEVBQUUsU0FBOEI7UUFDbEQsSUFBSSxDQUFDLFNBQVMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxlQUFlLEVBQUU7WUFDMUMsT0FBTyxLQUFLLENBQUM7U0FDaEI7UUFFRCxPQUFPLFNBQVMsQ0FBQyxJQUFJLEtBQUssT0FBTyxDQUFDO0lBQ3RDLENBQUM7SUFFRCxZQUFZLENBQUMsU0FBOEI7UUFFdkMsSUFBSSxDQUFDLFNBQVMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxlQUFlLEVBQUU7WUFDMUMsT0FBTyxFQUFFLENBQUM7U0FDYjtRQUVELE9BQU8sQ0FBQyxjQUFjLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUM7SUFDNUMsQ0FBQzsrRUFwQlEsY0FBYzt1RUFBZCxjQUFjLFdBQWQsY0FBYyxtQkFGWCxNQUFNOztTQUVULGNBQWM7dUZBQWQsY0FBYztjQUgxQixVQUFVO2VBQUM7Z0JBQ1IsVUFBVSxFQUFFLE1BQU07YUFDckIiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIFN1aXRlQ1JNIGlzIGEgY3VzdG9tZXIgcmVsYXRpb25zaGlwIG1hbmFnZW1lbnQgcHJvZ3JhbSBkZXZlbG9wZWQgYnkgU2FsZXNBZ2lsaXR5IEx0ZC5cbiAqIENvcHlyaWdodCAoQykgMjAyMSBTYWxlc0FnaWxpdHkgTHRkLlxuICpcbiAqIFRoaXMgcHJvZ3JhbSBpcyBmcmVlIHNvZnR3YXJlOyB5b3UgY2FuIHJlZGlzdHJpYnV0ZSBpdCBhbmQvb3IgbW9kaWZ5IGl0IHVuZGVyXG4gKiB0aGUgdGVybXMgb2YgdGhlIEdOVSBBZmZlcm8gR2VuZXJhbCBQdWJsaWMgTGljZW5zZSB2ZXJzaW9uIDMgYXMgcHVibGlzaGVkIGJ5IHRoZVxuICogRnJlZSBTb2Z0d2FyZSBGb3VuZGF0aW9uIHdpdGggdGhlIGFkZGl0aW9uIG9mIHRoZSBmb2xsb3dpbmcgcGVybWlzc2lvbiBhZGRlZFxuICogdG8gU2VjdGlvbiAxNSBhcyBwZXJtaXR0ZWQgaW4gU2VjdGlvbiA3KGEpOiBGT1IgQU5ZIFBBUlQgT0YgVEhFIENPVkVSRUQgV09SS1xuICogSU4gV0hJQ0ggVEhFIENPUFlSSUdIVCBJUyBPV05FRCBCWSBTQUxFU0FHSUxJVFksIFNBTEVTQUdJTElUWSBESVNDTEFJTVMgVEhFXG4gKiBXQVJSQU5UWSBPRiBOT04gSU5GUklOR0VNRU5UIE9GIFRISVJEIFBBUlRZIFJJR0hUUy5cbiAqXG4gKiBUaGlzIHByb2dyYW0gaXMgZGlzdHJpYnV0ZWQgaW4gdGhlIGhvcGUgdGhhdCBpdCB3aWxsIGJlIHVzZWZ1bCwgYnV0IFdJVEhPVVRcbiAqIEFOWSBXQVJSQU5UWTsgd2l0aG91dCBldmVuIHRoZSBpbXBsaWVkIHdhcnJhbnR5IG9mIE1FUkNIQU5UQUJJTElUWSBvciBGSVRORVNTXG4gKiBGT1IgQSBQQVJUSUNVTEFSIFBVUlBPU0UuIFNlZSB0aGUgR05VIEFmZmVybyBHZW5lcmFsIFB1YmxpYyBMaWNlbnNlIGZvciBtb3JlXG4gKiBkZXRhaWxzLlxuICpcbiAqIFlvdSBzaG91bGQgaGF2ZSByZWNlaXZlZCBhIGNvcHkgb2YgdGhlIEdOVSBBZmZlcm8gR2VuZXJhbCBQdWJsaWMgTGljZW5zZVxuICogYWxvbmcgd2l0aCB0aGlzIHByb2dyYW0uICBJZiBub3QsIHNlZSA8aHR0cDovL3d3dy5nbnUub3JnL2xpY2Vuc2VzLz4uXG4gKlxuICogSW4gYWNjb3JkYW5jZSB3aXRoIFNlY3Rpb24gNyhiKSBvZiB0aGUgR05VIEFmZmVybyBHZW5lcmFsIFB1YmxpYyBMaWNlbnNlXG4gKiB2ZXJzaW9uIDMsIHRoZXNlIEFwcHJvcHJpYXRlIExlZ2FsIE5vdGljZXMgbXVzdCByZXRhaW4gdGhlIGRpc3BsYXkgb2YgdGhlXG4gKiBcIlN1cGVyY2hhcmdlZCBieSBTdWl0ZUNSTVwiIGxvZ28uIElmIHRoZSBkaXNwbGF5IG9mIHRoZSBsb2dvcyBpcyBub3QgcmVhc29uYWJseVxuICogZmVhc2libGUgZm9yIHRlY2huaWNhbCByZWFzb25zLCB0aGUgQXBwcm9wcmlhdGUgTGVnYWwgTm90aWNlcyBtdXN0IGRpc3BsYXlcbiAqIHRoZSB3b3JkcyBcIlN1cGVyY2hhcmdlZCBieSBTdWl0ZUNSTVwiLlxuICovXG5cbmltcG9ydCB7VmFsaWRhdG9ySW50ZXJmYWNlfSBmcm9tICcuLi92YWxpZGF0b3IuSW50ZXJmYWNlJztcbmltcG9ydCB7QWJzdHJhY3RDb250cm9sfSBmcm9tICdAYW5ndWxhci9mb3Jtcyc7XG5pbXBvcnQge1JlY29yZH0gZnJvbSAnY29tbW9uJztcbmltcG9ydCB7Vmlld0ZpZWxkRGVmaW5pdGlvbn0gZnJvbSAnY29tbW9uJztcbmltcG9ydCB7SW5qZWN0YWJsZX0gZnJvbSAnQGFuZ3VsYXIvY29yZSc7XG5pbXBvcnQge051bWJlckZvcm1hdHRlcn0gZnJvbSAnLi4vLi4vLi4vZm9ybWF0dGVycy9udW1iZXIvbnVtYmVyLWZvcm1hdHRlci5zZXJ2aWNlJztcbmltcG9ydCB7U3RhbmRhcmRWYWxpZGF0aW9uRXJyb3JzLCBTdGFuZGFyZFZhbGlkYXRvckZufSBmcm9tICdjb21tb24nO1xuXG5leHBvcnQgY29uc3QgZmxvYXRWYWxpZGF0b3IgPSAoZm9ybWF0dGVyOiBOdW1iZXJGb3JtYXR0ZXIpOiBTdGFuZGFyZFZhbGlkYXRvckZuID0+IChcbiAgICAoY29udHJvbDogQWJzdHJhY3RDb250cm9sKTogU3RhbmRhcmRWYWxpZGF0aW9uRXJyb3JzIHwgbnVsbCA9PiB7XG5cbiAgICAgICAgY29uc3QgaW52YWxpZCA9IGZvcm1hdHRlci52YWxpZGF0ZUZsb2F0VXNlckZvcm1hdChjb250cm9sLnZhbHVlKTtcbiAgICAgICAgcmV0dXJuIGludmFsaWQgPyB7XG4gICAgICAgICAgICBmbG9hdFZhbGlkYXRvcjoge1xuICAgICAgICAgICAgICAgIHZhbGlkOiBmYWxzZSxcbiAgICAgICAgICAgICAgICBmb3JtYXQ6IGZvcm1hdHRlci5nZXRGbG9hdFVzZXJGb3JtYXRQYXR0ZXJuKCksXG4gICAgICAgICAgICAgICAgbWVzc2FnZToge1xuICAgICAgICAgICAgICAgICAgICBsYWJlbEtleTogJ0xCTF9WQUxJREFUSU9OX0VSUk9SX0ZMT0FUX0ZPUk1BVCcsXG4gICAgICAgICAgICAgICAgICAgIGNvbnRleHQ6IHtcbiAgICAgICAgICAgICAgICAgICAgICAgIHZhbHVlOiBjb250cm9sLnZhbHVlLFxuICAgICAgICAgICAgICAgICAgICAgICAgZXhwZWN0ZWQ6IGZvcm1hdHRlci50b1VzZXJGb3JtYXQoJzEwMDAuNTAnKVxuICAgICAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfSxcbiAgICAgICAgfSA6IG51bGw7XG4gICAgfVxuKTtcblxuQEluamVjdGFibGUoe1xuICAgIHByb3ZpZGVkSW46ICdyb290J1xufSlcbmV4cG9ydCBjbGFzcyBGbG9hdFZhbGlkYXRvciBpbXBsZW1lbnRzIFZhbGlkYXRvckludGVyZmFjZSB7XG5cbiAgICBjb25zdHJ1Y3Rvcihwcm90ZWN0ZWQgZm9ybWF0dGVyOiBOdW1iZXJGb3JtYXR0ZXIpIHtcbiAgICB9XG5cbiAgICBhcHBsaWVzKHJlY29yZDogUmVjb3JkLCB2aWV3RmllbGQ6IFZpZXdGaWVsZERlZmluaXRpb24pOiBib29sZWFuIHtcbiAgICAgICAgaWYgKCF2aWV3RmllbGQgfHwgIXZpZXdGaWVsZC5maWVsZERlZmluaXRpb24pIHtcbiAgICAgICAgICAgIHJldHVybiBmYWxzZTtcbiAgICAgICAgfVxuXG4gICAgICAgIHJldHVybiB2aWV3RmllbGQudHlwZSA9PT0gJ2Zsb2F0JztcbiAgICB9XG5cbiAgICBnZXRWYWxpZGF0b3Iodmlld0ZpZWxkOiBWaWV3RmllbGREZWZpbml0aW9uKTogU3RhbmRhcmRWYWxpZGF0b3JGbltdIHtcblxuICAgICAgICBpZiAoIXZpZXdGaWVsZCB8fCAhdmlld0ZpZWxkLmZpZWxkRGVmaW5pdGlvbikge1xuICAgICAgICAgICAgcmV0dXJuIFtdO1xuICAgICAgICB9XG5cbiAgICAgICAgcmV0dXJuIFtmbG9hdFZhbGlkYXRvcih0aGlzLmZvcm1hdHRlcildO1xuICAgIH1cbn1cbiJdfQ==